/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat.gui.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.replaceitem.symbolchat.SearchUtil;
import net.replaceitem.symbolchat.SymbolChat;
import net.replaceitem.symbolchat.SymbolInsertable;
import net.replaceitem.symbolchat.SymbolSuggestable;
import net.replaceitem.symbolchat.gui.widget.symbolButton.PasteSymbolButtonWidget;
import net.replaceitem.symbolchat.resource.SymbolManager;
import net.replaceitem.symbolchat.resource.SymbolTab;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class SymbolSuggestor
extends class_362
implements class_4068,
class_6379,
PasteSymbolButtonWidget.Context {
    private final class_437 screen;
    private final SymbolInsertable symbolInsertable;
    private final SymbolSuggestable suggestable;
    public static final int HEIGHT = 14;
    private int x;
    private int y;
    private int width;
    private boolean visible;
    private int focusedElement;
    private int elementCount;
    private final List<PasteSymbolButtonWidget> symbolButtons = new ArrayList<PasteSymbolButtonWidget>();

    public SymbolSuggestor(class_437 screen, SymbolInsertable symbolInsertable, SymbolSuggestable suggestable) {
        this.screen = screen;
        this.symbolInsertable = symbolInsertable;
        this.suggestable = suggestable;
        this.elementCount = 0;
        this.focusedElement = -1;
        this.visible = false;
    }

    @Override
    public void onSymbolClicked(String symbol) {
        this.symbolInsertable.insertSymbol(symbol);
    }

    @Override
    public void refresh() {
        Vector2i cursorPosition = this.suggestable.getCursorPosition();
        this.x = cursorPosition.x;
        this.y = cursorPosition.y - 14 - 3;
        String search = this.suggestable.getSuggestionTerm();
        int fittingSymbols = Math.floorDiv(this.screen.field_22789, 13);
        int shownSymbols = Math.min(fittingSymbols, SymbolChat.config.getMaxSymbolSuggestions());
        this.symbolButtons.clear();
        if (search == null) {
            this.elementCount = 0;
        } else {
            Stream<String> searchStream = search.isBlank() ? SymbolChat.symbolManager.getFavoriteSymbols() : SearchUtil.performSearch(SymbolChat.symbolManager.getTab(SymbolManager.ALL_IDENTIFIER).map(SymbolTab::streamSymbols).orElseGet(() -> Stream.of(new String[0])), search);
            List<String> symbols = searchStream.limit(shownSymbols).toList();
            this.elementCount = symbols.size();
            this.width = 1 + 13 * this.elementCount;
            this.x = Math.max(Math.min(this.x, this.screen.field_22789 - this.width), 0);
            for (int i = 0; i < this.elementCount; ++i) {
                this.symbolButtons.add(new PasteSymbolButtonWidget(this.x + 1 + i * 13, this.y + 1, this, symbols.get(i)));
            }
        }
        this.visible = this.elementCount != 0;
        this.method_25365(this.visible && this.method_25370());
        this.setFocusedElement(this.focusedElement);
    }

    private void setFocusedElement(int focused) {
        if (focused >= this.elementCount) {
            focused = -1;
        }
        this.focusedElement = class_3532.method_15340((int)focused, (int)-1, (int)(this.elementCount - 1));
        PasteSymbolButtonWidget focus = this.focusedElement == -1 ? null : this.symbolButtons.get(this.focusedElement);
        this.method_25395(focus);
    }

    @Nullable
    public class_364 method_25399() {
        if (this.focusedElement < 0 || this.focusedElement >= this.symbolButtons.size()) {
            return null;
        }
        return this.symbolButtons.get(this.focusedElement);
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        if (!this.visible) {
            return;
        }
        drawContext.method_51448().method_22903();
        drawContext.method_51448().method_22904(0.0, 0.0, 350.0);
        drawContext.method_25294(this.x, this.y, this.x + this.width, this.y + 14, SymbolChat.config.getHudColor());
        for (class_4068 class_40682 : this.symbolButtons) {
            class_40682.method_25394(drawContext, mouseX, mouseY, delta);
        }
        drawContext.method_51448().method_22909();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.visible) {
            return false;
        }
        if (keyCode == 258) {
            PasteSymbolButtonWidget focused;
            class_364 class_3642 = this.method_25399();
            if (class_3642 instanceof PasteSymbolButtonWidget) {
                PasteSymbolButtonWidget pasteSymbolButtonWidget;
                focused = pasteSymbolButtonWidget = (PasteSymbolButtonWidget)class_3642;
            } else if (!this.symbolButtons.isEmpty()) {
                focused = this.symbolButtons.get(0);
            } else {
                return false;
            }
            focused.onClick(0);
            this.hide();
            return true;
        }
        if (keyCode == 265) {
            if (this.method_25399() == null && !this.symbolButtons.isEmpty()) {
                this.setFocusedElement(0);
            }
            return true;
        }
        if (keyCode == 262 && this.method_25399() != null) {
            this.setFocusedElement(Math.min(this.focusedElement + 1, this.elementCount - 1));
            return true;
        }
        if (keyCode == 263 && this.method_25399() != null) {
            if (this.focusedElement != 0) {
                this.setFocusedElement(this.focusedElement - 1);
            }
            return true;
        }
        if ((keyCode == 264 || keyCode == 256) && this.method_25399() != null) {
            this.setFocusedElement(-1);
            return true;
        }
        if (keyCode == 257 && this.method_25399() != null && this.focusedElement >= 0) {
            int buttonIndex = class_3532.method_15340((int)this.focusedElement, (int)0, (int)(this.symbolButtons.size() - 1));
            this.symbolButtons.get(buttonIndex).onClick(0);
            this.hide();
            return true;
        }
        return false;
    }

    private void hide() {
        this.setFocusedElement(-1);
        this.visible = false;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 builder) {
    }

    public List<? extends class_364> method_25396() {
        return this.symbolButtons;
    }

    public boolean isVisible() {
        return this.visible;
    }
}

