/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat.gui;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.IntStream;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_7842;
import net.minecraft.class_7845;
import net.minecraft.class_7852;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.replaceitem.symbolchat.SymbolChat;
import net.replaceitem.symbolchat.TextRendererAccess;
import net.replaceitem.symbolchat.Util;
import net.replaceitem.symbolchat.gui.widget.symbolButton.PasteSymbolButtonWidget;

public class UnicodeTableScreen
extends class_437
implements PasteSymbolButtonWidget.Context {
    private final class_437 parent;
    private class_342 pageTextField;
    private class_342 searchTextField;
    private class_4286 showBlocksWidget;
    private class_4286 hideMissingGlyphs;
    private class_4185 copySelectedButton;
    private class_4185 favoriteSymbolButton;
    private int selectionStart = -1;
    private int selectionEnd = -1;
    int page = 0;
    public static final int TOOLBAR_HEIGHT = 40;
    private IntList codepoints = new IntArrayList();
    private final int[] CYCLING_BLOCK_COLORS = new int[]{-8388608, -8355840, -16744448, -16744320, -16777088, -8388480};
    private int scroll;
    private int columns;
    private int screenRows;
    private final List<PasteSymbolButtonWidget> widgets = new ArrayList<PasteSymbolButtonWidget>();

    public UnicodeTableScreen(class_437 parent) {
        super(class_2561.method_30163((String)"Unicode Table"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.columns = this.field_22789 / 13;
        this.screenRows = this.field_22790 / 13;
        class_7845 topRowGridWidget = new class_7845(2, 2);
        topRowGridWidget.method_48635(2);
        class_7845.class_7939 topRowAdder = topRowGridWidget.method_47610(Integer.MAX_VALUE);
        class_7842 pageTextWidget = new class_7842((class_2561)class_2561.method_43471((String)"symbolchat.page"), this.field_22793);
        pageTextWidget.method_46421(0);
        pageTextWidget.method_46419(0);
        topRowAdder.method_47612((class_8021)pageTextWidget);
        this.pageTextField = new class_342(this.field_22793, 0, 0, 20, 12, (class_2561)class_2561.method_43473());
        this.pageTextField.method_1852("0");
        this.pageTextField.method_1880(2);
        this.pageTextField.method_1863(s -> {
            try {
                this.page = Integer.parseInt(this.pageTextField.method_1882());
            }
            catch (NumberFormatException e) {
                this.page = 0;
            }
            this.reloadSymbols();
        });
        topRowAdder.method_47612((class_8021)this.pageTextField);
        topRowAdder.method_47612((class_8021)class_7852.method_46512((int)10));
        class_7842 searchTextWidget = new class_7842((class_2561)class_2561.method_43471((String)"symbolchat.search"), this.field_22793);
        searchTextWidget.method_46421(0);
        searchTextWidget.method_46419(0);
        topRowAdder.method_47612((class_8021)searchTextWidget);
        this.searchTextField = new class_342(this.field_22793, 0, 0, 150, 12, class_2561.method_30163((String)""));
        this.searchTextField.method_1863(s -> this.reloadSymbols());
        topRowAdder.method_47612((class_8021)this.searchTextField);
        topRowGridWidget.method_48222();
        topRowGridWidget.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        class_7845 bottomRowGridWidget = new class_7845(2, 18);
        class_7845.class_7939 bottomRowAdder = bottomRowGridWidget.method_47610(Integer.MAX_VALUE);
        this.copySelectedButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udccb ").method_10852((class_2561)class_2561.method_43471((String)"symbolchat.copy_selected")), button -> this.copySelected()).method_46434(0, 0, 100, 20).method_46431();
        bottomRowAdder.method_47612((class_8021)this.copySelectedButton);
        this.favoriteSymbolButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2729 ").method_10852((class_2561)class_2561.method_43471((String)"symbolchat.favorite_symbol")), button -> this.favoriteSymbols()).method_46434(0, 0, 140, 20).method_46431();
        bottomRowAdder.method_47612((class_8021)this.favoriteSymbolButton);
        if (!SymbolChat.clothConfigEnabled) {
            this.favoriteSymbolButton.field_22763 = false;
            this.favoriteSymbolButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"symbolchat.no_clothconfig")));
        }
        bottomRowAdder.method_47612((class_8021)class_7852.method_46512((int)5));
        class_5250 showBlocksText = class_2561.method_43471((String)"symbolchat.show_blocks");
        this.showBlocksWidget = class_4286.method_54787((class_2561)showBlocksText, (class_327)this.field_22793).method_54791((checkbox, checked) -> this.refreshButtons()).method_54788();
        bottomRowAdder.method_47612((class_8021)this.showBlocksWidget);
        bottomRowAdder.method_47612((class_8021)class_7852.method_46512((int)5));
        this.hideMissingGlyphs = class_4286.method_54787((class_2561)class_2561.method_43471((String)"symbolchat.hide_missing_glyphs"), (class_327)this.field_22793).method_54791((checkbox, checked) -> this.reloadSymbols()).method_54788();
        bottomRowAdder.method_47612((class_8021)this.hideMissingGlyphs);
        bottomRowGridWidget.method_48222();
        bottomRowGridWidget.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.reloadSymbols();
    }

    private IntStream getSelectedSymbols() {
        IntStream.Builder intStreamBuilder = IntStream.builder();
        for (int i = this.selectionStart; i <= this.selectionEnd; ++i) {
            int codepoint = this.codepoints.getInt(i);
            intStreamBuilder.add(codepoint & 0xFFFFFF);
        }
        return intStreamBuilder.build();
    }

    private void favoriteSymbols() {
        if (this.selectionStart == -1) {
            return;
        }
        IntStream selectedSymbols = this.getSelectedSymbols();
        SymbolChat.config.toggleFavorite(selectedSymbols.mapToObj(Character::toString));
        this.refreshButtons();
    }

    private void copySelected() {
        if (this.selectionStart == -1) {
            return;
        }
        class_310.method_1551().field_1774.method_1455(Util.stringFromCodePoints(this.getSelectedSymbols()));
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.refreshButtons();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        for (PasteSymbolButtonWidget widget : this.widgets) {
            widget.method_25394(context, mouseX, mouseY, delta);
        }
        int scrollbarRows = Math.max(class_3532.method_38788((int)this.codepoints.size(), (int)this.columns), this.screenRows);
        double visibleRatio = (double)this.screenRows / (double)scrollbarRows;
        int scrollbarHeight = (int)(visibleRatio * (double)(this.field_22790 - 40));
        int scrollbarY = (int)class_3532.method_37958((float)this.scroll, (float)0.0f, (float)(scrollbarRows - this.screenRows), (float)40.0f, (float)(this.field_22790 - scrollbarHeight));
        context.method_25294(this.field_22789 - 2, scrollbarY, this.field_22789 - 1, scrollbarY + scrollbarHeight, -6250336);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (PasteSymbolButtonWidget widget : this.widgets) {
            if (!widget.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void reloadSymbols() {
        this.pageTextField.field_22763 = this.searchTextField.method_1882().isBlank();
        this.searchCodePoints();
        this.refreshButtons();
    }

    private void searchCodePoints() {
        this.selectionStart = -1;
        this.selectionEnd = -1;
        String search = this.searchTextField.method_1882().toUpperCase(Locale.ROOT);
        boolean searching = search.isBlank();
        CodePointCollector collector = new CodePointCollector();
        if (searching) {
            int codepoint;
            int pageMask = this.page << 16;
            for (int i = 0; i <= 65535 && Character.isValidCodePoint(codepoint = pageMask | i); ++i) {
                collector.accept(codepoint);
            }
        } else {
            int codepoint = 0;
            while (Character.isValidCodePoint(codepoint)) {
                String name = Character.getName(codepoint);
                if (name != null && UnicodeTableScreen.isRelevant(name, search)) {
                    collector.accept(codepoint);
                }
                ++codepoint;
            }
        }
        this.codepoints = collector.getCodepoints();
    }

    @Override
    public void onSymbolClicked(String symbol) {
        this.refresh();
    }

    @Override
    public void refresh() {
        this.refreshButtons();
    }

    private static boolean isRelevant(String name, String search) {
        for (String s : search.split(" ")) {
            if (name.contains(s)) continue;
            return false;
        }
        return true;
    }

    private void refreshButtons() {
        boolean buttonsActive;
        this.columns = this.field_22789 / 13;
        this.screenRows = (this.field_22790 - 40) / 13;
        this.scroll = class_3532.method_15340((int)this.scroll, (int)0, (int)Math.max(class_3532.method_38788((int)this.codepoints.size(), (int)this.columns) - this.screenRows, 0));
        this.widgets.clear();
        int x = 1;
        int y = 40;
        for (int index = this.scroll * this.columns; index < this.codepoints.size(); ++index) {
            int value = this.codepoints.getInt(index);
            int codePoint = value & 0xFFFFFF;
            int blockColor = this.CYCLING_BLOCK_COLORS[(value & 0xFF000000) >> 24];
            String symbol = Util.stringFromCodePoint(codePoint);
            Character.UnicodeBlock block = Character.UnicodeBlock.of(codePoint);
            class_7919 tooltip = class_7919.method_47407((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)Integer.toHexString(codePoint))).method_27693("\n\n" + Util.getCapitalizedSymbolName(codePoint) + "\n").method_27693("Width: " + this.field_22793.method_1727(symbol) + "\n").method_10852((class_2561)(block == null ? class_2561.method_43470((String)"UNKNOWN BLOCK").method_27692(class_124.field_1080) : class_2561.method_43470((String)block.toString()).method_27694(style -> style.method_36139(blockColor)))));
            TableButton button = this.showBlocksWidget.method_20372() ? new TableButton(x, y, this, symbol, tooltip, index, class_5253.class_5254.method_27763((int)blockColor, (int)-8355712), blockColor) : new TableButton(x, y, this, symbol, tooltip, index);
            this.widgets.add(button);
            if ((x += 13) > this.field_22789 - 12) {
                x = 1;
                y += 13;
            }
            if (y >= this.field_22790) break;
        }
        this.copySelectedButton.field_22763 = buttonsActive = this.selectionStart != -1;
        this.favoriteSymbolButton.field_22763 = buttonsActive;
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (class_437.method_25438((int)keyCode) && this.selectionStart != -1) {
            this.copySelected();
            return true;
        }
        if (keyCode == 256 && this.selectionStart != -1) {
            this.selectionStart = -1;
            this.selectionEnd = -1;
            this.refreshButtons();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.scroll -= (int)verticalAmount * (class_437.method_25441() ? this.screenRows : 1);
        this.refreshButtons();
        return true;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, -15724528);
    }

    private class CodePointCollector {
        IntList codepoints = new IntArrayList();
        int blockCycleColorIndex;
        Character.UnicodeBlock currentBlock;

        private CodePointCollector() {
            this.blockCycleColorIndex = UnicodeTableScreen.this.CYCLING_BLOCK_COLORS.length - 1;
            this.currentBlock = null;
        }

        void accept(int codepoint) {
            if (UnicodeTableScreen.this.hideMissingGlyphs.method_20372() && ((TextRendererAccess)UnicodeTableScreen.this.field_22793).isMissingGlyph(codepoint, class_2583.field_24360)) {
                return;
            }
            Character.UnicodeBlock newBlock = Character.UnicodeBlock.of(codepoint);
            if (newBlock != this.currentBlock) {
                this.blockCycleColorIndex = (this.blockCycleColorIndex + 1) % UnicodeTableScreen.this.CYCLING_BLOCK_COLORS.length;
                this.currentBlock = newBlock;
            }
            this.codepoints.add(codepoint |= this.blockCycleColorIndex << 24);
        }

        IntList getCodepoints() {
            return this.codepoints;
        }
    }

    public class TableButton
    extends PasteSymbolButtonWidget {
        private final int index;
        private final boolean marked;
        private final int backgroundColor;
        private final int hoverBackgroundColor;

        public TableButton(int x, int y, PasteSymbolButtonWidget.Context context, String symbol, class_7919 tooltip, int index, int backgroundColor, int hoverBackgroundColor) {
            super(x, y, context, symbol, tooltip);
            this.index = index;
            this.marked = index >= UnicodeTableScreen.this.selectionStart && index <= UnicodeTableScreen.this.selectionEnd;
            this.backgroundColor = backgroundColor;
            this.hoverBackgroundColor = hoverBackgroundColor;
        }

        public TableButton(int x, int y, PasteSymbolButtonWidget.Context context, String symbol, class_7919 tooltip, int index) {
            this(x, y, context, symbol, tooltip, index, SymbolChat.config.getButtonColor(), SymbolChat.config.getButtonHoverColor());
        }

        @Override
        protected int getBackgroundColor() {
            return this.method_49606() ? this.hoverBackgroundColor : this.backgroundColor;
        }

        @Override
        protected boolean shouldDrawOutline() {
            return this.marked;
        }

        @Override
        public boolean onClick(int button) {
            if (button == 0) {
                if (class_437.method_25442() && UnicodeTableScreen.this.selectionStart != -1) {
                    if (UnicodeTableScreen.this.selectionStart > this.index) {
                        UnicodeTableScreen.this.selectionEnd = UnicodeTableScreen.this.selectionStart;
                        UnicodeTableScreen.this.selectionStart = this.index;
                    } else {
                        UnicodeTableScreen.this.selectionEnd = this.index;
                    }
                } else {
                    UnicodeTableScreen.this.selectionStart = this.index;
                    UnicodeTableScreen.this.selectionEnd = this.index;
                }
            }
            super.onClick(button);
            return true;
        }
    }
}

