/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat.config;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.minecraft.class_1269;
import net.minecraft.class_437;
import net.replaceitem.symbolchat.SymbolChat;
import net.replaceitem.symbolchat.config.ClothConfig;
import net.replaceitem.symbolchat.config.ConfigProvider;

public class ClothConfigProvider
extends ConfigProvider {
    private final ClothConfig config;

    public ClothConfigProvider() {
        AutoConfig.register(ClothConfig.class, GsonConfigSerializer::new);
        this.config = (ClothConfig)AutoConfig.getConfigHolder(ClothConfig.class).getConfig();
        AutoConfig.getConfigHolder(ClothConfig.class).registerSaveListener((configHolder, clothConfig) -> {
            SymbolChat.symbolManager.onConfigReload(this);
            return class_1269.field_5812;
        });
    }

    @Override
    public int getHudColor() {
        return this.config.hud_color;
    }

    @Override
    public int getButtonColor() {
        return this.config.button_color;
    }

    @Override
    public int getButtonHoverColor() {
        return this.config.button_active_color;
    }

    @Override
    public int getFavoriteColor() {
        return this.config.favorite_color;
    }

    @Override
    public int getButtonTextColor() {
        return this.config.button_text_color;
    }

    @Override
    public int getButtonTextHoverColor() {
        return this.config.button_text_hover_color;
    }

    @Override
    public boolean getHideFontButton() {
        return this.config.hide_font_button;
    }

    @Override
    public boolean getHideSettingsButton() {
        return this.config.hide_settings_button;
    }

    @Override
    public boolean getHideTableButton() {
        return this.config.hide_table_button;
    }

    @Override
    public int getSymbolPanelHeight() {
        return this.config.symbol_panel_height;
    }

    @Override
    public int getMaxSymbolSuggestions() {
        return this.config.max_symbol_suggestions;
    }

    @Override
    public ConfigProvider.SymbolTooltipMode getSymbolTooltipMode() {
        return this.config.symbol_tooltip_mode;
    }

    @Override
    public ConfigProvider.HudPosition getHudPosition() {
        return this.config.hud_position;
    }

    @Override
    public boolean getKeepPanelOpen() {
        return this.config.keep_panel_open;
    }

    @Override
    public String getChatSuggestionRegex() {
        return this.config.chat_suggestion_regex;
    }

    @Override
    public String getFavoriteSymbols() {
        return this.config.custom_symbols;
    }

    @Override
    public List<String> getCustomKaomojis() {
        return this.config.custom_kaomojis;
    }

    @Override
    public class_437 getConfigScreen(class_437 parent) {
        return (class_437)AutoConfig.getConfigScreen(ClothConfig.class, (class_437)parent).get();
    }

    @Override
    public void addFavorite(String symbol) {
        this.config.custom_symbols = this.config.custom_symbols + symbol;
        AutoConfig.getConfigHolder(ClothConfig.class).save();
    }

    @Override
    public void removeFavorite(String symbol) {
        this.config.custom_symbols = this.config.custom_symbols.replace(symbol, "");
        AutoConfig.getConfigHolder(ClothConfig.class).save();
    }

    @Override
    public void toggleFavorite(Stream<String> symbolStream) {
        Stream<String> current = this.config.custom_symbols.codePoints().mapToObj(Character::toString);
        List<String> toToggle = symbolStream.toList();
        HashSet forRemoval = new HashSet();
        toToggle.stream().filter(value -> SymbolChat.symbolManager.isFavorite((String)value)).forEach(forRemoval::add);
        current = Stream.concat(current.filter(k -> !forRemoval.contains(k)), toToggle.stream().filter(value -> !SymbolChat.symbolManager.isFavorite((String)value)));
        this.config.custom_symbols = current.collect(Collectors.joining());
        AutoConfig.getConfigHolder(ClothConfig.class).save();
    }
}

