/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchUtil {
    @NotNull
    public static Stream<String> performSearch(@NotNull Stream<String> symbols, @Nullable String search) {
        if (search == null || search.isBlank()) {
            return symbols;
        }
        String upperSearch = search.toUpperCase();
        List<String> searchWords = Arrays.stream(upperSearch.split(" ")).toList();
        record CachedPriorityComparable<T>(T element, double priority) implements Comparable<CachedPriorityComparable<?>>
        {
            @Override
            public int compareTo(@NotNull CachedPriorityComparable other) {
                return Double.compare(other.priority, this.priority);
            }
        }
        return symbols.map(symbol -> new CachedPriorityComparable<String>((String)symbol, SearchUtil.getSearchOrder(symbol, upperSearch, searchWords))).filter(item -> item.priority() >= 0.0).sorted().map(CachedPriorityComparable::element);
    }

    private static double getSearchOrder(String symbol, String searchString, List<String> searchWords) {
        if (searchWords.isEmpty()) {
            return -1.0;
        }
        String symbolName = symbol.codePoints().mapToObj(Character::getName).collect(Collectors.joining(" "));
        if (symbolName.startsWith(searchString)) {
            return Integer.MAX_VALUE - symbolName.length();
        }
        double sum = searchWords.stream().mapToDouble(searchWord -> SearchUtil.getRelevance(symbolName, searchWord)).sum();
        if (sum < 0.0) {
            return -1.0;
        }
        return 100.0 + sum;
    }

    private static double getRelevance(String symbolName, String searchWord) {
        int nameLength = symbolName.length();
        int searchLength = searchWord.length();
        if (searchLength > nameLength) {
            return -1.0E-4;
        }
        int index = symbolName.indexOf(searchWord);
        if (index < 0) {
            return -1.0E-4;
        }
        if (nameLength == searchLength) {
            return 3.0;
        }
        return 2.0 - (double)index / (double)(nameLength - searchLength);
    }
}

