/*
 * Decompiled with CFR 0.152.
 */
package com.tamaized.voidfog;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tamaized.voidfog.VoidFog;
import com.tamaized.voidfog.api.Voidable;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_5636;
import net.minecraft.class_757;
import net.minecraft.class_758;

public class FogRenderer {
    private float lastFogDistance = 1000.0f;

    public void render(class_4184 camera, class_758.class_4596 type, float viewDistance, boolean thickFog, float delta) {
        class_1309 l;
        if (!this.canRenderDepthFog(camera)) {
            return;
        }
        class_1297 entity = camera.method_19331();
        class_1937 world = entity.method_5770();
        Voidable voidable = Voidable.of(world);
        if (!voidable.hasDepthFog(entity, world)) {
            return;
        }
        float distance = this.getFogDistance(world, entity);
        if (entity instanceof class_1309 && (l = (class_1309)entity).method_6059(class_1294.field_5925)) {
            distance *= 4.0f * class_757.method_3174((class_1309)l, (float)delta);
        }
        this.lastFogDistance = distance = class_3532.method_16439((float)(delta / (float)(distance > this.lastFogDistance ? 20 : 2)), (float)this.lastFogDistance, (float)distance);
        float entityAltitude = (float)FogRenderer.getAltitude(voidable, world, entity);
        int fadeStart = VoidFog.config.maxFogHeight;
        float fadeOffset = VoidFog.config.fadeStartOffset;
        float fadeEnd = (float)fadeStart - fadeOffset;
        float entityDelta = Math.max(0.0f, Math.min(1.0f, 1.0f - (entityAltitude - fadeEnd) / fadeOffset));
        if (entityAltitude <= fadeEnd || VoidFog.config.prettyFog) {
            RenderSystem.setShaderFogStart((float)this.getFogStart(distance, type, world, thickFog));
            RenderSystem.setShaderFogEnd((float)this.getFogEnd(distance, type, world, thickFog));
        } else if (entityAltitude <= (float)fadeStart && !VoidFog.config.prettyFog) {
            RenderSystem.setShaderFogStart((float)class_3532.method_16439((float)entityDelta, (float)RenderSystem.getShaderFogStart(), (float)this.getFogStart(distance, type, world, thickFog)));
            RenderSystem.setShaderFogEnd((float)class_3532.method_16439((float)entityDelta, (float)RenderSystem.getShaderFogEnd(), (float)this.getFogEnd(distance, type, world, thickFog)));
        } else {
            RenderSystem.setShaderFogStart((float)RenderSystem.getShaderFogStart());
            RenderSystem.setShaderFogEnd((float)RenderSystem.getShaderFogEnd());
        }
    }

    private boolean canRenderDepthFog(class_4184 camera) {
        class_1309 l;
        class_1297 class_12972;
        return VoidFog.config.enabled && camera.method_19334() == class_5636.field_27888 && (!((class_12972 = camera.method_19331()) instanceof class_1309) || !(l = (class_1309)class_12972).method_6059(class_1294.field_5919));
    }

    public static int getLight(class_1297 entity) {
        entity = FogRenderer.getCorrectEntity(entity);
        class_2338 pos = class_2338.method_49638((class_2374)entity.method_33571());
        if (VoidFog.config.respectTorches) {
            return entity.method_37908().method_22339(pos);
        }
        return entity.method_37908().method_8314(class_1944.field_9284, pos);
    }

    private static double getAltitude(Voidable voidable, class_1937 world, class_1297 entity) {
        return voidable.isVoidFogDisabled(entity = FogRenderer.getCorrectEntity(entity), world) ? 15.0 : entity.method_23318() - (double)world.method_31607();
    }

    public static class_1297 getCorrectEntity(class_1297 entity) {
        while (entity.method_5765() && !entity.method_36601().method_26215()) {
            entity = entity.method_5854();
        }
        return entity;
    }

    private float getFogDistance(class_1937 world, class_1297 entity) {
        Voidable voidable = Voidable.of(world);
        float viewDistance = class_310.method_1551().field_1773.method_3193();
        double maxHeight = VoidFog.config.scaleWithDifficulty ? (double)(VoidFog.config.maxFogHeight * (world.method_8407().method_5461() + 1)) : (double)VoidFog.config.maxFogHeight;
        double fogDistance = (double)FogRenderer.getLight(entity) / 16.0 + FogRenderer.getAltitude(voidable, world, entity) / maxHeight;
        if (fogDistance >= 1.0) {
            return viewDistance;
        }
        fogDistance = Math.pow(Math.max(fogDistance, 0.0), 2.0);
        return (float)class_3532.method_15350((double)(100.0 * fogDistance), (double)5.0, (double)viewDistance);
    }

    private float getFogStart(float distance, class_758.class_4596 type, class_1937 world, boolean thickFog) {
        if (type == class_758.class_4596.field_20945) {
            return 0.0f;
        }
        if (thickFog) {
            return distance * 0.05f;
        }
        float factor = 0.55f * (1.0f - (distance - 5.0f) / 127.0f);
        return distance * Math.max(0.0f, factor);
    }

    private float getFogEnd(float distance, class_758.class_4596 type, class_1937 world, boolean thickFog) {
        return thickFog ? Math.min(distance, 192.0f) / 2.0f : distance;
    }
}

