/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.config;

import com.google.gson.GsonBuilder;
import dev.imb11.fog.client.FogClient;
import dev.imb11.fog.client.FogManager;
import dev.imb11.mru.yacl.ConfigHelper;
import dev.imb11.mru.yacl.EntryType;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class FogConfig {
    private static final String CONFIG_FILE_NAME = "config";
    private static final String CONFIG_FILE_EXTENSION = "json";
    private static final ConfigClassHandler<FogConfig> HANDLER = ConfigClassHandler.createBuilder(FogConfig.class).id(class_2960.method_43902((String)"fog", (String)"config")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(FogClient.getConfigPath(CONFIG_FILE_NAME, CONFIG_FILE_EXTENSION)).appendGsonBuilder(GsonBuilder::setPrettyPrinting).build()).build();
    private static final ConfigHelper HELPER = new ConfigHelper("fog", "config");
    @SerialEntry
    public float initialFogStart = 0.1f;
    @SerialEntry
    public float initialFogEnd = 0.85f;
    @SerialEntry
    public boolean disableRaininessEffect = false;
    @SerialEntry
    public boolean disableUndergroundFogMultiplier = false;
    @SerialEntry
    public boolean disableBiomeFogColour = false;
    @SerialEntry
    public boolean disableCloudWhitening = false;
    @SerialEntry
    public boolean disableNether = true;
    @SerialEntry
    public boolean disableMod = false;

    @NotNull
    public static FogConfig getInstance() {
        return (FogConfig)HANDLER.instance();
    }

    public static void load() {
        HANDLER.load();
    }

    public static void save() {
        HANDLER.save();
    }

    @NotNull
    public YetAnotherConfigLib getYetAnotherConfigLibInstance() {
        return YetAnotherConfigLib.create(HANDLER, (defaults, config, builder) -> builder.title((class_2561)class_2561.method_43473()).save(() -> {
            HANDLER.save();
            FogManager.INSTANCE = new FogManager();
        }).category(ConfigCategory.createBuilder().name(HELPER.getText(EntryType.CATEGORY_NAME, "fog_calculations")).option((Option)LabelOption.create((class_2561)HELPER.getText(EntryType.OPTION_NAME, "fog_calculations.warning"))).option(HELPER.getSlider("initial_fog_start", 0.0f, 1.0f, 0.05f, defaults.initialFogStart, () -> Float.valueOf(config.initialFogStart), val -> {
            config.initialFogStart = val.floatValue();
        })).option(HELPER.getSlider("initial_fog_end", 0.0f, 1.0f, 0.05f, defaults.initialFogEnd, () -> Float.valueOf(config.initialFogEnd), val -> {
            config.initialFogEnd = val.floatValue();
        })).option(HELPER.get("disable_raininess_effect", defaults.disableRaininessEffect, () -> config.disableRaininessEffect, val -> {
            config.disableRaininessEffect = val;
        })).option(HELPER.get("disable_underground_fog_multiplier", defaults.disableUndergroundFogMultiplier, () -> config.disableUndergroundFogMultiplier, val -> {
            config.disableUndergroundFogMultiplier = val;
        })).option(HELPER.get("disable_biome_fog_colour", defaults.disableBiomeFogColour, () -> config.disableBiomeFogColour, val -> {
            config.disableBiomeFogColour = val;
        })).option(Option.createBuilder().name(HELPER.getText(EntryType.OPTION_NAME, "disable_cloud_whitening")).description(initialFogStart -> OptionDescription.createBuilder().text(new class_2561[]{HELPER.getText(EntryType.OPTION_DESCRIPTION, "disable_cloud_whitening")}).build()).binding((Object)defaults.disableCloudWhitening, () -> this.disableCloudWhitening, newDisableCloudWhitening -> {
            this.disableCloudWhitening = newDisableCloudWhitening;
        }).controller(BooleanControllerBuilder::create).available(!FogClient.isModInstalled("sodium")).build()).option(HELPER.get("disable_nether", defaults.disableNether, () -> config.disableNether, val -> {
            config.disableNether = val;
        })).option(Option.createBuilder().name(HELPER.getText(EntryType.OPTION_NAME, "disable_mod")).description(initialFogStart -> OptionDescription.createBuilder().text(new class_2561[]{HELPER.getText(EntryType.OPTION_DESCRIPTION, "disable_mod")}).build()).binding((Object)defaults.disableMod, () -> this.disableMod, newDisableMod -> {
            this.disableMod = newDisableMod;
        }).controller(BooleanControllerBuilder::create).build()).build()));
    }
}

