/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import dev.imb11.fog.client.FogManager;
import dev.imb11.fog.client.util.color.Color;
import dev.imb11.fog.config.FogConfig;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FogClientCommands {
    public static void register() {
        ClientCommandRegistrationEvent.EVENT.register((dispatcher, context) -> {
            LiteralArgumentBuilder fogNode = ClientCommandRegistrationEvent.literal((String)"fog");
            fogNode = (LiteralArgumentBuilder)fogNode.then(ClientCommandRegistrationEvent.literal((String)"reset").executes(FogClientCommands::reset));
            fogNode = (LiteralArgumentBuilder)fogNode.then(ClientCommandRegistrationEvent.literal((String)"toggle").executes(FogClientCommands::toggle));
            fogNode = (LiteralArgumentBuilder)fogNode.then(ClientCommandRegistrationEvent.literal((String)"debug").executes(FogClientCommands::outputDebug));
            dispatcher.register(fogNode);
        });
    }

    private static int outputDebug(CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> commandContext) {
        class_310 client = class_310.method_1551();
        float tickDelta = client.method_1488();
        FogManager manager = FogManager.INSTANCE;
        Object hexColor = Integer.toHexString(new Color((int)(manager.fogColorRed.get(tickDelta) * 255.0f), (int)(manager.fogColorGreen.get(tickDelta) * 255.0f), (int)(manager.fogColorBlue.get(tickDelta) * 255.0f)).toInt());
        hexColor = "\u00a7c" + ((String)hexColor).substring(0, 2) + "\u00a7a" + ((String)hexColor).substring(2, 4) + "\u00a79" + ((String)hexColor).substring(4);
        @Nullable class_638 clientWorld = client.field_1687;
        if (clientWorld == null) {
            ((ClientCommandRegistrationEvent.ClientCommandSourceStack)commandContext.getSource()).arch$sendFailure((class_2561)class_2561.method_43471((String)"fog.command.debug.failure"));
            return 0;
        }
        @NotNull String debugInfoTable = String.format("\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Current Fog Manager State:\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Raininess: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r \"Undergroundness\": \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Fog Start: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Fog End: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Darkness: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Fog Color (Before Haze): \u00a76#%s\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Current Sky Light: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Current Block Light: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Current Light: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Current Start Multiplier: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Current End Multiplier: \u00a76%.2f\u00a7r", Float.valueOf(manager.raininess.get(tickDelta)), Float.valueOf(manager.undergroundness.get(tickDelta)), Float.valueOf(manager.fogStart.get(tickDelta)), Float.valueOf(manager.fogEnd.get(tickDelta)), Float.valueOf(manager.darkness.get(tickDelta)), hexColor, Float.valueOf(manager.currentSkyLight.get(tickDelta)), Float.valueOf(manager.currentBlockLight.get(tickDelta)), Float.valueOf(manager.currentLight.get(tickDelta)), Float.valueOf(manager.currentStartMultiplier.get(tickDelta)), Float.valueOf(manager.currentEndMultiplier.get(tickDelta)));
        ((ClientCommandRegistrationEvent.ClientCommandSourceStack)commandContext.getSource()).arch$sendSuccess(() -> class_2561.method_43470((String)debugInfoTable), false);
        return 1;
    }

    private static int reset(@NotNull CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> commandContext) {
        FogConfig.load();
        FogManager.INSTANCE = new FogManager();
        ((ClientCommandRegistrationEvent.ClientCommandSourceStack)commandContext.getSource()).arch$sendSuccess(() -> class_2561.method_43470((String)"\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r ").method_10852((class_2561)class_2561.method_43471((String)"fog.command.reset").method_27692(class_124.field_1065)), false);
        return 1;
    }

    private static int toggle(@NotNull CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> commandContext) {
        FogConfig config = FogConfig.getInstance();
        config.disableMod = !config.disableMod;
        FogConfig.save();
        ((ClientCommandRegistrationEvent.ClientCommandSourceStack)commandContext.getSource()).arch$sendSuccess(() -> class_2561.method_43470((String)"\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r ").method_10852((class_2561)class_2561.method_43471((String)("fog.command.toggle." + (config.disableMod ? "disabled" : "enabled"))).method_27692(class_124.field_1065)), false);
        return 1;
    }
}

