/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client;

import dev.imb11.fog.api.CustomFogDefinition;
import dev.imb11.fog.api.FogColors;
import dev.imb11.fog.client.registry.FogRegistry;
import dev.imb11.fog.client.util.math.DarknessCalculation;
import dev.imb11.fog.client.util.math.InterpolatedValue;
import dev.imb11.fog.client.util.math.MathUtil;
import dev.imb11.fog.client.util.player.PlayerUtil;
import dev.imb11.fog.client.util.world.ClientWorldUtil;
import dev.imb11.fog.config.FogConfig;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FogManager {
    public static FogManager INSTANCE = new FogManager();
    public final InterpolatedValue raininess = new InterpolatedValue(0.0f, 0.03f);
    public final InterpolatedValue undergroundness = new InterpolatedValue(0.0f, 0.25f);
    public final InterpolatedValue fogStart = new InterpolatedValue(0.1f, 0.05f);
    public final InterpolatedValue fogEnd = new InterpolatedValue(0.85f, 0.05f);
    public final InterpolatedValue darkness = new InterpolatedValue(0.0f, 0.1f);
    public final InterpolatedValue fogColorRed = new InterpolatedValue(0.2f, 0.05f);
    public final InterpolatedValue fogColorGreen = new InterpolatedValue(0.2f, 0.05f);
    public final InterpolatedValue fogColorBlue = new InterpolatedValue(0.2f, 0.05f);
    public final InterpolatedValue currentSkyLight = new InterpolatedValue(16.0f);
    public final InterpolatedValue currentBlockLight = new InterpolatedValue(16.0f);
    public final InterpolatedValue currentLight = new InterpolatedValue(16.0f);
    public final InterpolatedValue currentStartMultiplier = new InterpolatedValue(1.0f);
    public final InterpolatedValue currentEndMultiplier = new InterpolatedValue(1.0f);

    public FogManager() {
        @NotNull FogConfig config = FogConfig.getInstance();
        this.fogStart.resetTo(config.initialFogStart);
        this.fogEnd.resetTo(config.initialFogEnd);
    }

    @NotNull
    public static FogManager getInstance() {
        return INSTANCE;
    }

    public void onEndTick(@NotNull class_638 world) {
        class_310 client = class_310.method_1551();
        class_746 clientPlayer = client.field_1724;
        if (clientPlayer == null) {
            return;
        }
        if (world.method_8520(clientPlayer.method_24515()) && ((class_1959)world.method_23753(clientPlayer.method_24515()).comp_349()).method_48163()) {
            this.raininess.interpolate(1.0f);
        } else {
            this.raininess.interpolate(0.0f, 1.0f);
        }
        @Nullable class_2338 clientPlayerBlockPosition = clientPlayer.method_24515();
        if (clientPlayerBlockPosition == null) {
            return;
        }
        if (PlayerUtil.isPlayerAboveGround(clientPlayer)) {
            this.undergroundness.interpolate(0.0f);
        } else {
            this.undergroundness.interpolate(1.0f);
        }
        float density = ClientWorldUtil.isFogDenseAtPosition(world, clientPlayerBlockPosition) ? 0.9f : 1.0f;
        float tickDelta = client.method_1488();
        DarknessCalculation darknessCalculation = DarknessCalculation.of(client, this.fogStart.getDefaultValue(), this.fogEnd.getDefaultValue() * density, tickDelta);
        Optional clientPlayerBiomeKeyOptional = world.method_23753(clientPlayer.method_24515()).method_40230();
        if (clientPlayerBiomeKeyOptional.isEmpty()) {
            return;
        }
        CustomFogDefinition fogDefinition = FogRegistry.getFogDefinitionOrDefault(((class_5321)clientPlayerBiomeKeyOptional.get()).method_29177(), (class_1937)world);
        @Nullable FogColors colors = fogDefinition.colors();
        if (colors == null || FogConfig.getInstance().disableBiomeFogColour) {
            colors = FogColors.DEFAULT;
        }
        float blendFactor = FogManager.getBlendFactor(world);
        float red = class_3532.method_16439((float)blendFactor, (float)((float)colors.getNightColor().red / 255.0f), (float)((float)colors.getDayColor().red / 255.0f));
        float green = class_3532.method_16439((float)blendFactor, (float)((float)colors.getNightColor().green / 255.0f), (float)((float)colors.getDayColor().green / 255.0f));
        float blue = class_3532.method_16439((float)blendFactor, (float)((float)colors.getNightColor().blue / 255.0f), (float)((float)colors.getDayColor().blue / 255.0f));
        this.fogColorRed.interpolate(red);
        this.fogColorGreen.interpolate(green);
        this.fogColorBlue.interpolate(blue);
        this.currentStartMultiplier.interpolate(fogDefinition.startMultiplier());
        this.currentEndMultiplier.interpolate(fogDefinition.endMultiplier());
        this.fogStart.interpolate(darknessCalculation.fogStart());
        this.fogEnd.interpolate(darknessCalculation.fogEnd());
        this.darkness.interpolate(darknessCalculation.darknessValue());
        this.currentSkyLight.interpolate(world.method_8314(class_1944.field_9284, clientPlayerBlockPosition));
        this.currentBlockLight.interpolate(world.method_8314(class_1944.field_9282, clientPlayerBlockPosition));
        this.currentLight.interpolate(world.method_22335(clientPlayerBlockPosition, 0));
    }

    private static float getBlendFactor(@NotNull class_638 world) {
        long time = world.method_8532() % 24000L;
        float blendFactor = time < 11000L ? 1.0f : (time < 13000L ? MathUtil.lerp(1.0f, 0.0f, (float)(time - 11000L) / 2000.0f) : (time < 22000L ? 0.0f : (time < 23000L ? MathUtil.lerp(0.0f, 1.0f, (float)(time - 22000L) / 1000.0f) : 1.0f)));
        return blendFactor;
    }

    public float getUndergroundFactor(@NotNull class_310 client, float deltaTicks) {
        class_1297 clientCamera = client.field_1719;
        class_638 clientWorld = client.field_1687;
        if (clientCamera == null || clientWorld == null) {
            return 0.0f;
        }
        float clientCameraYPosition = (float)clientCamera.method_23318();
        float seaLevel = clientWorld.method_8615();
        float yFactor = class_3532.method_15363((float)MathUtil.mapRange(seaLevel - 32.0f, seaLevel + 32.0f, 1.0f, 0.0f, clientCameraYPosition), (float)0.0f, (float)1.0f);
        float undergroundnessValue = this.undergroundness.get(deltaTicks);
        float skyLight = this.currentSkyLight.get(deltaTicks);
        return class_3532.method_16439((float)yFactor, (float)(1.0f - undergroundnessValue), (float)(skyLight / 16.0f));
    }

    @NotNull
    public FogSettings getFogSettings(float tickDelta, float viewDistance) {
        float fogStartValue = this.fogStart.get(tickDelta) * viewDistance;
        float undergroundFogMultiplier = 1.0f;
        if (!FogConfig.getInstance().disableUndergroundFogMultiplier) {
            undergroundFogMultiplier = this.undergroundness.get(tickDelta);
            undergroundFogMultiplier = class_3532.method_16439((float)this.darkness.get(tickDelta), (float)undergroundFogMultiplier, (float)1.0f);
        }
        float fogEndValue = viewDistance * this.fogEnd.get(tickDelta);
        if (undergroundFogMultiplier > 0.0f) {
            fogEndValue /= 1.0f + undergroundFogMultiplier;
            fogStartValue *= Math.max(0.1f, 0.5f - undergroundFogMultiplier);
        }
        float fogRed = this.fogColorRed.get(tickDelta);
        float fogGreen = this.fogColorGreen.get(tickDelta);
        float fogBlue = this.fogColorBlue.get(tickDelta);
        float raininessValue = this.raininess.get(tickDelta);
        if (!FogConfig.getInstance().disableRaininessEffect && raininessValue > 0.0f) {
            fogEndValue /= 1.0f + 0.5f * raininessValue;
            fogRed = Math.max(0.1f, fogRed - 0.5f * raininessValue);
            fogGreen = Math.max(0.1f, fogGreen - 0.5f * raininessValue);
            fogBlue = Math.max(0.1f, fogBlue - 0.5f * raininessValue);
        }
        float darknessValue = this.darkness.get(tickDelta);
        return new FogSettings(fogStartValue *= this.currentStartMultiplier.get(tickDelta), fogEndValue *= this.currentEndMultiplier.get(tickDelta), fogRed *= 1.0f - darknessValue, fogGreen *= 1.0f - darknessValue, fogBlue *= 1.0f - darknessValue);
    }

    public record FogSettings(double fogStart, double fogEnd, float fogRed, float fogGreen, float fogBlue) {
    }
}

