/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client;

import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.imb11.fog.client.FogManager;
import dev.imb11.fog.client.command.FogClientCommands;
import dev.imb11.fog.client.registry.FogRegistry;
import dev.imb11.fog.client.resource.FogResourceReloader;
import dev.imb11.fog.config.FogConfig;
import dev.imb11.mru.packing.Unpacker;
import dev.imb11.mru.packing.resource.UnpackedResourcePack;
import java.net.URI;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FogClient {
    @NotNull
    public static final String MOD_ID = "fog";
    @NotNull
    public static final String MOD_NAME = "Fog";
    @NotNull
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"fog");
    public static URI JAR_URL;

    public static Path getConfigPath(String configFileName, String configExtension) {
        return FabricLoader.getInstance().getConfigDir().resolve(MOD_ID).resolve(configFileName + "." + configExtension);
    }

    public static boolean isModInstalled(String modid) {
        return FabricLoader.getInstance().isModLoaded(modid);
    }

    public static Path getConfigFolder() {
        return FabricLoader.getInstance().getGameDir().resolve("config").resolve(MOD_ID);
    }

    public static void initialize() {
        LOGGER.info("Loading {}.", (Object)MOD_NAME);
        Unpacker.register(FogClient.class, (UnpackedResourcePack)new UnpackedResourcePack(MOD_ID, FogClient.getConfigFolder().resolve("fog_definitions"), MOD_ID, "This folder contains the unpacked fog definitions.\nYou can edit these files to customize the fog in your game.\nFor more information, visit https://docs.imb11.dev/fog/"));
        FogConfig.load();
        FogClientCommands.register();
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)new FogResourceReloader());
        ClientTickEvent.CLIENT_LEVEL_POST.register(world -> FogManager.getInstance().onEndTick((class_638)world));
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(clientPlayerEntity -> {
            FogManager.INSTANCE = new FogManager();
            FogRegistry.resetCaches();
        });
    }
}

