/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.fog.client.util.color.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FogColors {
    public static final FogColors DEFAULT = new FogColors("#b9d2fd", "#182d44");
    public static final FogColors DEFAULT_CAVE = new FogColors("#212121", "#101010");
    public static final Codec<FogColors> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("day").forGetter(FogColors::getDay), (App)Codec.STRING.fieldOf("night").forGetter(FogColors::getNight)).apply((Applicative)instance, FogColors::new));
    @NotNull
    private final String day;
    @NotNull
    private final String night;
    @Nullable
    private transient Color dayCached;
    @Nullable
    private transient Color nightCached;

    public FogColors(@NotNull String day, @NotNull String night) {
        assert (day.matches("^#[0-9a-fA-F]{6}$")) : "Invalid day color format: " + day;
        assert (night.matches("^#[0-9a-fA-F]{6}$")) : "Invalid night color format: " + night;
        this.day = day;
        this.night = night;
    }

    public Color getDayColor() {
        if (this.dayCached == null) {
            this.dayCached = Color.parse(this.day);
        }
        return this.dayCached;
    }

    public Color getNightColor() {
        if (this.nightCached == null) {
            this.nightCached = Color.parse(this.night);
        }
        return this.nightCached;
    }

    @NotNull
    private String getDay() {
        return this.day;
    }

    @NotNull
    private String getNight() {
        return this.night;
    }

    public static class Builder {
        @NotNull
        private String day = DEFAULT.getDay();
        @NotNull
        private String night = DEFAULT.getNight();

        @NotNull
        public Builder day(@NotNull String day) {
            this.day = day;
            return this;
        }

        @NotNull
        public Builder night(@NotNull String night) {
            this.night = night;
            return this;
        }

        @NotNull
        public FogColors build() {
            return new FogColors(this.day, this.night);
        }
    }
}

