/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.pickblockpro.util;

import com.mojang.authlib.GameProfile;
import io.github.sjouwer.pickblockpro.PickBlockPro;
import io.github.sjouwer.pickblockpro.config.ModConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1498;
import net.minecraft.class_1501;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1809;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5146;
import net.minecraft.class_7923;

public class NbtUtil {
    private static final ModConfig config = PickBlockPro.getConfig();
    private static final String BLOCK_STATE_KEY = "BlockStateTag";
    private static final String BLOCK_ENTITY_KEY = "BlockEntityTag";
    private static final String ENTITY_KEY = "EntityTag";
    private static final String ID_KEY = "id";
    private static final String COUNT_KEY = "Count";
    private static final String LEVEL_KEY = "level";

    private NbtUtil() {
    }

    public static void addEntityNbt(class_1799 stack, class_1297 entity, boolean addLore) {
        class_2487 entityCompound = NbtUtil.getEntityNbt(entity);
        config.entityTagBlacklist().forEach(arg_0 -> ((class_2487)entityCompound).method_10551(arg_0));
        if (entityCompound.method_33133()) {
            return;
        }
        stack.method_7959(ENTITY_KEY, (class_2520)entityCompound);
        if (addLore) {
            NbtUtil.addLore(stack, "\"(+Entity NBT)\"");
        }
    }

    public static class_2487 getEntityNbt(class_1297 entity) {
        class_1501 llama;
        class_5146 saddleable;
        class_1498 horse;
        class_2487 entityCompound = entity.method_5647(new class_2487());
        if (entity instanceof class_1498 && (horse = (class_1498)entity).method_6753()) {
            class_2520 armorCompound = entityCompound.method_10554("ArmorItems", 10).method_10534(2);
            entityCompound.method_10566("ArmorItem", armorCompound);
            entityCompound.method_10551("ArmorItems");
        }
        if (entity instanceof class_5146 && (saddleable = (class_5146)entity).method_6725()) {
            class_2487 saddleCompound = new class_2487();
            saddleCompound.method_10582(ID_KEY, class_1802.field_8175.toString());
            saddleCompound.method_10569(COUNT_KEY, 1);
            entityCompound.method_10566("SaddleItem", (class_2520)saddleCompound);
        }
        if (entity instanceof class_1501 && (llama = (class_1501)entity).method_6800() != null) {
            class_2487 decorCompound = new class_2487();
            decorCompound.method_10582(ID_KEY, llama.method_6800() + "_carpet");
            decorCompound.method_10569(COUNT_KEY, 1);
            entityCompound.method_10566("DecorItem", (class_2520)decorCompound);
        }
        class_2960 identifier = class_1299.method_5890((class_1299)entity.method_5864());
        entityCompound.method_10582(ID_KEY, identifier.toString());
        return entityCompound;
    }

    public static void addBlockEntityNbt(class_1799 stack, class_2586 blockEntity, boolean addLore) {
        class_2487 blockEntityCompound = blockEntity.method_38242();
        config.blockEntityTagBlacklist().forEach(arg_0 -> ((class_2487)blockEntityCompound).method_10551(arg_0));
        if (blockEntityCompound.method_33133()) {
            return;
        }
        if (stack.method_7909() instanceof class_1809 && blockEntityCompound.method_10545("SkullOwner")) {
            boolean containsNoBlockEntityData;
            class_2487 skullCompound = blockEntityCompound.method_10562("SkullOwner");
            class_2487 stackCompound = stack.method_7948();
            stackCompound.method_10566("SkullOwner", (class_2520)skullCompound);
            blockEntityCompound.method_10551("SkullOwner");
            blockEntityCompound.method_10551("x");
            blockEntityCompound.method_10551("y");
            blockEntityCompound.method_10551("z");
            boolean bl = containsNoBlockEntityData = blockEntityCompound.method_33133() || blockEntityCompound.method_10545(ID_KEY) && blockEntityCompound.method_10546() == 1;
            if (containsNoBlockEntityData) {
                return;
            }
        }
        stack.method_7959(BLOCK_ENTITY_KEY, (class_2520)blockEntityCompound);
        if (addLore) {
            NbtUtil.addLore(stack, "\"(+BlockEntity NBT)\"");
        }
    }

    public static void addBlockStateNbt(class_1799 stack, class_2680 state, boolean addLore) {
        class_2487 blockStateCompound = NbtUtil.getBlockStateNbt(state);
        config.blockStateTagBlacklist().forEach(arg_0 -> ((class_2487)blockStateCompound).method_10551(arg_0));
        if (blockStateCompound.method_33133()) {
            return;
        }
        stack.method_7959(BLOCK_STATE_KEY, (class_2520)blockStateCompound);
        if (addLore) {
            NbtUtil.addLore(stack, "\"(+BlockState NBT)\"");
        }
    }

    public static class_2487 getBlockStateNbt(class_2680 state) {
        class_2487 blockStateCompound = new class_2487();
        for (class_2769 property : state.method_28501()) {
            String key = property.method_11899();
            String value = state.method_11654(property).toString().toLowerCase();
            blockStateCompound.method_10582(key, value);
        }
        return blockStateCompound;
    }

    public static void addLore(class_1799 stack, String tag) {
        class_2487 loreCompound = stack.method_7911("display");
        class_2499 loreList = loreCompound.method_10554("Lore", 8);
        if (loreList == null) {
            loreList = new class_2499();
        }
        loreList.add((Object)class_2519.method_23256((String)tag));
        loreCompound.method_10566("Lore", (class_2520)loreList);
        stack.method_7959("display", (class_2520)loreCompound);
    }

    public static void setLightLevel(class_1799 light, int level) {
        class_2487 blockStateTag = new class_2487();
        blockStateTag.method_10569(LEVEL_KEY, level);
        light.method_7959(BLOCK_STATE_KEY, (class_2520)blockStateTag);
    }

    public static void cycleLightLevel(class_1799 light) {
        int newLightLvl;
        class_2487 blockStateTag = light.method_7911(BLOCK_STATE_KEY);
        int n = newLightLvl = blockStateTag.method_10545(LEVEL_KEY) ? blockStateTag.method_10550(LEVEL_KEY) + 1 : 0;
        if (newLightLvl == 16) {
            newLightLvl = 0;
        }
        blockStateTag.method_10569(LEVEL_KEY, newLightLvl);
        light.method_7959(BLOCK_STATE_KEY, (class_2520)blockStateTag);
    }

    public static void setSkullOwner(class_1799 skull, class_1657 player) {
        class_2487 skullOwner = new class_2487();
        class_2512.method_10684((class_2487)skullOwner, (GameProfile)player.method_7334());
        skull.method_7959("SkullOwner", (class_2520)skullOwner);
    }

    public static int getAmountStored(class_1799 storage, class_1792 item) {
        class_2499 itemList;
        int amount = 0;
        class_2487 storageCompound = storage.method_7969();
        if (storageCompound == null || storageCompound.method_33133()) {
            return amount;
        }
        class_2487 blockEntityCompound = storageCompound.method_10562(BLOCK_ENTITY_KEY);
        if (blockEntityCompound != null && !blockEntityCompound.method_33133()) {
            storageCompound = blockEntityCompound;
        }
        if ((itemList = storageCompound.method_10554("Items", 10)) == null || itemList.isEmpty()) {
            return amount;
        }
        for (int i = 0; i < itemList.size(); ++i) {
            class_2487 itemCompound = itemList.method_10602(i);
            if (!itemCompound.method_10558(ID_KEY).equals(class_7923.field_41178.method_10221((Object)item).toString())) continue;
            amount += itemCompound.method_10550(COUNT_KEY);
        }
        return amount;
    }
}

