/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.pickblockpro.config;

import io.github.sjouwer.pickblockpro.PickBlockPro;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import net.fabricmc.loader.api.FabricLoader;

public class FileHandler {
    private static File configFolder;
    private static File overrides;

    private FileHandler() {
    }

    private static void loadOrCreateConfigFolder() {
        configFolder = new File(FabricLoader.getInstance().getConfigDir().toFile(), "pickblockpro");
        configFolder.mkdirs();
    }

    public static void addFilesToConfigFolder() {
        FileHandler.loadOrCreateConfigFolder();
        overrides = new File(configFolder, "overrides.json");
        if (overrides.exists()) {
            return;
        }
        try (InputStream is = PickBlockPro.class.getClassLoader().getResourceAsStream("assets/pickblockpro/overrides.json");){
            if (is != null) {
                Files.copy(is, overrides.toPath(), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            PickBlockPro.LOGGER.error("Failed to place the PickBlockOverrides file in the config folder");
            e.printStackTrace();
        }
    }

    public static File getOverridesFile() {
        return overrides;
    }
}

