/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_293;
import net.minecraft.class_5944;
import org.enginehub.worldeditcui.render.LineStyle;
import org.enginehub.worldeditcui.render.RenderSink;
import org.enginehub.worldeditcui.render.RenderStyle;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;

public class BufferBuilderRenderSink
implements RenderSink {
    private final RenderType lines;
    private final RenderType lineLoop;
    private final RenderType quads;
    private final Runnable preFlush;
    private final Runnable postFlush;
    private class_287 builder;
    @Nullable
    private RenderType activeRenderType;
    private boolean active;
    private boolean canFlush;
    private float r = -1.0f;
    private float g;
    private float b;
    private float a;
    private double loopX;
    private double loopY;
    private double loopZ;
    private double loopFirstX;
    private double loopFirstY;
    private double loopFirstZ;
    private boolean canLoop;
    private float lastLineWidth = -1.0f;
    private int lastDepthFunc = -1;

    public BufferBuilderRenderSink(TypeFactory types) {
        this(types, () -> {}, () -> {});
    }

    public BufferBuilderRenderSink(TypeFactory types, Runnable preFlush, Runnable postFlush) {
        this.lines = types.lines();
        this.lineLoop = types.linesLoop();
        this.quads = types.quads();
        this.preFlush = preFlush;
        this.postFlush = postFlush;
    }

    @Override
    public RenderSink color(float r, float g, float b, float alpha) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = alpha;
        return this;
    }

    @Override
    public boolean apply(LineStyle line, RenderStyle.RenderType type) {
        if (line.renderType.matches(type)) {
            if (line.lineWidth != this.lastLineWidth || line.renderType.depthFunc() != this.lastDepthFunc) {
                this.flush();
                if (this.active && this.activeRenderType != null) {
                    this.canFlush = true;
                    this.builder = class_289.method_1348().method_1349();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.builder.method_1328(this.activeRenderType.mode, this.activeRenderType.format);
                }
                this.lastLineWidth = line.lineWidth;
                LineWidth.set(this.lastLineWidth);
                this.lastDepthFunc = line.renderType.depthFunc();
                RenderSystem.depthFunc((int)this.lastDepthFunc);
            }
            return true;
        }
        return false;
    }

    @Override
    public RenderSink vertex(double x, double y, double z) {
        if (this.r == -1.0f) {
            throw new IllegalStateException("No colour has been set!");
        }
        if (!this.active) {
            throw new IllegalStateException("Tried to draw when not active");
        }
        class_287 builder = this.builder;
        if (this.activeRenderType == this.lineLoop) {
            if (this.canLoop) {
                Vector3f normal = this.activeRenderType.hasNormals ? this.computeNormal(this.loopX, this.loopY, this.loopZ, x, y, z) : null;
                builder.method_22912(this.loopX, this.loopY, this.loopZ).method_22915(this.r, this.g, this.b, this.a);
                if (normal != null) {
                    builder.method_22914(normal.x(), normal.y(), normal.z());
                }
                builder.method_1344();
                builder.method_22912(x, y, z).method_22915(this.r, this.g, this.b, this.a);
                if (normal != null) {
                    builder.method_22914(normal.x(), normal.y(), normal.z());
                }
                builder.method_1344();
            } else {
                this.loopFirstX = x;
                this.loopFirstY = y;
                this.loopFirstZ = z;
            }
            this.loopX = x;
            this.loopY = y;
            this.loopZ = z;
            this.canLoop = true;
        } else if (this.activeRenderType == this.lines) {
            if (this.canLoop) {
                Vector3f normal = this.activeRenderType.hasNormals ? this.computeNormal(this.loopX, this.loopY, this.loopZ, x, y, z) : null;
                builder.method_22912(this.loopX, this.loopY, this.loopZ).method_22915(this.r, this.g, this.b, this.a);
                if (normal != null) {
                    builder.method_22914(normal.x(), normal.y(), normal.z());
                }
                builder.method_1344();
                builder.method_22912(x, y, z).method_22915(this.r, this.g, this.b, this.a);
                if (normal != null) {
                    builder.method_22914(normal.x(), normal.y(), normal.z());
                }
                builder.method_1344();
                this.canLoop = false;
            } else {
                this.loopX = x;
                this.loopY = y;
                this.loopZ = z;
                this.canLoop = true;
            }
        } else {
            builder.method_22912(x, y, z).method_22915(this.r, this.g, this.b, this.a).method_1344();
        }
        return this;
    }

    private Vector3f computeNormal(double x0, double y0, double z0, double x1, double y1, double z1) {
        double dX = x1 - x0;
        double dY = y1 - y0;
        double dZ = z1 - z0;
        double length = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        Vector3f normal = new Vector3f((float)(dX / length), (float)(dY / length), (float)(dZ / length));
        return normal;
    }

    @Override
    public RenderSink beginLineLoop() {
        this.transitionState(this.lineLoop);
        return this;
    }

    @Override
    public RenderSink endLineLoop() {
        this.end(this.lineLoop);
        if (this.canLoop) {
            this.canLoop = false;
            Vector3f normal = this.activeRenderType.hasNormals ? this.computeNormal(this.loopX, this.loopY, this.loopZ, this.loopFirstX, this.loopFirstY, this.loopFirstZ) : null;
            this.builder.method_22912(this.loopX, this.loopY, this.loopZ).method_22915(this.r, this.g, this.b, this.a);
            if (normal != null) {
                this.builder.method_22914(normal.x(), normal.y(), normal.z());
            }
            this.builder.method_1344();
            this.builder.method_22912(this.loopFirstX, this.loopFirstY, this.loopFirstZ).method_22915(this.r, this.g, this.b, this.a);
            if (normal != null) {
                this.builder.method_22914(normal.x(), normal.y(), normal.z());
            }
            this.builder.method_1344();
        }
        return this;
    }

    @Override
    public RenderSink beginLines() {
        this.transitionState(this.lines);
        return this;
    }

    @Override
    public RenderSink endLines() {
        this.end(this.lines);
        return this;
    }

    @Override
    public RenderSink beginQuads() {
        this.transitionState(this.quads);
        return this;
    }

    @Override
    public RenderSink endQuads() {
        this.end(this.quads);
        return this;
    }

    @Override
    public void flush() {
        if (!this.canFlush) {
            return;
        }
        if (this.active) {
            throw new IllegalStateException("Tried to flush while still active");
        }
        this.canFlush = false;
        this.preFlush.run();
        try {
            if (this.activeRenderType != null) {
                RenderSystem.setShader(this.activeRenderType.shader);
            }
            class_289.method_1348().method_1350();
        }
        finally {
            this.postFlush.run();
            this.builder = null;
            this.activeRenderType = null;
        }
    }

    private void end(RenderType renderType) {
        if (!this.active) {
            throw new IllegalStateException("Could not exit " + String.valueOf(renderType) + ", was not active");
        }
        if (this.activeRenderType != renderType) {
            throw new IllegalStateException("Expected to end state " + String.valueOf(renderType) + " but was in " + String.valueOf(this.activeRenderType));
        }
        this.active = false;
    }

    private void transitionState(RenderType renderType) {
        if (this.active) {
            throw new IllegalStateException("Tried to enter new state before previous operation had been completed");
        }
        if (this.activeRenderType != null && renderType.mustFlushAfter(this.activeRenderType)) {
            this.flush();
        }
        if (this.activeRenderType == null || this.activeRenderType.mode != renderType.mode) {
            this.canFlush = true;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.builder = class_289.method_1348().method_1349();
            this.builder.method_1328(renderType.mode, renderType.format);
        }
        this.activeRenderType = renderType;
        this.active = true;
    }

    public static interface TypeFactory {
        public RenderType quads();

        public RenderType lines();

        public RenderType linesLoop();
    }

    public static class RenderType {
        private final class_293.class_5596 mode;
        private final class_293 format;
        private final boolean hasNormals;
        private final Supplier<class_5944> shader;

        public RenderType(class_293.class_5596 mode, class_293 format, Supplier<class_5944> shader) {
            this.mode = mode;
            this.format = format;
            this.hasNormals = format.method_34445().contains((Object)"Normal");
            this.shader = shader;
        }

        class_293.class_5596 mode() {
            return this.mode;
        }

        class_293 format() {
            return this.format;
        }

        boolean hasNormals() {
            return this.hasNormals;
        }

        Supplier<class_5944> shader() {
            return this.shader;
        }

        boolean mustFlushAfter(RenderType previous) {
            return previous.mode != this.mode || !Objects.equals(previous.format, this.format);
        }
    }

    static class LineWidth {
        private static final boolean HAS_COMPATIBILITY = (GL11.glGetInteger((int)37158) & 2) != 0;
        private static float lineWidth = GL11.glGetInteger((int)2849);

        LineWidth() {
        }

        static void set(float width) {
            if (HAS_COMPATIBILITY && lineWidth != width) {
                GL11.glLineWidth((float)width);
                lineWidth = width;
            }
            RenderSystem.lineWidth((float)width);
        }
    }
}

