/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.util;

import io.wispforest.owo.serialization.Deserializer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class RecursiveDeserializer<T>
implements Deserializer<T> {
    protected final Deque<Frame<T>> frames = new ArrayDeque<Frame<T>>();
    protected final T serialized;

    protected RecursiveDeserializer(T serialized) {
        this.serialized = serialized;
        this.frames.push(new Frame<Object>(() -> this.serialized, false));
    }

    protected T getValue() {
        return this.frames.peek().source.get();
    }

    protected boolean isReadingStructField() {
        return this.frames.peek().isStructField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <V> V frame(Supplier<T> nextValue, Supplier<V> action, boolean isStructField) {
        try {
            this.frames.push(new Frame<T>(nextValue, isStructField));
            V v = action.get();
            return v;
        }
        finally {
            this.frames.pop();
        }
    }

    @Override
    public <V> V tryRead(Function<Deserializer<T>, V> reader) {
        ArrayDeque<Frame<T>> framesBackup = new ArrayDeque<Frame<T>>(this.frames);
        try {
            return reader.apply(this);
        }
        catch (Exception e) {
            this.frames.clear();
            this.frames.addAll(framesBackup);
            throw e;
        }
    }

    protected record Frame<T>(Supplier<T> source, boolean isStructField) {
    }
}

