/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.format.edm;

import io.wispforest.owo.serialization.Deserializer;
import io.wispforest.owo.serialization.Endec;
import io.wispforest.owo.serialization.SelfDescribedDeserializer;
import io.wispforest.owo.serialization.SerializationAttribute;
import io.wispforest.owo.serialization.Serializer;
import io.wispforest.owo.serialization.format.edm.EdmElement;
import io.wispforest.owo.serialization.util.RecursiveDeserializer;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class EdmDeserializer
extends RecursiveDeserializer<EdmElement<?>>
implements SelfDescribedDeserializer<EdmElement<?>> {
    private static final Set<SerializationAttribute> ATTRIBUTES = EnumSet.of(SerializationAttribute.SELF_DESCRIBING);

    protected EdmDeserializer(EdmElement<?> serialized) {
        super(serialized);
    }

    public static EdmDeserializer of(EdmElement<?> serialized) {
        return new EdmDeserializer(serialized);
    }

    @Override
    public Set<SerializationAttribute> attributes() {
        return ATTRIBUTES;
    }

    @Override
    public byte readByte() {
        return (Byte)((EdmElement)this.getValue()).cast();
    }

    @Override
    public short readShort() {
        return (Short)((EdmElement)this.getValue()).cast();
    }

    @Override
    public int readInt() {
        return (Integer)((EdmElement)this.getValue()).cast();
    }

    @Override
    public long readLong() {
        return (Long)((EdmElement)this.getValue()).cast();
    }

    @Override
    public float readFloat() {
        return ((Float)((EdmElement)this.getValue()).cast()).floatValue();
    }

    @Override
    public double readDouble() {
        return (Double)((EdmElement)this.getValue()).cast();
    }

    @Override
    public int readVarInt() {
        return this.readInt();
    }

    @Override
    public long readVarLong() {
        return this.readLong();
    }

    @Override
    public boolean readBoolean() {
        return (Boolean)((EdmElement)this.getValue()).cast();
    }

    @Override
    public String readString() {
        return (String)((EdmElement)this.getValue()).cast();
    }

    @Override
    public byte[] readBytes() {
        return (byte[])((EdmElement)this.getValue()).cast();
    }

    @Override
    public <V> Optional<V> readOptional(Endec<V> endec) {
        Optional optional = (Optional)((EdmElement)this.getValue()).cast();
        if (optional.isPresent()) {
            return this.frame(optional::get, () -> Optional.of(endec.decode(this)), false);
        }
        return Optional.empty();
    }

    @Override
    public <E> Deserializer.Sequence<E> sequence(Endec<E> elementEndec) {
        return new Sequence<E>(elementEndec, (List)((EdmElement)this.getValue()).cast());
    }

    @Override
    public <V> Deserializer.Map<V> map(Endec<V> valueEndec) {
        return new Map<V>(valueEndec, (java.util.Map)((EdmElement)this.getValue()).cast());
    }

    @Override
    public Deserializer.Struct struct() {
        return new Struct((java.util.Map)((EdmElement)this.getValue()).cast());
    }

    @Override
    public <S> void readAny(Serializer<S> visitor) {
        this.visit(visitor, (EdmElement)this.getValue());
    }

    private <S> void visit(Serializer<S> visitor, EdmElement<?> value) {
        switch (value.type()) {
            case BYTE: {
                visitor.writeByte((Byte)value.cast());
                break;
            }
            case SHORT: {
                visitor.writeShort((Short)value.cast());
                break;
            }
            case INT: {
                visitor.writeInt((Integer)value.cast());
                break;
            }
            case LONG: {
                visitor.writeLong((Long)value.cast());
                break;
            }
            case FLOAT: {
                visitor.writeFloat(((Float)value.cast()).floatValue());
                break;
            }
            case DOUBLE: {
                visitor.writeDouble((Double)value.cast());
                break;
            }
            case BOOLEAN: {
                visitor.writeBoolean((Boolean)value.cast());
                break;
            }
            case STRING: {
                visitor.writeString((String)value.cast());
                break;
            }
            case BYTES: {
                visitor.writeBytes((byte[])value.cast());
                break;
            }
            case OPTIONAL: {
                visitor.writeOptional(Endec.of(this::visit, deserializer -> null), (Optional)value.cast());
                break;
            }
            case SEQUENCE: {
                try (Serializer.Sequence<EdmElement> sequence = visitor.sequence(Endec.of(this::visit, deserializer -> null), ((List)value.cast()).size());){
                    ((List)value.cast()).forEach(sequence::element);
                    break;
                }
            }
            case MAP: {
                Serializer.Map<EdmElement> map = visitor.map(Endec.of(this::visit, deserializer -> null), ((java.util.Map)value.cast()).size());
                try {
                    ((java.util.Map)value.cast()).forEach(map::entry);
                    if (map == null) break;
                }
                catch (Throwable throwable) {
                    if (map != null) {
                        try {
                            map.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                map.close();
                break;
            }
        }
    }

    private class Sequence<V>
    implements Deserializer.Sequence<V> {
        private final Endec<V> valueEndec;
        private final Iterator<EdmElement<?>> elements;
        private final int size;

        private Sequence(Endec<V> valueEndec, List<EdmElement<?>> elements) {
            this.valueEndec = valueEndec;
            this.elements = elements.iterator();
            this.size = elements.size();
        }

        @Override
        public int estimatedSize() {
            return this.size;
        }

        @Override
        public boolean hasNext() {
            return this.elements.hasNext();
        }

        @Override
        public V next() {
            return (V)EdmDeserializer.this.frame(this.elements::next, () -> this.valueEndec.decode(EdmDeserializer.this), false);
        }
    }

    private class Map<V>
    implements Deserializer.Map<V> {
        private final Endec<V> valueEndec;
        private final Iterator<Map.Entry<String, EdmElement<?>>> entries;
        private final int size;

        private Map(Endec<V> valueEndec, java.util.Map<String, EdmElement<?>> entries) {
            this.valueEndec = valueEndec;
            this.entries = entries.entrySet().iterator();
            this.size = entries.size();
        }

        @Override
        public int estimatedSize() {
            return this.size;
        }

        @Override
        public boolean hasNext() {
            return this.entries.hasNext();
        }

        @Override
        public Map.Entry<String, V> next() {
            Map.Entry<String, EdmElement<?>> entry = this.entries.next();
            return (Map.Entry)EdmDeserializer.this.frame(entry::getValue, () -> java.util.Map.entry((String)entry.getKey(), this.valueEndec.decode(EdmDeserializer.this)), false);
        }
    }

    private class Struct
    implements Deserializer.Struct {
        private final java.util.Map<String, EdmElement<?>> map;

        private Struct(java.util.Map<String, EdmElement<?>> map) {
            this.map = map;
        }

        @Override
        @Nullable
        public <F> F field(String name, Endec<F> endec) {
            if (!this.map.containsKey(name)) {
                throw new IllegalStateException("Field '" + name + "' was missing from serialized data, but no default value was provided");
            }
            return (F)EdmDeserializer.this.frame(() -> this.map.get(name), () -> endec.decode(EdmDeserializer.this), true);
        }

        @Override
        @Nullable
        public <F> F field(String name, Endec<F> endec, @Nullable F defaultValue) {
            if (!this.map.containsKey(name)) {
                return defaultValue;
            }
            return (F)EdmDeserializer.this.frame(() -> this.map.get(name), () -> endec.decode(EdmDeserializer.this), true);
        }
    }
}

