/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.endec;

import com.mojang.datafixers.util.Function3;
import io.wispforest.owo.serialization.Endec;
import io.wispforest.owo.serialization.SerializationAttribute;
import io.wispforest.owo.serialization.endec.StructEndecBuilder;
import io.wispforest.owo.serialization.format.nbt.NbtEndec;
import java.time.Instant;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_8824;
import org.joml.Vector3f;

public final class BuiltInEndecs {
    public static final Endec<int[]> INT_ARRAY = Endec.INT.listOf().xmap(list -> list.stream().mapToInt(v -> v).toArray(), ints -> Arrays.stream(ints).boxed().toList());
    public static final Endec<long[]> LONG_ARRAY = Endec.LONG.listOf().xmap(list -> list.stream().mapToLong(v -> v).toArray(), longs -> Arrays.stream(longs).boxed().toList());
    public static final Endec<BitSet> BITSET = LONG_ARRAY.xmap(BitSet::valueOf, BitSet::toLongArray);
    public static final Endec<UUID> UUID = Endec.ifAttr(SerializationAttribute.HUMAN_READABLE, Endec.STRING.xmap(UUID::fromString, UUID::toString)).orElse(INT_ARRAY.xmap(class_4844::method_26276, class_4844::method_26275));
    public static final Endec<Date> DATE = Endec.ifAttr(SerializationAttribute.HUMAN_READABLE, Endec.STRING.xmap(s -> Date.from(Instant.parse(s)), date -> date.toInstant().toString())).orElse(Endec.LONG.xmap(Date::new, Date::getTime));
    public static final Endec<class_2960> IDENTIFIER = Endec.STRING.xmap(class_2960::new, class_2960::toString);
    public static final Endec<class_1799> ITEM_STACK = NbtEndec.COMPOUND.xmap(class_1799::method_7915, stack -> stack.method_7953(new class_2487()));
    public static final Endec<class_2561> TEXT = Endec.ofCodec(class_8824.field_46597);
    public static final Endec<class_2382> VEC3I = BuiltInEndecs.vectorEndec("Vec3i", Endec.INT, class_2382::new, class_2382::method_10263, class_2382::method_10264, class_2382::method_10260);
    public static final Endec<class_243> VEC3D = BuiltInEndecs.vectorEndec("Vec3d", Endec.DOUBLE, class_243::new, class_243::method_10216, class_243::method_10214, class_243::method_10215);
    public static final Endec<Vector3f> VECTOR3F = BuiltInEndecs.vectorEndec("Vector3f", Endec.FLOAT, Vector3f::new, Vector3f::x, Vector3f::y, Vector3f::z);
    public static final Endec<class_2338> BLOCK_POS = Endec.ifAttr(SerializationAttribute.HUMAN_READABLE, BuiltInEndecs.vectorEndec("BlockPos", Endec.INT, class_2338::new, class_2382::method_10263, class_2382::method_10264, class_2382::method_10260)).orElse(Endec.LONG.xmap(class_2338::method_10092, class_2338::method_10063));
    public static final Endec<class_1923> CHUNK_POS = Endec.ifAttr(SerializationAttribute.HUMAN_READABLE, Endec.INT.listOf().validate(ints -> {
        if (ints.size() != 2) {
            throw new IllegalStateException("ChunkPos array must have two elements");
        }
    }).xmap(ints -> new class_1923(((Integer)ints.get(0)).intValue(), ((Integer)ints.get(1)).intValue()), chunkPos -> List.of(Integer.valueOf(chunkPos.field_9181), Integer.valueOf(chunkPos.field_9180)))).orElse(Endec.LONG.xmap(class_1923::new, class_1923::method_8324));
    public static final Endec<class_3965> BLOCK_HIT_RESULT = StructEndecBuilder.of(VEC3D.fieldOf("pos", class_239::method_17784), Endec.forEnum(class_2350.class).fieldOf("side", class_3965::method_17780), BLOCK_POS.fieldOf("block_pos", class_3965::method_17777), Endec.BOOLEAN.fieldOf("inside_block", class_3965::method_17781), Endec.BOOLEAN.fieldOf("missed", $ -> $.method_17783() == class_239.class_240.field_1333), (pos, side, blockPos, insideBlock, missed) -> missed == false ? new class_3965(pos, side, blockPos, insideBlock.booleanValue()) : class_3965.method_17778((class_243)pos, (class_2350)side, (class_2338)blockPos));
    public static final Endec<class_2540> PACKET_BYTE_BUF = Endec.BYTES.xmap(bytes -> {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_52983(bytes);
        return buffer;
    }, buffer -> {
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.method_52979(bytes);
        return bytes;
    });

    private BuiltInEndecs() {
    }

    public static <T> Endec<T> ofRegistry(class_2378<T> registry) {
        return IDENTIFIER.xmap(arg_0 -> registry.method_10223(arg_0), arg_0 -> registry.method_10221(arg_0));
    }

    public static <T> Endec<class_6862<T>> unprefixedTagKey(class_5321<? extends class_2378<T>> registry) {
        return IDENTIFIER.xmap(id -> class_6862.method_40092((class_5321)registry, (class_2960)id), class_6862::comp_327);
    }

    public static <T> Endec<class_6862<T>> prefixedTagKey(class_5321<? extends class_2378<T>> registry) {
        return Endec.STRING.xmap(s -> class_6862.method_40092((class_5321)registry, (class_2960)new class_2960(s.substring(1))), tag -> "#" + tag.comp_327());
    }

    private static <C, V> Endec<V> vectorEndec(String name, Endec<C> componentEndec, Function3<C, C, C, V> constructor, Function<V, C> xGetter, Function<V, C> yGetter, Function<V, C> zGetter) {
        return componentEndec.listOf().validate(ints -> {
            if (ints.size() != 3) {
                throw new IllegalStateException(name + " array must have three elements");
            }
        }).xmap(components -> constructor.apply(components.get(0), components.get(1), components.get(2)), vector -> List.of(xGetter.apply(vector), yGetter.apply(vector), zGetter.apply(vector)));
    }
}

