/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.endec;

import io.wispforest.owo.serialization.Deserializer;
import io.wispforest.owo.serialization.Endec;
import io.wispforest.owo.serialization.SerializationAttribute;
import io.wispforest.owo.serialization.Serializer;
import java.util.LinkedHashMap;
import java.util.Map;

public class AttributeEndecBuilder<T> {
    private final Map<SerializationAttribute, Endec<T>> branches = new LinkedHashMap<SerializationAttribute, Endec<T>>();

    public AttributeEndecBuilder(Endec<T> endec, SerializationAttribute attribute) {
        this.branches.put(attribute, endec);
    }

    public AttributeEndecBuilder<T> orElseIf(Endec<T> endec, SerializationAttribute attribute) {
        if (this.branches.containsKey((Object)attribute)) {
            throw new IllegalStateException("Cannot have more than one branch for attribute " + attribute.name());
        }
        this.branches.put(attribute, endec);
        return this;
    }

    public Endec<T> orElse(final Endec<T> endec) {
        return new Endec<T>(){

            @Override
            public void encode(Serializer<?> serializer, T value) {
                Endec branchEndec = endec;
                for (Map.Entry branch : AttributeEndecBuilder.this.branches.entrySet()) {
                    if (!serializer.attributes().contains((Object)branch.getKey())) continue;
                    branchEndec = branch.getValue();
                    break;
                }
                branchEndec.encode(serializer, value);
            }

            @Override
            public T decode(Deserializer<?> deserializer) {
                Endec branchEndec = endec;
                for (Map.Entry branch : AttributeEndecBuilder.this.branches.entrySet()) {
                    if (!deserializer.attributes().contains((Object)branch.getKey())) continue;
                    branchEndec = branch.getValue();
                    break;
                }
                return branchEndec.decode(deserializer);
            }
        };
    }
}

