/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization;

import io.wispforest.owo.serialization.Endec;
import io.wispforest.owo.serialization.SerializationAttribute;
import io.wispforest.owo.serialization.format.forwarding.ForwardingDeserializer;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public interface Deserializer<T> {
    default public Deserializer<T> withAttributes(SerializationAttribute ... assumedAttributes) {
        if (assumedAttributes.length == 0) {
            return this;
        }
        return ForwardingDeserializer.of(this, assumedAttributes);
    }

    public Set<SerializationAttribute> attributes();

    public byte readByte();

    public short readShort();

    public int readInt();

    public long readLong();

    public float readFloat();

    public double readDouble();

    public int readVarInt();

    public long readVarLong();

    public boolean readBoolean();

    public String readString();

    public byte[] readBytes();

    public <V> Optional<V> readOptional(Endec<V> var1);

    public <E> Sequence<E> sequence(Endec<E> var1);

    public <V> Map<V> map(Endec<V> var1);

    public Struct struct();

    public <V> V tryRead(Function<Deserializer<T>, V> var1);

    public static interface Struct {
        @Nullable
        public <F> F field(String var1, Endec<F> var2);

        @Nullable
        public <F> F field(String var1, Endec<F> var2, @Nullable F var3);
    }

    public static interface Map<E>
    extends Iterator<Map.Entry<String, E>> {
        public int estimatedSize();

        @Override
        public boolean hasNext();

        @Override
        public Map.Entry<String, E> next();
    }

    public static interface Sequence<E>
    extends Iterator<E> {
        public int estimatedSize();

        @Override
        public boolean hasNext();

        @Override
        public E next();
    }
}

