/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.network;

import io.wispforest.owo.Owo;
import io.wispforest.owo.mixin.ClientCommonNetworkHandlerAccessor;
import io.wispforest.owo.mixin.ServerCommonNetworkHandlerAccessor;
import io.wispforest.owo.network.OwoClientConnectionExtension;
import io.wispforest.owo.network.OwoNetChannel;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.particles.systems.ParticleSystemController;
import io.wispforest.owo.serialization.Endec;
import io.wispforest.owo.serialization.endec.BuiltInEndecs;
import io.wispforest.owo.util.OwoFreezer;
import io.wispforest.owo.util.ServicesFrozenException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.ToIntFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_8610;
import net.minecraft.class_8674;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class OwoHandshake {
    private static final Endec<Map<class_2960, Integer>> CHANNEL_HASHES_ENDEC = Endec.map(BuiltInEndecs.IDENTIFIER, Endec.INT);
    private static final class_5250 PREFIX = TextOps.concat(Owo.PREFIX, class_2561.method_30163((String)"\u00a7chandshake failure\n"));
    public static final class_2960 CHANNEL_ID = new class_2960("owo", "handshake");
    public static final class_2960 OFF_CHANNEL_ID = new class_2960("owo", "handshake_off");
    private static final boolean ENABLED = System.getProperty("owo.handshake.enabled") != null ? Boolean.getBoolean("owo.handshake.enabled") : Owo.DEBUG;
    private static boolean HANDSHAKE_REQUIRED = false;
    private static boolean QUERY_RECEIVED = false;

    private OwoHandshake() {
    }

    public static void enable() {
        if (OwoFreezer.isFrozen()) {
            throw new ServicesFrozenException("The o\u03c9o handshake may only be enabled during mod initialization");
        }
    }

    public static void requireHandshake() {
        if (OwoFreezer.isFrozen()) {
            throw new ServicesFrozenException("The o\u03c9o handshake may only be made required during mod initialization");
        }
        HANDSHAKE_REQUIRED = true;
    }

    public static boolean isValidClient() {
        return ENABLED && QUERY_RECEIVED;
    }

    private static void configureStart(class_8610 handler, MinecraftServer server) {
        if (!ENABLED) {
            return;
        }
        if (ServerConfigurationNetworking.canSend((class_8610)handler, (class_2960)OFF_CHANNEL_ID)) {
            Owo.LOGGER.info("[Handshake] Handshake disabled by client, skipping");
            return;
        }
        if (!ServerConfigurationNetworking.canSend((class_8610)handler, (class_2960)CHANNEL_ID)) {
            if (!HANDSHAKE_REQUIRED) {
                return;
            }
            handler.method_52396((class_2561)TextOps.concat((class_2561)PREFIX, class_2561.method_30163((String)"incompatible client")));
            Owo.LOGGER.info("[Handshake] Handshake failed, client doesn't understand channel packet");
            return;
        }
        class_2540 request = PacketByteBufs.create();
        OwoHandshake.writeHashes(request, OwoNetChannel.OPTIONAL_CHANNELS, OwoHandshake::hashChannel);
        ServerConfigurationNetworking.send((class_8610)handler, (class_2960)CHANNEL_ID, (class_2540)request);
        Owo.LOGGER.info("[Handshake] Sending channel packet");
    }

    @Environment(value=EnvType.CLIENT)
    private static void syncClient(class_310 client, class_8674 handler, class_2540 buf, PacketSender sender) {
        Owo.LOGGER.info("[Handshake] Sending client channels");
        QUERY_RECEIVED = true;
        if (buf.readableBytes() > 0) {
            Map serverOptionalChannels = (Map)buf.read(CHANNEL_HASHES_ENDEC);
            ((OwoClientConnectionExtension)((ClientCommonNetworkHandlerAccessor)handler).getConnection()).owo$setChannelSet(OwoHandshake.filterOptionalServices(serverOptionalChannels, OwoNetChannel.REGISTERED_CHANNELS, OwoHandshake::hashChannel));
        }
        class_2540 response = PacketByteBufs.create();
        OwoHandshake.writeHashes(response, OwoNetChannel.REQUIRED_CHANNELS, OwoHandshake::hashChannel);
        OwoHandshake.writeHashes(response, ParticleSystemController.REGISTERED_CONTROLLERS, OwoHandshake::hashController);
        OwoHandshake.writeHashes(response, OwoNetChannel.OPTIONAL_CHANNELS, OwoHandshake::hashChannel);
        sender.sendPacket(CHANNEL_ID, response);
    }

    private static void syncServer(MinecraftServer server, class_8610 handler, class_2540 buf, PacketSender responseSender) {
        Owo.LOGGER.info("[Handshake] Receiving client channels");
        Map clientChannels = (Map)buf.read(CHANNEL_HASHES_ENDEC);
        Map clientParticleControllers = (Map)buf.read(CHANNEL_HASHES_ENDEC);
        StringBuilder disconnectMessage = new StringBuilder();
        boolean isAllGood = OwoHandshake.verifyReceivedHashes("channels", clientChannels, OwoNetChannel.REQUIRED_CHANNELS, OwoHandshake::hashChannel, disconnectMessage);
        if (!(isAllGood &= OwoHandshake.verifyReceivedHashes("controllers", clientParticleControllers, ParticleSystemController.REGISTERED_CONTROLLERS, OwoHandshake::hashController, disconnectMessage))) {
            handler.method_52396((class_2561)TextOps.concat((class_2561)PREFIX, class_2561.method_30163((String)disconnectMessage.toString())));
        }
        if (buf.readableBytes() > 0) {
            Map clientOptionalChannels = (Map)buf.read(CHANNEL_HASHES_ENDEC);
            ((OwoClientConnectionExtension)((ServerCommonNetworkHandlerAccessor)handler).owo$getConnection()).owo$setChannelSet(OwoHandshake.filterOptionalServices(clientOptionalChannels, OwoNetChannel.OPTIONAL_CHANNELS, OwoHandshake::hashChannel));
        }
        Owo.LOGGER.info("[Handshake] Handshake completed successfully");
    }

    @Environment(value=EnvType.CLIENT)
    private static void handleReadyClient(class_8674 handler, class_310 client) {
        if (ClientConfigurationNetworking.canSend((class_2960)CHANNEL_ID) || !HANDSHAKE_REQUIRED || !ENABLED) {
            return;
        }
        client.execute(() -> ((ClientCommonNetworkHandlerAccessor)handler).getConnection().method_10747((class_2561)TextOps.concat((class_2561)PREFIX, class_2561.method_30163((String)"incompatible server"))));
    }

    private static <T> Set<class_2960> filterOptionalServices(Map<class_2960, Integer> remoteMap, Map<class_2960, T> localMap, ToIntFunction<T> hashFunction) {
        HashSet<class_2960> readableServices = new HashSet<class_2960>();
        for (Map.Entry<class_2960, Integer> entry : remoteMap.entrySet()) {
            T service = localMap.get(entry.getKey());
            if (service == null || hashFunction.applyAsInt(service) != entry.getValue().intValue()) continue;
            readableServices.add(entry.getKey());
        }
        return readableServices;
    }

    private static <T> boolean verifyReceivedHashes(String serviceNamePlural, Map<class_2960, Integer> clientMap, Map<class_2960, T> serverMap, ToIntFunction<T> hashFunction, StringBuilder disconnectMessage) {
        boolean isAllGood = true;
        if (!clientMap.keySet().equals(serverMap.keySet())) {
            isAllGood = false;
            class_3545<Set<class_2960>, Set<class_2960>> leftovers = OwoHandshake.findCollisions(clientMap.keySet(), serverMap.keySet());
            if (!((Set)leftovers.method_15442()).isEmpty()) {
                disconnectMessage.append("server is missing ").append(serviceNamePlural).append(":\n");
                ((Set)leftovers.method_15442()).forEach(identifier -> disconnectMessage.append("\u00a77").append(identifier).append("\u00a7r\n"));
            }
            if (!((Set)leftovers.method_15441()).isEmpty()) {
                disconnectMessage.append("client is missing ").append(serviceNamePlural).append(":\n");
                ((Set)leftovers.method_15441()).forEach(identifier -> disconnectMessage.append("\u00a77").append(identifier).append("\u00a7r\n"));
            }
        }
        boolean hasMismatchedHashes = false;
        for (Map.Entry<class_2960, Integer> entry : clientMap.entrySet()) {
            int localHash;
            T actualServiceObject = serverMap.get(entry.getKey());
            if (actualServiceObject == null || (localHash = hashFunction.applyAsInt(actualServiceObject)) == entry.getValue()) continue;
            if (!hasMismatchedHashes) {
                disconnectMessage.append(serviceNamePlural).append(" with mismatched hashes:\n");
            }
            disconnectMessage.append("\u00a77").append(entry.getKey()).append("\u00a7r\n");
            isAllGood = false;
            hasMismatchedHashes = true;
        }
        return isAllGood;
    }

    private static <T> void writeHashes(class_2540 buffer, Map<class_2960, T> values, ToIntFunction<T> hashFunction) {
        HashMap<class_2960, Integer> hashes = new HashMap<class_2960, Integer>();
        for (Map.Entry<class_2960, T> entry : values.entrySet()) {
            hashes.put(entry.getKey(), hashFunction.applyAsInt(entry.getValue()));
        }
        buffer.write(CHANNEL_HASHES_ENDEC, hashes);
    }

    private static class_3545<Set<class_2960>, Set<class_2960>> findCollisions(Set<class_2960> first, Set<class_2960> second) {
        HashSet firstLeftovers = new HashSet();
        HashSet secondLeftovers = new HashSet();
        first.forEach(identifier -> {
            if (!second.contains(identifier)) {
                firstLeftovers.add(identifier);
            }
        });
        second.forEach(identifier -> {
            if (!first.contains(identifier)) {
                secondLeftovers.add(identifier);
            }
        });
        return new class_3545(firstLeftovers, secondLeftovers);
    }

    private static int hashChannel(OwoNetChannel channel) {
        int serializersHash = 0;
        for (Int2ObjectMap.Entry entry : channel.endecsByIndex.int2ObjectEntrySet()) {
            serializersHash += entry.getIntKey() * 31 + ((OwoNetChannel.IndexedEndec)entry.getValue()).getRecordClass().getName().hashCode();
        }
        return 31 * channel.packetId.hashCode() + serializersHash;
    }

    private static int hashController(ParticleSystemController controller) {
        int serializersHash = 0;
        for (Int2ObjectMap.Entry entry : controller.systemsByIndex.int2ObjectEntrySet()) {
            serializersHash += entry.getIntKey();
        }
        return 31 * controller.channelId.hashCode() + serializersHash;
    }

    static {
        ServerConfigurationConnectionEvents.CONFIGURE.register(OwoHandshake::configureStart);
        ServerConfigurationNetworking.registerGlobalReceiver((class_2960)CHANNEL_ID, OwoHandshake::syncServer);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            if (!ENABLED) {
                ClientConfigurationNetworking.registerGlobalReceiver((class_2960)OFF_CHANNEL_ID, (client, handler, buf, responseSender) -> {});
            }
            ClientConfigurationNetworking.registerGlobalReceiver((class_2960)CHANNEL_ID, OwoHandshake::syncClient);
            ClientConfigurationConnectionEvents.READY.register(OwoHandshake::handleReadyClient);
            ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
                QUERY_RECEIVED = false;
            });
            ClientConfigurationConnectionEvents.DISCONNECT.register((handler, client) -> {
                QUERY_RECEIVED = false;
            });
        }
    }
}

