/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.config;

import com.google.common.collect.HashMultimap;
import io.netty.buffer.ByteBuf;
import io.wispforest.owo.Owo;
import io.wispforest.owo.config.ConfigWrapper;
import io.wispforest.owo.config.Option;
import io.wispforest.owo.mixin.ServerCommonNetworkHandlerAccessor;
import io.wispforest.owo.ops.TextOps;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ConfigSynchronizer {
    public static final class_2960 CONFIG_SYNC_CHANNEL = new class_2960("owo", "config_sync");
    private static final Map<class_2535, Map<String, Map<Option.Key, Object>>> CLIENT_OPTION_STORAGE = new WeakHashMap<class_2535, Map<String, Map<Option.Key, Object>>>();
    private static final Map<String, ConfigWrapper<?>> KNOWN_CONFIGS = new HashMap();
    private static final class_5250 PREFIX = TextOps.concat(Owo.PREFIX, class_2561.method_30163((String)"\u00a7cunrecoverable config mismatch\n\n"));

    static void register(ConfigWrapper<?> config) {
        KNOWN_CONFIGS.put(config.name(), config);
    }

    @Nullable
    public static Map<Option.Key, ?> getClientOptions(class_3222 player, String configName) {
        Map<String, Map<Option.Key, Object>> storage = CLIENT_OPTION_STORAGE.get(((ServerCommonNetworkHandlerAccessor)player.field_13987).owo$getConnection());
        if (storage == null) {
            return null;
        }
        return storage.get(configName);
    }

    @Nullable
    public static Map<Option.Key, ?> getClientOptions(class_3222 player, ConfigWrapper<?> config) {
        return ConfigSynchronizer.getClientOptions(player, config.name());
    }

    private static void write(class_2540 packet, Option.SyncMode targetMode) {
        packet.method_10804(KNOWN_CONFIGS.size());
        class_2540 configBuf = PacketByteBufs.create();
        class_2540 optionBuf = PacketByteBufs.create();
        KNOWN_CONFIGS.forEach((configName, config) -> {
            packet.method_10814(configName);
            configBuf.method_52933().method_52935();
            configBuf.method_10804((int)config.allOptions().values().stream().filter(option -> option.syncMode().ordinal() >= targetMode.ordinal()).count());
            config.allOptions().forEach((key, option) -> {
                if (option.syncMode().ordinal() < targetMode.ordinal()) {
                    return;
                }
                configBuf.method_10814(key.asString());
                optionBuf.method_52933().method_52935();
                option.write(optionBuf);
                configBuf.method_10804(optionBuf.readableBytes());
                configBuf.method_52975((ByteBuf)optionBuf);
            });
            packet.method_10804(configBuf.readableBytes());
            packet.method_52975((ByteBuf)configBuf);
        });
    }

    private static void read(class_2540 buf, BiConsumer<Option<?>, class_2540> optionConsumer) {
        int configCount = buf.method_10816();
        for (int i = 0; i < configCount; ++i) {
            String configName = buf.method_19772();
            ConfigWrapper<?> config = KNOWN_CONFIGS.get(configName);
            if (config == null) {
                Owo.LOGGER.error("Received overrides for unknown config '{}', skipping", (Object)configName);
                buf.method_52994(buf.method_10816());
                continue;
            }
            buf.method_10816();
            int optionCount = buf.method_10816();
            for (int j = 0; j < optionCount; ++j) {
                Option.Key optionKey = new Option.Key(buf.method_19772());
                Option option = config.optionForKey(optionKey);
                if (option == null) {
                    Owo.LOGGER.error("Received override for unknown option '{}' in config '{}', skipping", (Object)optionKey, (Object)configName);
                    buf.method_52994(buf.method_10816());
                    continue;
                }
                buf.method_10816();
                optionConsumer.accept(option, buf);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void applyClient(class_310 client, class_634 handler, class_2540 buf, PacketSender sender) {
        Owo.LOGGER.info("Applying server overrides");
        HashMap<Option, Object> mismatchedOptions = new HashMap<Option, Object>();
        if (!client.method_1496() || !client.method_1576().method_3724()) {
            ConfigSynchronizer.read(buf, (option, packetByteBuf) -> {
                Object mismatchedValue = option.read((class_2540)packetByteBuf);
                if (mismatchedValue != null) {
                    mismatchedOptions.put((Option)option, mismatchedValue);
                }
            });
            if (!mismatchedOptions.isEmpty()) {
                Owo.LOGGER.error("Aborting connection, non-syncable config values were mismatched");
                mismatchedOptions.forEach((option, serverValue) -> Owo.LOGGER.error("- Option {} in config '{}' has value '{}' but server requires '{}'", (Object)option.key().asString(), (Object)option.configName(), option.value(), serverValue));
                class_5250 errorMessage = class_2561.method_43473();
                HashMultimap optionsByConfig = HashMultimap.create();
                mismatchedOptions.forEach((option, serverValue) -> optionsByConfig.put((Object)option.configName(), (Object)new class_3545(option, serverValue)));
                for (String configName : optionsByConfig.keys()) {
                    errorMessage.method_10852((class_2561)TextOps.withFormatting("in config ", class_124.field_1080)).method_27693(configName).method_27693("\n");
                    for (class_3545 option2 : optionsByConfig.get((Object)configName)) {
                        errorMessage.method_10852((class_2561)class_2561.method_43471((String)((Option)option2.method_15442()).translationKey()).method_27692(class_124.field_1054)).method_27693(" -> ");
                        errorMessage.method_27693(((Option)option2.method_15442()).value().toString()).method_10852((class_2561)TextOps.withFormatting(" (client)", class_124.field_1080));
                        errorMessage.method_10852((class_2561)TextOps.withFormatting(" / ", class_124.field_1063));
                        errorMessage.method_27693(option2.method_15441().toString()).method_10852((class_2561)TextOps.withFormatting(" (server)", class_124.field_1080)).method_27693("\n");
                    }
                    errorMessage.method_27693("\n");
                }
                errorMessage.method_10852((class_2561)TextOps.withFormatting("these options could not be synchronized because\n", class_124.field_1080));
                errorMessage.method_10852((class_2561)TextOps.withFormatting("they require your client to be restarted\n", class_124.field_1080));
                errorMessage.method_10852((class_2561)TextOps.withFormatting("change them manually and restart if you want to join this server", class_124.field_1080));
                handler.method_48296().method_10747((class_2561)TextOps.concat((class_2561)PREFIX, (class_2561)errorMessage));
                return;
            }
        }
        Owo.LOGGER.info("Responding with client values");
        class_2540 packet = PacketByteBufs.create();
        ConfigSynchronizer.write(packet, Option.SyncMode.INFORM_SERVER);
        sender.sendPacket(CONFIG_SYNC_CHANNEL, packet);
    }

    private static void applyServer(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender sender) {
        Owo.LOGGER.info("Receiving client config");
        class_2535 connection = ((ServerCommonNetworkHandlerAccessor)player.field_13987).owo$getConnection();
        ConfigSynchronizer.read(buf, (option, optionBuf) -> {
            Map config = CLIENT_OPTION_STORAGE.computeIfAbsent(connection, $ -> new HashMap()).computeIfAbsent(option.configName(), s -> new HashMap());
            config.put(option.key(), optionBuf.read(option.endec()));
        });
    }

    static {
        class_2960 earlyPhase = new class_2960("owo", "early");
        ServerPlayConnectionEvents.JOIN.addPhaseOrdering(earlyPhase, Event.DEFAULT_PHASE);
        ServerPlayConnectionEvents.JOIN.register(earlyPhase, (handler, sender, server) -> {
            Owo.LOGGER.info("Sending server config values to client");
            class_2540 packet = PacketByteBufs.create();
            ConfigSynchronizer.write(packet, Option.SyncMode.OVERRIDE_CLIENT);
            sender.sendPacket(CONFIG_SYNC_CHANNEL, packet);
        });
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)CONFIG_SYNC_CHANNEL, ConfigSynchronizer::applyClient);
            ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> KNOWN_CONFIGS.forEach((name, config) -> config.forEachOption(Option::reattach)));
        }
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CONFIG_SYNC_CHANNEL, ConfigSynchronizer::applyServer);
    }
}

