/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.gui.GroupType;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_8685;

public class JoinGroupEntry
extends ListScreenEntryBase<JoinGroupEntry> {
    protected static final class_2960 LOCK = new class_2960("voicechat", "textures/icons/lock.png");
    protected static final class_2561 GROUP_MEMBERS = class_2561.method_43471((String)"message.voicechat.group_members").method_27692(class_124.field_1080);
    protected static final class_2561 NO_GROUP_MEMBERS = class_2561.method_43471((String)"message.voicechat.no_group_members").method_27692(class_124.field_1080);
    protected static final int SKIN_SIZE = 12;
    protected static final int PADDING = 4;
    protected static final int BG_FILL = class_5253.class_5254.method_27764((int)255, (int)74, (int)74, (int)74);
    protected static final int BG_FILL_SELECTED = class_5253.class_5254.method_27764((int)255, (int)90, (int)90, (int)90);
    protected static final int PLAYER_NAME_COLOR = class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255);
    protected final ListScreenBase parent;
    protected final class_310 minecraft;
    protected final Group group;

    public JoinGroupEntry(ListScreenBase parent, Group group) {
        this.parent = parent;
        this.minecraft = class_310.method_1551();
        this.group = group;
    }

    public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        if (hovered) {
            guiGraphics.method_25294(left, top, left + width, top + height, BG_FILL_SELECTED);
        } else {
            guiGraphics.method_25294(left, top, left + width, top + height, BG_FILL);
        }
        boolean hasPassword = this.group.group.hasPassword();
        if (hasPassword) {
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416((float)(left + 4), (float)top + (float)height / 2.0f - 8.0f, 0.0f);
            guiGraphics.method_51448().method_22905(1.3333334f, 1.3333334f, 1.0f);
            guiGraphics.method_25290(LOCK, 0, 0, 0.0f, 0.0f, 12, 12, 16, 16);
            guiGraphics.method_51448().method_22909();
        }
        class_5250 groupName = class_2561.method_43470((String)this.group.group.getName());
        class_327 class_3272 = this.minecraft.field_1772;
        int n = left + 4 + (hasPassword ? 20 : 0);
        int n2 = top + height / 2;
        Objects.requireNonNull(this.minecraft.field_1772);
        guiGraphics.method_51439(class_3272, (class_2561)groupName, n, n2 - 9 / 2, PLAYER_NAME_COLOR, false);
        int textWidth = this.minecraft.field_1772.method_27525((class_5348)groupName) + (hasPassword ? 20 : 0);
        int headsPerRow = (width - (4 + textWidth + 4 + 4)) / 13;
        int rows = 2;
        for (int i = 0; i < this.group.members.size(); ++i) {
            PlayerState state = this.group.members.get(i);
            int headXIndex = i / rows;
            int headYIndex = i % rows;
            if (i >= headsPerRow * rows) break;
            int headPosX = left + width - 12 - 4 - headXIndex * 13;
            int headPosY = top + height / 2 - 13 + 13 * headYIndex;
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416((float)headPosX, (float)headPosY, 0.0f);
            float scale = 1.5f;
            guiGraphics.method_51448().method_22905(scale, scale, scale);
            class_8685 skin = GameProfileUtils.getSkin(state.getUuid());
            guiGraphics.method_25290(skin.comp_1626(), 0, 0, 8.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.enableBlend();
            guiGraphics.method_25290(skin.comp_1626(), 0, 0, 40.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.disableBlend();
            guiGraphics.method_51448().method_22909();
        }
        if (!hovered) {
            return;
        }
        ArrayList tooltip = Lists.newArrayList();
        if (this.group.getGroup().getType().equals(Group.Type.NORMAL)) {
            tooltip.add(class_2561.method_43469((String)"message.voicechat.group_title", (Object[])new Object[]{class_2561.method_43470((String)this.group.getGroup().getName())}).method_30937());
        } else {
            tooltip.add(class_2561.method_43469((String)"message.voicechat.group_type_title", (Object[])new Object[]{class_2561.method_43470((String)this.group.getGroup().getName()), GroupType.fromType(this.group.getGroup().getType()).getTranslation()}).method_30937());
        }
        if (this.group.getMembers().isEmpty()) {
            tooltip.add(NO_GROUP_MEMBERS.method_30937());
        } else {
            tooltip.add(GROUP_MEMBERS.method_30937());
            int maxMembers = 10;
            for (int i = 0; i < this.group.getMembers().size(); ++i) {
                if (i >= maxMembers) {
                    tooltip.add(class_2561.method_43469((String)"message.voicechat.more_members", (Object[])new Object[]{this.group.getMembers().size() - maxMembers}).method_27692(class_124.field_1080).method_30937());
                    break;
                }
                PlayerState state = this.group.getMembers().get(i);
                tooltip.add(class_2561.method_43470((String)("  " + state.getName())).method_27692(class_124.field_1080).method_30937());
            }
        }
        this.parent.postRender(() -> guiGraphics.method_51447(this.minecraft.field_1772, tooltip, mouseX, mouseY));
    }

    public Group getGroup() {
        return this.group;
    }

    public static class Group {
        private final ClientGroup group;
        private final List<PlayerState> members;

        public Group(ClientGroup group) {
            this.group = group;
            this.members = new ArrayList<PlayerState>();
        }

        public ClientGroup getGroup() {
            return this.group;
        }

        public List<PlayerState> getMembers() {
            return this.members;
        }
    }
}

