/*
 * Decompiled with CFR 0.152.
 */
package forge.com.mrmelon54.EnhancedSearchability.mixin.server;

import forge.com.mrmelon54.EnhancedSearchability.EnhancedSearchability;
import forge.com.mrmelon54.EnhancedSearchability.duck.FilterSupplier;
import forge.com.mrmelon54.EnhancedSearchability.duck.HeaderHider;
import forge.com.mrmelon54.EnhancedSearchability.duck.ListProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.server.LanServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerSelectionList.class})
public abstract class ServerSelectionListMixin
extends ObjectSelectionList<ServerSelectionList.Entry>
implements ListProvider,
FilterSupplier,
HeaderHider {
    @Shadow
    @Final
    private List<ServerSelectionList.OnlineServerEntry> f_99767_;
    @Shadow
    @Final
    private List<ServerSelectionList.NetworkServerEntry> f_99755_;
    @Shadow
    @Final
    private ServerSelectionList.Entry f_99768_;
    @Unique
    private final List<ServerSelectionList.OnlineServerEntry> enhanced_searchability$onlineServerSyncStore = new ArrayList<ServerSelectionList.OnlineServerEntry>();
    @Unique
    private final List<ServerSelectionList.NetworkServerEntry> enhanced_searchability$networkServerSyncStore = new ArrayList<ServerSelectionList.NetworkServerEntry>();
    @Unique
    private Supplier<String> enhanced_searchability$searchTextStore = () -> "";

    public ServerSelectionListMixin(Minecraft minecraft, int i, int j, int k, int l) {
        super(minecraft, i, j, k, l);
    }

    @Override
    public void enhanced_searchability$filter(Supplier<String> searchTextSupplier) {
        if (!EnhancedSearchability.CONFIG.serversEnabled) {
            return;
        }
        this.enhanced_searchability$searchTextStore = searchTextSupplier;
        this.enhanced_searchability$customAddServerStreamToUI(this.enhanced_searchability$onlineServerSyncStore.stream(), this.enhanced_searchability$networkServerSyncStore.stream(), this.enhanced_searchability$searchTextStore);
    }

    @Inject(method={"refreshEntries"}, at={@At(value="TAIL")})
    private void injected_updateEntries(CallbackInfo ci) {
        if (!EnhancedSearchability.CONFIG.serversEnabled) {
            return;
        }
        this.enhanced_searchability$customAddServerStreamToUI(this.enhanced_searchability$onlineServerSyncStore.stream(), this.enhanced_searchability$networkServerSyncStore.stream(), this.enhanced_searchability$searchTextStore);
    }

    @Override
    public void enhanced_searchability$hideHeaderAndShift() {
        this.m_253211_(this.m_252907_() + 15);
        this.m_293384_(this.m_93694_() - 15);
    }

    public double m_93517_() {
        int m;
        double v = super.m_93517_();
        return v > (double)(m = this.m_93518_()) ? (double)m : v;
    }

    @Override
    public int enhanced_searchability$getRowLeft() {
        return this.m_5747_();
    }

    @Override
    public int enhanced_searchability$getRowWidth() {
        return this.m_5759_();
    }

    @Redirect(method={"updateOnlineServers"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/screens/multiplayer/ServerSelectionList;onlineServers:Ljava/util/List;", opcode=180))
    private List<ServerSelectionList.OnlineServerEntry> redirectOnlineServers(ServerSelectionList instance) {
        return !EnhancedSearchability.CONFIG.serversEnabled ? this.f_99767_ : this.enhanced_searchability$onlineServerSyncStore;
    }

    @Redirect(method={"updateNetworkServers"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/screens/multiplayer/ServerSelectionList;networkServers:Ljava/util/List;", opcode=180))
    private List<ServerSelectionList.NetworkServerEntry> redirectNetworkServers(ServerSelectionList instance) {
        return !EnhancedSearchability.CONFIG.serversEnabled ? this.f_99755_ : this.enhanced_searchability$networkServerSyncStore;
    }

    @Unique
    private void enhanced_searchability$customAddServerStreamToUI(Stream<ServerSelectionList.OnlineServerEntry> onlineStream, Stream<ServerSelectionList.NetworkServerEntry> networkStream, Supplier<String> search) {
        String s = search.get().toLowerCase(Locale.ROOT);
        this.m_6702_().clear();
        onlineStream.forEach(onlineServerEntry -> {
            String motd;
            ServerData serverData = onlineServerEntry.m_99898_();
            String name = serverData.f_105362_.toLowerCase(Locale.ROOT);
            String string = motd = serverData.f_105365_ != null ? serverData.f_105365_.getString().toLowerCase(Locale.ROOT) : "";
            if (s.isEmpty() || name.contains(s) || motd.contains(s)) {
                this.m_6702_().add(onlineServerEntry);
            }
        });
        this.m_6702_().add(this.f_99768_);
        networkStream.forEach(networkServerEntry -> {
            String motd;
            LanServer serverData = networkServerEntry.m_99838_();
            String address = serverData.m_120079_().toLowerCase(Locale.ROOT);
            String string = motd = serverData.m_120078_() != null ? serverData.m_120078_().toLowerCase(Locale.ROOT) : "";
            if (s.isEmpty() || address.contains(s) || motd.contains(s)) {
                this.m_6702_().add(networkServerEntry);
            }
        });
    }
}

