/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.peek.events;

import de.maxhenkel.peek.Peek;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4538;
import net.minecraft.class_490;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class HudEvents {
    private static final class_310 MC = class_310.method_1551();
    private static final int PADDING = 4;
    private static final Vector3f ENTITY_TRANSLATION = new Vector3f();
    private static final Quaternionf ENTITY_ANGLE = new Quaternionf().rotationXYZ(0.0f, (float)Math.PI, (float)Math.PI);
    private static final Map<class_1299<?>, class_1309> ENTITY_CACHE = new HashMap();

    public static void onRenderHud(class_332 graphics, int screenWidth, int screenHeight) {
        if (!Peek.CONFIG.showHud.get().booleanValue()) {
            return;
        }
        class_746 player = HudEvents.MC.field_1724;
        if (player == null) {
            return;
        }
        class_239 class_2392 = HudEvents.MC.field_1765;
        if (class_2392 instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)class_2392;
            HudEvents.renderBlockHud(player, graphics, screenWidth, screenHeight, blockHitResult);
        } else {
            class_2392 = HudEvents.MC.field_1765;
            if (class_2392 instanceof class_3966) {
                class_3966 entityHitResult = (class_3966)class_2392;
                HudEvents.renderEntityHud(player, graphics, screenWidth, screenHeight, entityHitResult);
            }
        }
    }

    private static void renderBlockHud(class_746 player, class_332 graphics, int screenWidth, int screenHeight, class_3965 blockHitResult) {
        class_1937 level = player.method_37908();
        class_2680 blockState = level.method_8320(blockHitResult.method_17777());
        if (blockState.method_26215()) {
            return;
        }
        class_2248 block = blockState.method_26204();
        class_1799 item = block.method_9574((class_4538)level, blockHitResult.method_17777(), blockState);
        class_2561 name = item.method_7964();
        class_327 font = HudEvents.MC.field_1772;
        int nameWidth = font.method_27525((class_5348)name);
        int itemSize = 16;
        int hudWidth = nameWidth + 12 + itemSize;
        int hudHeight = itemSize + 8;
        int hudLeft = screenWidth / 2 - hudWidth / 2;
        graphics.method_25294(hudLeft, 0, hudLeft + hudWidth, hudHeight, Peek.CONFIG.hudBackgroundColorValue);
        graphics.method_51427(item, hudLeft + 4, 4);
        int n = hudHeight / 2;
        Objects.requireNonNull(font);
        graphics.method_27535(font, name, hudLeft + itemSize + 8, n - 9 / 2, Peek.CONFIG.hudTextColorValue);
    }

    private static void renderEntityHud(class_746 player, class_332 graphics, int screenWidth, int screenHeight, class_3966 entityHitResult) {
        class_1297 entity = entityHitResult.method_17782();
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 livingEntity = (class_1309)entity;
        class_2561 name = entity.method_5477();
        class_327 font = HudEvents.MC.field_1772;
        int nameWidth = font.method_27525((class_5348)name);
        int maxEntityHeight = 16;
        int maxEntityWidth = 16;
        int hudWidth = nameWidth + 12 + maxEntityWidth;
        int hudHeight = maxEntityHeight + 8;
        int hudLeft = screenWidth / 2 - hudWidth / 2;
        graphics.method_25294(hudLeft, 0, hudLeft + hudWidth, hudHeight, Peek.CONFIG.hudBackgroundColorValue);
        HudEvents.renderEntity(graphics, (float)(hudLeft + 4) + (float)maxEntityWidth / 2.0f, 4 + maxEntityHeight, maxEntityWidth, maxEntityHeight, HudEvents.getCachedEntity(livingEntity.method_5864()));
        int n = hudHeight / 2;
        Objects.requireNonNull(font);
        graphics.method_27535(font, name, hudLeft + maxEntityWidth + 8, n - 9 / 2, Peek.CONFIG.hudTextColorValue);
    }

    private static void renderEntity(class_332 graphics, float x, float y, float maxWidth, float maxHeight, class_1309 entity) {
        if (entity == null) {
            return;
        }
        float maxXScale = maxWidth / entity.method_17681();
        float maxYScale = maxHeight / entity.method_17682();
        int entityScale = (int)Math.min(maxXScale, maxYScale);
        Quaternionf rot = new Quaternionf();
        float r = (float)((double)System.currentTimeMillis() / 20.0 % 360.0);
        ENTITY_ANGLE.rotateY((float)Math.PI / 180 * r, rot);
        class_490.method_48472((class_332)graphics, (float)x, (float)y, (int)entityScale, (Vector3f)ENTITY_TRANSLATION, (Quaternionf)rot, null, (class_1309)entity);
    }

    private static class_1309 getCachedEntity(class_1299<?> entityType) {
        return ENTITY_CACHE.computeIfAbsent(entityType, type -> (class_1309)type.method_5883((class_1937)HudEvents.MC.field_1687));
    }
}

