/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.utils.skin;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fzmm.zailer.me.builders.HeadBuilder;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.ImageUtils;
import fzmm.zailer.me.utils.skin.GetSkinDecorator;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Base64;
import java.util.Optional;
import net.minecraft.class_1799;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class GetSkinFromMojang
extends GetSkinDecorator {
    public GetSkinFromMojang(GetSkinDecorator getSkinDecorator) {
        super(getSkinDecorator);
    }

    public GetSkinFromMojang() {
        super(null);
    }

    @Override
    public Optional<BufferedImage> getSkin(String playerName) throws IOException {
        String stringUuid = FzmmUtils.fetchPlayerUuid(playerName);
        try (CloseableHttpClient httpClient = FzmmUtils.getHttpClient();){
            HttpGet httpGet = new HttpGet("https://sessionserver.mojang.com/session/minecraft/profile/" + stringUuid);
            httpGet.addHeader("content-statusType", "image/jpeg");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity resEntity = response.getEntity();
            if (response.getStatusLine().getStatusCode() / 100 != 2) {
                Optional<BufferedImage> optional = super.getSkin(playerName);
                return optional;
            }
            InputStream inputStream = resEntity.getContent();
            JsonObject obj = (JsonObject)JsonParser.parseReader((Reader)new InputStreamReader(inputStream));
            JsonObject properties = (JsonObject)obj.getAsJsonArray("properties").get(0);
            String valueJsonStr = new String(Base64.getDecoder().decode(properties.get("value").getAsString()));
            obj = (JsonObject)JsonParser.parseString((String)valueJsonStr);
            String skinUrl = obj.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
            Optional<BufferedImage> optional = ImageUtils.getImageFromUrl(skinUrl);
            return optional;
        }
    }

    @Override
    public Optional<class_1799> getHead(String playerName) {
        return Optional.of(HeadBuilder.of(playerName));
    }
}

