/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.utils;

import fzmm.zailer.me.client.gui.components.SnackBarLayout;
import fzmm.zailer.me.client.gui.components.snack_bar.BaseSnackBarComponent;
import fzmm.zailer.me.client.gui.components.snack_bar.ISnackBarComponent;
import fzmm.zailer.me.client.gui.components.snack_bar.ISnackBarScreen;
import fzmm.zailer.me.client.gui.components.style.FzmmStyles;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.hud.Hud;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class SnackBarManager {
    private static final class_2960 SNACK_BAR_HUD = class_2960.method_43902((String)"fzmm", (String)"snack_bar");
    private static final int SNACK_BAR_LIMIT = 5;
    public static final String CLIPBOARD_ID = "clipboard";
    public static final String ENCRYPTOR_SAVE_ID = "encryptor_save";
    public static final String GIVE_ID = "give";
    public static final String HEAD_GENERATOR_ID = "head_generator";
    public static final String HEAD_GENERATOR_SAVE_ID = "head_generator_save";
    public static final String IMAGE_ID = "load_image";
    public static final String IMAGETEXT_ID = "imagetext";
    public static final String INVISIBLE_ENTITY_ID = "invisible_entity";
    public static final String PLAYER_STATUE_ID = "player_statue";
    private static final SnackBarManager instance = new SnackBarManager();
    private final ISnackBarScreen hudLayout = new SnackBarLayout(Sizing.content(), Sizing.content());

    private SnackBarManager() {
        this.initHud();
    }

    public static SnackBarManager getInstance() {
        return instance;
    }

    public SnackBarManager add(List<ISnackBarComponent> snackBarList) {
        ISnackBarScreen snackBarScreen = this.getSnackScreen();
        for (ISnackBarComponent snackBar : snackBarList) {
            this.add(snackBarScreen, snackBar);
        }
        return this;
    }

    public SnackBarManager add(ISnackBarComponent snackBar) {
        this.add(this.getSnackScreen(), snackBar);
        return this;
    }

    private void initHud() {
        if (!Hud.hasComponent((class_2960)SNACK_BAR_HUD)) {
            Hud.add((class_2960)SNACK_BAR_HUD, this.hudLayout::getSnackBarLayout);
        }
    }

    private void add(ISnackBarScreen snackBarScreen, ISnackBarComponent snackBar) {
        String id = snackBar.id();
        assert (id != null);
        snackBarScreen.removeSnackBar(id);
        snackBarScreen.getSnackBarLayout().child((Component)snackBar);
        if (snackBarScreen == this.hudLayout) {
            this.enableButtons(snackBarScreen, false);
        }
    }

    public void remove(String id) {
        for (ISnackBarComponent snackBar : this.getSnackScreen().getSnackBars()) {
            if (!id.equals(snackBar.id())) continue;
            this.remove(snackBar);
            return;
        }
    }

    public void remove(ISnackBarComponent snackBar) {
        this.getSnackScreen().getSnackBarLayout().removeChild((Component)snackBar);
    }

    public void removeOverflow() {
        ISnackBarScreen snackBarScreen = this.getSnackScreen();
        List<ISnackBarComponent> snackBarList = snackBarScreen.getSnackBars();
        if (snackBarList.size() > 5 && snackBarList.stream().anyMatch(ISnackBarComponent::removeOnLimit)) {
            for (ISnackBarComponent snackBar : snackBarList) {
                if (!snackBar.removeOnLimit()) continue;
                snackBarScreen.removeSnackBar(snackBar);
                break;
            }
        }
    }

    private ISnackBarScreen getSnackScreen() {
        ISnackBarScreen screen;
        class_437 class_4372 = class_310.method_1551().field_1755;
        return class_4372 instanceof ISnackBarScreen ? (screen = (ISnackBarScreen)class_4372) : this.hudLayout;
    }

    public void moveToHud(ISnackBarScreen from) {
        this.enableButtons(from, false);
        this.move(from, this.hudLayout);
    }

    public void moveToScreen(ISnackBarScreen to) {
        this.enableButtons(this.hudLayout, true);
        this.move(this.hudLayout, to);
    }

    public void move(ISnackBarScreen from, ISnackBarScreen to) {
        List<ISnackBarComponent> snackBarComponents = from.getSnackBars();
        from.clearSnackBars();
        for (ISnackBarComponent snackBar : snackBarComponents) {
            this.add(to, snackBar);
        }
    }

    private void enableButtons(ISnackBarScreen screen, boolean value) {
        for (ISnackBarComponent snackBar : screen.getSnackBars()) {
            snackBar.buttonsEnabled(value);
        }
    }

    public static void copyToClipboard(String text) {
        class_310.method_1551().field_1774.method_1455(text);
        SnackBarManager.getInstance().add(BaseSnackBarComponent.builder(CLIPBOARD_ID).backgroundColor(FzmmStyles.ALERT_SUCCESS_COLOR).title((class_2561)class_2561.method_43471((String)"fzmm.snack_bar.clipboard.title")).lowTimer().startTimer().build());
    }
}

