/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.utils;

import com.google.gson.JsonIOException;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.SkinPart;
import fzmm.zailer.me.utils.skin.GetSkinDecorator;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class ImageUtils {
    public static BufferedImage getBufferedImgFromNativeImg(class_1011 nativeImage) {
        int width = nativeImage.method_4307();
        int height = nativeImage.method_4323();
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int color = nativeImage.method_4315(x, y);
                bufferedImage.setRGB(x, y, color >> 16 & 0xFF | (color & 0xFF) << 16 | color & 0xFF00FF00);
            }
        }
        return bufferedImage;
    }

    public static Optional<BufferedImage> getPlayerSkin(String name, GetSkinDecorator getSkinDecorator) throws NullPointerException, JsonIOException, IOException {
        Optional<BufferedImage> skin = getSkinDecorator.getSkin(name);
        if (skin.isEmpty()) {
            FzmmClient.LOGGER.warn("[ImageUtils] skin of '{}' was not found", (Object)name);
        }
        return skin;
    }

    public static Optional<BufferedImage> getImageFromUrl(String urlLocation) throws IOException {
        block12: {
            try (CloseableHttpClient httpClient = FzmmUtils.getHttpClient();){
                Optional<BufferedImage> optional;
                block13: {
                    HttpGet httpGet = new HttpGet(urlLocation);
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                    HttpEntity resEntity = response.getEntity();
                    if (resEntity == null) break block12;
                    InputStream inputStream = resEntity.getContent();
                    try {
                        BufferedImage image = ImageIO.read(inputStream);
                        optional = Optional.ofNullable(image);
                        if (inputStream == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    inputStream.close();
                }
                return optional;
            }
        }
        return Optional.empty();
    }

    public static class_1011 toNativeImage(BufferedImage image) {
        class_1011 nativeImage = new class_1011(class_1011.class_1012.field_4997, image.getWidth(), image.getHeight(), false);
        ColorModel colorModel = image.getColorModel();
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                Object elements = image.getRaster().getDataElements(x, y, null);
                int abgr = colorModel.getAlpha(elements) << 24 | colorModel.getBlue(elements) << 16 | colorModel.getGreen(elements) << 8 | colorModel.getRed(elements);
                nativeImage.method_4305(x, y, abgr);
            }
        }
        return nativeImage;
    }

    public static BufferedImage withType(BufferedImage image, int type) {
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), type);
        Graphics2D g = newImage.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        image.flush();
        return newImage;
    }

    public static boolean isEquals(BufferedImage image1, BufferedImage image2) {
        if (image1.getWidth() != image2.getWidth() || image1.getHeight() != image2.getHeight()) {
            return false;
        }
        for (int y = 0; y < image1.getHeight(); ++y) {
            for (int x = 0; x < image1.getWidth(); ++x) {
                if (image1.getRGB(x, y) == image2.getRGB(x, y)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasUnusedPixel(BufferedImage skin) {
        for (byte[] rectangle : SkinPart.EMPTY_AREAS) {
            if (!ImageUtils.hasAnyPixel(rectangle[0], rectangle[1], rectangle[2], rectangle[3], skin)) continue;
            return true;
        }
        return false;
    }

    public static void copyUnusedPixels(BufferedImage skin, Graphics2D target) {
        for (byte[] rect : SkinPart.EMPTY_AREAS) {
            target.drawImage(skin, rect[0], rect[1], rect[2], rect[3], rect[0], rect[1], rect[2], rect[3], null);
        }
    }

    public static void removeUnusedPixels(Graphics2D target) {
        target.setBackground(new Color(0, 0, 0, 0));
        for (byte[] rect : SkinPart.EMPTY_AREAS) {
            target.clearRect(rect[0], rect[1], rect[2] - rect[0], rect[3] - rect[1]);
        }
    }

    public static void drawUsedPixels(BufferedImage skin, boolean skinHatLayer, Graphics2D target, boolean targetHatLayer, SkinPart skinPart) {
        int targetIndex = targetHatLayer ? 2 : 0;
        int skinIndex = skinHatLayer ? 2 : 0;
        byte[][] usedAreas = skinPart.usedAreas();
        for (int i = targetIndex; i != targetIndex + 2; ++i) {
            byte[] targetArea = usedAreas[i];
            byte[] skinArea = usedAreas[skinIndex++];
            target.drawImage(skin, targetArea[0], targetArea[1], targetArea[2], targetArea[3], skinArea[0], skinArea[1], skinArea[2], skinArea[3], null);
        }
    }

    public static void clearRect(Graphics2D target, byte[][] rectangle) {
        for (byte[] rect : rectangle) {
            target.clearRect(rect[0], rect[1], rect[2] - rect[0], rect[3] - rect[1]);
        }
    }

    public static boolean isSlimSimpleCheck(BufferedImage skin) {
        return ImageUtils.isSlimSimpleCheck(skin, 1);
    }

    public static boolean isSlimSimpleCheck(BufferedImage skin, int scale) {
        return !ImageUtils.hasPixel(scale, SkinPart.LEFT_ARM.x() + 15, SkinPart.LEFT_ARM.y() + 15, skin);
    }

    public static boolean isSlimFullCheck(BufferedImage skin) {
        int[] formatRectangles = new int[]{SkinPart.LEFT_ARM.x() + 10, SkinPart.LEFT_ARM.y(), SkinPart.LEFT_ARM.x() + 10 + 1, SkinPart.LEFT_ARM.y() + 3, SkinPart.LEFT_ARM.x() + 14, SkinPart.LEFT_ARM.y() + 4, SkinPart.LEFT_ARM.x() + 15, SkinPart.LEFT_ARM.y() + 15, SkinPart.RIGHT_ARM.x() + 10, SkinPart.RIGHT_ARM.y(), SkinPart.RIGHT_ARM.x() + 10 + 1, SkinPart.RIGHT_ARM.y() + 3, SkinPart.RIGHT_ARM.x() + 14, SkinPart.RIGHT_ARM.y() + 4, SkinPart.RIGHT_ARM.x() + 15, SkinPart.RIGHT_ARM.y() + 15};
        for (int i = 0; i != formatRectangles.length; i += 4) {
            if (!ImageUtils.hasAnyPixel(formatRectangles[i], formatRectangles[i + 1], formatRectangles[i + 2], formatRectangles[i + 3], skin)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAnyPixel(int x, int y, int x2, int y2, BufferedImage skin) {
        for (int i = x; i != x2; ++i) {
            for (int j = y; j != y2; ++j) {
                if (!ImageUtils.hasPixel(i, j, skin)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPixel(int scale, int x, int y, BufferedImage skin) {
        return ImageUtils.hasPixel(x * scale, y * scale, skin);
    }

    public static boolean hasPixel(int x, int y, BufferedImage skin) {
        if (x >= skin.getWidth() || y >= skin.getHeight()) {
            return false;
        }
        int alpha = skin.getColorModel().getAlpha(skin.getRaster().getDataElements(x, y, null));
        return alpha != 0;
    }

    public static BufferedImage convertInSteveModel(BufferedImage skin, int scale) {
        BufferedImage modifiedSkin = ImageUtils.convertInSteveModel(skin, SkinPart.LEFT_ARM, scale);
        return ImageUtils.convertInSteveModel(modifiedSkin, SkinPart.RIGHT_ARM, scale);
    }

    private static BufferedImage convertInSteveModel(BufferedImage playerSkin, SkinPart skinPart, int scale) {
        BufferedImage modifiedSkin = ImageUtils.convertInSteveModel(playerSkin, skinPart.x(), skinPart.y(), scale);
        return ImageUtils.convertInSteveModel(modifiedSkin, skinPart.hatX(), skinPart.hatY(), scale);
    }

    private static BufferedImage convertInSteveModel(BufferedImage skin, int x, int y, int scale) {
        x *= scale;
        y *= scale;
        int imageSize = 64 * scale;
        int space = 4 * scale;
        int steveArmWidth = 4 * scale;
        int alexArmWidth = 3 * scale;
        int skinPartSize = 16 * scale;
        BufferedImage bufferedImage = new BufferedImage(imageSize, imageSize, 2);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.drawImage(skin, 0, 0, imageSize, imageSize, 0, 0, imageSize, imageSize, null);
        g2d.setBackground(new Color(0, 0, 0, 0));
        g2d.clearRect(x, y, skinPartSize, skinPartSize);
        g2d.drawImage(skin, x, y + space, x + steveArmWidth, y + skinPartSize, x, y + space, x + steveArmWidth, y + skinPartSize, null);
        g2d.drawImage(skin, x + steveArmWidth, y + space, x + steveArmWidth * 2, y + skinPartSize, x + steveArmWidth, y + space, x + steveArmWidth + alexArmWidth, y + skinPartSize, null);
        g2d.drawImage(skin, x + steveArmWidth * 2, y + space, x + steveArmWidth * 3, y + skinPartSize, x + steveArmWidth + alexArmWidth, y + space, x + steveArmWidth * 2 + alexArmWidth, y + skinPartSize, null);
        g2d.drawImage(skin, x + steveArmWidth * 3, y + space, x + steveArmWidth * 4, y + skinPartSize, x + steveArmWidth * 2 + alexArmWidth, y + space, x + steveArmWidth * 2 + alexArmWidth * 2, y + skinPartSize, null);
        g2d.drawImage(skin, x + space, y, x + steveArmWidth + space, y + space, x + space, y, x + alexArmWidth + space, y + space, null);
        g2d.drawImage(skin, x + space + steveArmWidth, y, x + steveArmWidth * 2 + space, y + space, x + space + alexArmWidth, y, x + alexArmWidth * 2 + space, y + space, null);
        g2d.dispose();
        return bufferedImage;
    }

    public static BufferedImage fastResizeImage(BufferedImage image, int targetWidth, int targetHeight, boolean progressiveBilinear) {
        boolean isTranslucent = image.getTransparency() != 1;
        int type = isTranslucent ? 2 : 1;
        BufferedImage resizedImage = image;
        BufferedImage scratchImage = null;
        Graphics g2d = null;
        int prevWidth = resizedImage.getWidth();
        int prevHeight = resizedImage.getHeight();
        boolean isUpscale = prevWidth < targetWidth || prevHeight < targetHeight;
        do {
            int[] dimensions = ImageUtils.calculateDimensions(prevWidth, prevHeight, targetWidth, targetHeight, progressiveBilinear, isUpscale);
            int width = dimensions[0];
            int height = dimensions[1];
            if (scratchImage == null || isTranslucent) {
                scratchImage = new BufferedImage(width, height, type);
                if (g2d != null) {
                    g2d.dispose();
                }
                g2d = scratchImage.createGraphics();
            }
            ImageUtils.drawResizedImage(g2d, resizedImage, prevWidth, prevHeight, width, height);
            prevWidth = width;
            prevHeight = height;
            resizedImage = scratchImage;
        } while (prevWidth != targetWidth || prevHeight != targetHeight);
        g2d.dispose();
        return ImageUtils.resizeFinalImageIfNeeded(resizedImage, targetWidth, targetHeight, type);
    }

    private static int[] calculateDimensions(int width, int height, int targetWidth, int targetHeight, boolean progressiveBilinear, boolean isUpscale) {
        if (progressiveBilinear) {
            width = isUpscale ? Math.min(width * 2, targetWidth) : Math.max(width / 2, targetWidth);
            height = isUpscale ? Math.min(height * 2, targetHeight) : Math.max(height / 2, targetHeight);
        } else {
            width = targetWidth;
            height = targetHeight;
        }
        return new int[]{width, height};
    }

    private static void drawResizedImage(Graphics2D g2, BufferedImage src, int srcWidth, int srcHeight, int destWidth, int destHeight) {
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(src, 0, 0, destWidth, destHeight, 0, 0, srcWidth, srcHeight, null);
    }

    private static BufferedImage resizeFinalImageIfNeeded(BufferedImage image, int targetWidth, int targetHeight, int type) {
        if (targetWidth != image.getWidth() || targetHeight != image.getHeight()) {
            BufferedImage resizedImage = new BufferedImage(targetWidth, targetHeight, type);
            Graphics2D g2 = resizedImage.createGraphics();
            g2.drawImage((Image)image, 0, 0, null);
            g2.dispose();
            return resizedImage;
        }
        return image;
    }
}

