/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import fzmm.zailer.me.builders.HeadBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.config.FzmmConfig;
import fzmm.zailer.me.utils.skin.GetSkinFromCache;
import io.wispforest.owo.Owo;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_310;
import net.minecraft.class_8685;

public class HeadUtils {
    public static final String MINESKIN_API = "https://api.mineskin.org/";
    private static final String BOUNDARY = UUID.randomUUID().toString();
    private String skinValue = "";
    private String signature = "";
    private String url = "";
    private boolean skinGenerated = false;
    private int httpResponseCode = 0;
    private int delayForNextInMillis = 6000;

    public HeadBuilder getBuilder() {
        return HeadBuilder.builder().skinValue(this.skinValue).signature(this.signature);
    }

    public String getSkinValue() {
        return this.skinValue;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isSkinGenerated() {
        return this.skinGenerated;
    }

    public int getHttpResponseCode() {
        return this.httpResponseCode;
    }

    public int getDelayForNext(TimeUnit unit) {
        return (int)unit.convert(this.delayForNextInMillis, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<HeadUtils> uploadHead(BufferedImage headSkin, String skinName) {
        return CompletableFuture.supplyAsync(() -> {
            block24: {
                HttpURLConnection conn = null;
                try {
                    FzmmConfig.Mineskin config = FzmmClient.CONFIG.mineskin;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)headSkin, "png", baos);
                    byte[] skin = baos.toByteArray();
                    URL url = URI.create("https://api.mineskin.org/generate/upload").toURL();
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setDoOutput(true);
                    conn.setConnectTimeout(8000);
                    conn.setReadTimeout(8000);
                    conn.setRequestProperty("User-Agent", "FZMM/1.0");
                    conn.setRequestMethod("POST");
                    if (!config.apiKey().isEmpty()) {
                        conn.setRequestProperty("Authorization", "Bearer " + config.apiKey());
                    }
                    conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
                    try (DataOutputStream dataOutputStream = new DataOutputStream(conn.getOutputStream());){
                        dataOutputStream.writeBytes("--" + BOUNDARY + "\r\n");
                        dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"visibility\"\r\n");
                        dataOutputStream.writeBytes("Content-Type: text/plain\r\n\r\n");
                        dataOutputStream.writeBytes(config.publicSkins() ? "0" : "1");
                        dataOutputStream.writeBytes("\r\n--" + BOUNDARY + "\r\n");
                        dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"file\"; filename=\"head\"\r\n");
                        dataOutputStream.writeBytes("Content-Type: application/x-www-form-urlencoded\r\n\r\n");
                        dataOutputStream.write(skin);
                        dataOutputStream.writeBytes("\r\n--" + BOUNDARY + "--\r\n");
                    }
                    this.httpResponseCode = conn.getResponseCode();
                    if (this.httpResponseCode / 100 == 2) {
                        try (InputStreamReader streamReader = new InputStreamReader(conn.getInputStream());){
                            int character;
                            StringBuilder stringBuilder = new StringBuilder();
                            while ((character = streamReader.read()) != -1) {
                                stringBuilder.append((char)character);
                            }
                            this.useResponse(stringBuilder.toString());
                            FzmmClient.LOGGER.info("[HeadUtils] '{}' head generated using mineskin", (Object)skinName);
                            break block24;
                        }
                        catch (NullPointerException e) {
                            FzmmClient.LOGGER.error("[HeadUtils] Failed to get head values from mineskin api", (Throwable)e);
                        }
                        break block24;
                    }
                    FzmmClient.LOGGER.error("[HeadUtils] HTTP error {} generating skin in '{}'", (Object)this.httpResponseCode, (Object)skinName);
                }
                catch (IOException e) {
                    FzmmClient.LOGGER.error("[HeadUtils] Head '{}' could not be generated", (Object)skinName, (Object)e);
                    this.skinValue = "";
                    this.skinGenerated = false;
                    if (this.httpResponseCode == 0) {
                        this.httpResponseCode = 400;
                    }
                }
                finally {
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
            }
            if (!this.skinGenerated) {
                this.delayForNextInMillis = 6000;
            }
            return this;
        }, class_156.method_55473());
    }

    private void useResponse(String reply) {
        JsonObject json = (JsonObject)JsonParser.parseString((String)reply);
        JsonObject texture = json.getAsJsonObject("data").getAsJsonObject("texture");
        this.skinValue = texture.get("value").getAsString();
        this.signature = texture.get("signature").getAsString();
        this.url = texture.get("url").getAsString();
        this.skinGenerated = true;
        this.delayForNextInMillis = json.getAsJsonObject("delayInfo").get("millis").getAsInt();
        if (Owo.DEBUG) {
            FzmmClient.LOGGER.info("[DEBUG] [HeadUtils] HTTP Code: {}, Delay: {}, Received response: {}", (Object)this.httpResponseCode, (Object)this.delayForNextInMillis, (Object)reply);
        }
    }

    public static Optional<BufferedImage> getSkin(class_1799 stack) throws IOException {
        class_2487 skullOwnerTag = stack.method_7941("SkullOwner");
        if (skullOwnerTag == null) {
            return Optional.empty();
        }
        GameProfile profile = class_2512.method_10683((class_2487)skullOwnerTag);
        if (profile == null) {
            return Optional.empty();
        }
        return new GetSkinFromCache().getSkin(profile);
    }

    public static Optional<class_8685> getSkinTextures(class_1799 stack) {
        class_310 client = class_310.method_1551();
        assert (client.field_1724 != null);
        class_2487 nbt = stack.method_7948();
        class_2487 skullOwnerTag = nbt.method_10562("SkullOwner");
        GameProfile gameProfile = class_2512.method_10683((class_2487)skullOwnerTag);
        if (gameProfile == null) {
            return Optional.empty();
        }
        return Optional.of(class_310.method_1551().method_1582().method_52862(gameProfile));
    }
}

