/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.utils;

import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.HistoryScreen;
import fzmm.zailer.me.client.gui.components.snack_bar.BaseSnackBarComponent;
import fzmm.zailer.me.client.gui.components.snack_bar.ISnackBarScreen;
import fzmm.zailer.me.client.gui.components.style.FzmmStyles;
import fzmm.zailer.me.client.logic.FzmmHistory;
import fzmm.zailer.me.mixin.combined_inventory_getter.PlayerInventoryAccessor;
import fzmm.zailer.me.utils.ByteCountDataOutput;
import fzmm.zailer.me.utils.SnackBarManager;
import io.wispforest.owo.config.ConfigWrapper;
import io.wispforest.owo.config.ui.ConfigScreen;
import io.wispforest.owo.ui.component.Components;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1661;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5455;
import net.minecraft.class_5481;
import net.minecraft.class_640;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;

public class FzmmUtils {
    public static final SuggestionProvider<FabricClientCommandSource> SUGGESTION_PLAYER = (context, builder) -> {
        class_746 clientPlayer = class_310.method_1551().field_1724;
        String playerInput = builder.getRemainingLowerCase();
        if (clientPlayer != null) {
            List<String> playerNamesList = clientPlayer.field_3944.method_2880().stream().map(class_640::method_2966).map(GameProfile::getName).toList();
            for (String playerName : playerNamesList) {
                if (!playerName.toLowerCase().contains(playerInput)) continue;
                builder.suggest(playerName);
            }
        }
        return CompletableFuture.completedFuture(builder.build());
    };

    public static class_1799 getHandStack(class_1268 hand) {
        class_310 client = class_310.method_1551();
        assert (client.field_1724 != null);
        class_1799 stack = client.field_1724.method_5998(hand);
        return FzmmUtils.processStack(stack);
    }

    public static void giveItem(class_1799 stack) {
        long inventorySize;
        long stackSize;
        SnackBarManager snackBarManager = SnackBarManager.getInstance();
        snackBarManager.remove("give");
        class_310 client = class_310.method_1551();
        assert (client.field_1724 != null);
        if (FzmmClient.CONFIG.general.giveItemSizeLimit() && (stackSize = FzmmUtils.getLengthInBytes(stack)) + (inventorySize = FzmmUtils.getInventorySizeInBytes()) > 8000000L) {
            snackBarManager.add(BaseSnackBarComponent.builder("give").title((class_2561)class_2561.method_43471((String)"fzmm.giveItem.error")).details((class_2561)class_2561.method_43469((String)"fzmm.giveItem.exceedLimit", (Object[])new Object[]{FzmmUtils.getLengthInKB(stackSize + inventorySize), FzmmUtils.getLengthInKB(8000000L)})).backgroundColor(FzmmStyles.ALERT_ERROR_COLOR).keepOnLimit().button(snackBar -> Components.button((class_2561)class_2561.method_43471((String)"fzmm.gui.title.configs.icon"), buttonComponent -> {
                client.method_1507((class_437)ConfigScreen.create((ConfigWrapper)FzmmClient.CONFIG, (class_437)client.field_1755));
                snackBar.close();
            })).highTimer().startTimer().closeButton().expandDetails().build());
            FzmmClient.LOGGER.warn("[FzmmUtils] An attempt was made to give an item with size of {} bytes (with {} bytes already in inventory)", (Object)stackSize, (Object)inventorySize);
            return;
        }
        if (class_1802.field_8575 == stack.method_7909()) {
            FzmmHistory.addGeneratedHeads(stack);
        } else {
            FzmmHistory.addGeneratedItems(stack);
        }
        if (!FzmmUtils.isAllowedToGive()) {
            snackBarManager.add(BaseSnackBarComponent.builder("give").title((class_2561)class_2561.method_43471((String)"fzmm.giveItem.error")).details((class_2561)class_2561.method_43471((String)"fzmm.giveItem.notAllowed")).backgroundColor(FzmmStyles.ALERT_ERROR_COLOR).keepOnLimit().button(snackBar -> Components.button((class_2561)class_2561.method_43471((String)"fzmm.gui.title.history"), buttonComponent -> {
                FzmmUtils.setScreen(new HistoryScreen(client.field_1755));
                snackBar.close();
            })).highTimer().startTimer().closeButton().expandDetails().build());
        } else if (FzmmClient.CONFIG.general.giveClientSide()) {
            client.field_1724.method_5673(class_1304.field_6173, stack);
        } else {
            assert (client.field_1761 != null);
            class_1661 playerInventory = client.field_1724.method_31548();
            playerInventory.method_7374(stack);
            FzmmUtils.updateHand(stack);
        }
    }

    public static class_1799 processStack(class_1799 stack) {
        class_1799 stackCopy = stack.method_7972();
        if (!FzmmClient.CONFIG.general.removeViaVersionTags()) {
            return stackCopy;
        }
        class_2487 customTag = stackCopy.method_7948();
        FzmmUtils.recursiveRemoveTags(customTag, s -> s.startsWith("VV|Protocol"));
        return stackCopy;
    }

    public static void recursiveRemoveTags(class_2487 tags, Predicate<String> keyPredicate) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (String key : tags.method_10541()) {
            if (keyPredicate.test(key)) {
                keysToRemove.add(key);
                continue;
            }
            class_2520 value = tags.method_10580(key);
            if (value instanceof class_2487) {
                class_2487 compound = (class_2487)value;
                FzmmUtils.recursiveRemoveTags(compound, keyPredicate);
                continue;
            }
            if (!(value instanceof class_2499)) continue;
            class_2499 list = (class_2499)value;
            for (class_2520 element : list) {
                if (!(element instanceof class_2487)) continue;
                class_2487 compoundElement = (class_2487)element;
                FzmmUtils.recursiveRemoveTags(compoundElement, keyPredicate);
            }
        }
        for (String key : keysToRemove) {
            tags.method_10551(key);
        }
    }

    private static long getInventorySizeInBytes() {
        class_310 client = class_310.method_1551();
        assert (client.field_1724 != null);
        List<class_2371<class_1799>> combinedInventory = ((PlayerInventoryAccessor)client.field_1724.method_31548()).getCombinedInventory();
        long size = 0L;
        for (class_2371<class_1799> defaultedList : combinedInventory) {
            for (class_1799 itemStack : defaultedList) {
                size += FzmmUtils.getLengthInBytes(itemStack);
            }
        }
        return size;
    }

    public static void updateHand(class_1799 stack) {
        class_310 client = class_310.method_1551();
        assert (client.field_1761 != null);
        assert (client.field_1724 != null);
        class_1661 playerInventory = client.field_1724.method_31548();
        client.field_1761.method_2909(stack, 36 + playerInventory.field_7545);
    }

    public static class_5250 disableItalicConfig(class_2561 text) {
        class_5250 message = text.method_27661();
        class_2583 style = message.method_10866();
        if (FzmmClient.CONFIG.general.disableItalic() && !style.method_10966()) {
            message.method_10862(style.method_10978(Boolean.valueOf(false)));
        }
        return message;
    }

    public static String getLengthInKB(long length) {
        return new DecimalFormat("#,##0.0").format((float)length / 1024.0f);
    }

    public static long getLengthInBytes(class_1799 stack) {
        ByteCountDataOutput byteCountDataOutput = ByteCountDataOutput.getInstance();
        try {
            stack.method_7953(new class_2487()).method_10713((DataOutput)byteCountDataOutput);
        }
        catch (Exception ignored) {
            return 0L;
        }
        long count = byteCountDataOutput.getCount();
        byteCountDataOutput.reset();
        return count;
    }

    public static class_2519 toNbtString(String string, boolean useDisableItalicConfig) {
        class_5250 text = class_2561.method_30163((String)string).method_27661();
        return FzmmUtils.toNbtString((class_2561)text, useDisableItalicConfig);
    }

    public static class_2519 toNbtString(class_2561 text, boolean useDisableItalicConfig) {
        if (useDisableItalicConfig) {
            FzmmUtils.disableItalicConfig(text);
        }
        return class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)text));
    }

    public static String fetchPlayerUuid(String name) throws IOException, JsonIOException {
        try (CloseableHttpClient httpClient = FzmmUtils.getHttpClient();){
            HttpGet httpGet = new HttpGet("https://api.mojang.com/users/profiles/minecraft/" + name);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity resEntity = response.getEntity();
            if (response.getStatusLine().getStatusCode() / 100 != 2 || resEntity == null) {
                String string = "";
                return string;
            }
            InputStream inputStream = resEntity.getContent();
            JsonObject obj = (JsonObject)JsonParser.parseReader((Reader)new InputStreamReader(inputStream));
            String string = obj.get("id").getAsString();
            return string;
        }
    }

    public static class_1792 getItem(String value) {
        return class_7923.field_41178.method_17966(new class_2960(value)).orElse(class_1802.field_20391);
    }

    public static boolean isAllowedToGive() {
        class_310 client = class_310.method_1551();
        if (client.field_1761 == null) {
            return false;
        }
        return client.field_1761.method_2920().method_8386() || FzmmClient.CONFIG.general.giveClientSide();
    }

    public static List<String> splitMessage(String message) {
        int codePoint;
        ArrayList<String> characters = new ArrayList<String>(message.length());
        for (int i = 0; i < message.length(); i += Character.charCount(codePoint)) {
            codePoint = message.codePointAt(i);
            characters.add(new String(Character.toChars(codePoint)));
        }
        return characters;
    }

    public static int getMaxWidth(Collection<class_5348> collection) {
        return FzmmUtils.getMaxWidth(collection, stringVisitable -> stringVisitable);
    }

    public static <T> int getMaxWidth(Collection<T> collection, Function<T, Object> widthGetter) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        int max = 0;
        for (T t : collection) {
            Object text = widthGetter.apply(t);
            int width = text instanceof class_5348 ? textRenderer.method_27525((class_5348)text) : textRenderer.method_30880((class_5481)text);
            max = Math.max(max, width);
        }
        return max;
    }

    public static class_1767[] getDyeColorsInOrder() {
        class_1767[] result = new class_1767[]{class_1767.field_7952, class_1767.field_7967, class_1767.field_7944, class_1767.field_7963, class_1767.field_7957, class_1767.field_7964, class_1767.field_7946, class_1767.field_7947, class_1767.field_7961, class_1767.field_7942, class_1767.field_7955, class_1767.field_7951, class_1767.field_7966, class_1767.field_7945, class_1767.field_7958, class_1767.field_7954};
        return FzmmUtils.addToArray(result, class_1767.values());
    }

    public static class_124[] getFormattingColorsInOrder() {
        class_124[] result = new class_124[]{class_124.field_1068, class_124.field_1080, class_124.field_1063, class_124.field_1074, class_124.field_1079, class_124.field_1061, class_124.field_1065, class_124.field_1054, class_124.field_1060, class_124.field_1077, class_124.field_1062, class_124.field_1075, class_124.field_1078, class_124.field_1058, class_124.field_1064, class_124.field_1076};
        return FzmmUtils.addToArray(result, class_124.values());
    }

    private static <T> T[] addToArray(T[] sortedArray, T[] allArray) {
        int lastIndex = sortedArray.length;
        sortedArray = Arrays.copyOf(sortedArray, allArray.length);
        ArrayList<T> notFound = new ArrayList<T>(Arrays.asList(allArray));
        notFound.removeAll(Arrays.asList(sortedArray));
        for (Object value : notFound) {
            sortedArray[lastIndex++] = value;
        }
        return sortedArray;
    }

    public static class_5455 getRegistryManager() {
        assert (class_310.method_1551().field_1687 != null);
        return class_310.method_1551().field_1687.method_30349();
    }

    public static <T extends class_437> void setScreen(T screen) {
        class_310 client = class_310.method_1551();
        class_437 class_4372 = client.field_1755;
        if (class_4372 instanceof ISnackBarScreen) {
            ISnackBarScreen snackBarScreen = (ISnackBarScreen)class_4372;
            snackBarScreen.setScreen(screen);
        } else {
            client.method_1507(screen);
            SnackBarManager.getInstance().moveToScreen((ISnackBarScreen)screen);
        }
    }

    public static CloseableHttpClient getHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(3000).setSocketTimeout(3000).build();
        return HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false)).disableAutomaticRetries().setDefaultRequestConfig(requestConfig).setUserAgent("FZMM/1.0").build();
    }
}

