/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.compat.symbol_chat;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.style.StyledContainers;
import fzmm.zailer.me.compat.CompatMods;
import fzmm.zailer.me.compat.symbol_chat.symbol.SymbolSelectionPanelComponentAdapter;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.replaceitem.symbolchat.SymbolChat;
import net.replaceitem.symbolchat.gui.SymbolSelectionPanel;
import net.replaceitem.symbolchat.gui.widget.DropDownWidget;
import net.replaceitem.symbolchat.resource.FontProcessor;

public class SymbolChatCompat {
    private static final class_2561 SYMBOL_CHAT_NOT_AVAILABLE_TEXT_TOOLTIP = class_2561.method_43471((String)"fzmm.gui.button.symbolChat.notAvailable.tooltip").method_10862(class_2583.field_24360.method_36139(15867917));
    private static final class_2561 SYMBOL_BUTTON_TEXT = class_2561.method_43471((String)"fzmm.gui.button.symbolChat.symbol");
    private static final class_2561 SYMBOL_BUTTON_TEXT_TOOLTIP = class_2561.method_43471((String)"fzmm.gui.button.symbolChat.symbol.tooltip");
    private static final class_2561 SYMBOL_BUTTON_NOT_AVAILABLE_TOOLTIP = SYMBOL_BUTTON_TEXT_TOOLTIP.method_27661().method_27693("\n\n").method_10852(SYMBOL_CHAT_NOT_AVAILABLE_TEXT_TOOLTIP);
    private static final class_2561 FONT_BUTTON_TEXT = class_2561.method_43471((String)"fzmm.gui.button.symbolChat.font");
    private static final class_2561 FONT_BUTTON_TEXT_TOOLTIP = class_2561.method_43471((String)"fzmm.gui.button.symbolChat.font.tooltip");
    private static final class_2561 FONT_BUTTON_NOT_AVAILABLE_TOOLTIP = FONT_BUTTON_TEXT_TOOLTIP.method_27661().method_27693("\n\n").method_10852(SYMBOL_CHAT_NOT_AVAILABLE_TEXT_TOOLTIP);
    public static final String SYMBOL_SELECTION_PANEL_ID = "symbol-selection-panel";
    public static final String FONT_SELECTION_DROP_DOWN_ID = "font-selection-drop-down";
    private SymbolSelectionPanel symbolSelectionPanel;
    private DropDownWidget<FontProcessor> fontSelectionDropDownParent;
    private class_339 fontSelectionDropDown;
    private class_342 selectedComponent = null;
    private int fontSelectionOriginalWidth;

    public void addSymbolChatComponents(BaseFzmmScreen screen) {
        if (CompatMods.SYMBOL_CHAT_PRESENT) {
            try {
                this.addSymbolSelectionPanelComponent(screen);
                this.addFontSelectionDropDownComponent(screen);
            }
            catch (Error e) {
                FzmmClient.LOGGER.error("[SymbolChatCompat] Failed to add symbol chat components", (Throwable)e);
                CompatMods.SYMBOL_CHAT_PRESENT = false;
            }
        }
    }

    private void addSymbolSelectionPanelComponent(BaseFzmmScreen screen) {
        this.symbolSelectionPanel = new SymbolSelectionPanel(0, 0, SymbolChat.config.getSymbolPanelHeight(), s -> {
            if (this.selectedComponent != null) {
                this.selectedComponent.method_1867(s);
            }
        });
        this.setSelectionPanelVisible(false);
        screen.child(new SymbolSelectionPanelComponentAdapter(this.symbolSelectionPanel, this).positioning(Positioning.relative((int)0, (int)0)).id(SYMBOL_SELECTION_PANEL_ID));
    }

    private void addFontSelectionDropDownComponent(BaseFzmmScreen screen) {
        this.fontSelectionOriginalWidth = 180;
        this.fontSelectionDropDownParent = new DropDownWidget(0, 0, this.fontSelectionOriginalWidth, 15, SymbolChat.fontManager.getFontProcessors(), SymbolChat.selectedFont);
        this.fontSelectionDropDownParent.field_22764 = false;
        this.fontSelectionDropDownParent.expanded = true;
        try {
            Field selectionWidgetField = this.fontSelectionDropDownParent.getClass().getDeclaredField("scrollableGridWidget");
            selectionWidgetField.setAccessible(true);
            this.fontSelectionDropDown = (class_339)selectionWidgetField.get(this.fontSelectionDropDownParent);
            this.setFontSelectionVisible(false);
            screen.child(this.fontSelectionDropDown.positioning(Positioning.relative((int)0, (int)0)).id(FONT_SELECTION_DROP_DOWN_ID).zIndex(100));
        }
        catch (Exception e) {
            FzmmClient.LOGGER.error("[SymbolChatCompat] Failed to add font selection drop down component", (Throwable)e);
            CompatMods.SYMBOL_CHAT_PRESENT = false;
        }
    }

    public boolean isSelectionPanelVisible() {
        if (!CompatMods.SYMBOL_CHAT_PRESENT) {
            return false;
        }
        return this.symbolSelectionPanel.field_22764;
    }

    public void setSelectionPanelVisible(boolean visible) {
        if (!CompatMods.SYMBOL_CHAT_PRESENT) {
            return;
        }
        this.symbolSelectionPanel.field_22764 = visible;
    }

    public Component getOpenSymbolChatPanelButton(class_342 selectedComponent) {
        ButtonComponent result = Components.button((class_2561)SYMBOL_BUTTON_TEXT, button -> {
            if (this.fontSelectionDropDown.field_22764) {
                this.setFontSelectionVisible(false);
            }
            if (this.selectedComponent == null || !this.isSelectionPanelVisible()) {
                this.setSelectionPanelVisible(!this.isSelectionPanelVisible());
                this.selectedComponent = selectedComponent;
            } else if (this.selectedComponent != selectedComponent) {
                this.selectedComponent = selectedComponent;
            } else {
                this.setSelectionPanelVisible(false);
                this.selectedComponent = null;
            }
        });
        result.sizing(Sizing.fixed((int)20));
        result.field_22763 = CompatMods.SYMBOL_CHAT_PRESENT;
        if (CompatMods.SYMBOL_CHAT_PRESENT) {
            result.tooltip(SYMBOL_BUTTON_TEXT_TOOLTIP);
        } else {
            result = StyledContainers.horizontalFlow(Sizing.content(), Sizing.content()).child((Component)result).tooltip(SYMBOL_BUTTON_NOT_AVAILABLE_TOOLTIP);
        }
        return result;
    }

    public Component getOpenFontSelectionDropDownButton(class_342 selectedComponent) {
        ButtonComponent result = Components.button((class_2561)FONT_BUTTON_TEXT, button -> {
            if (this.isSelectionPanelVisible()) {
                this.setSelectionPanelVisible(false);
            }
            if (this.selectedComponent == null || !this.fontSelectionDropDown.field_22764) {
                this.setFontSelectionVisible(true);
                this.selectedComponent = selectedComponent;
            } else if (this.selectedComponent != selectedComponent) {
                this.selectedComponent = selectedComponent;
            } else {
                this.setFontSelectionVisible(false);
                this.selectedComponent = null;
            }
        });
        result.sizing(Sizing.fixed((int)20));
        result.field_22763 = CompatMods.SYMBOL_CHAT_PRESENT;
        if (CompatMods.SYMBOL_CHAT_PRESENT) {
            result.tooltip(FONT_BUTTON_TEXT_TOOLTIP);
        } else {
            result = StyledContainers.horizontalFlow(Sizing.content(), Sizing.content()).child((Component)result).tooltip(FONT_BUTTON_NOT_AVAILABLE_TOOLTIP);
        }
        return result;
    }

    public boolean isFontSelectionVisible() {
        if (!CompatMods.SYMBOL_CHAT_PRESENT) {
            return false;
        }
        try {
            return this.fontSelectionDropDown.field_22764;
        }
        catch (Exception e) {
            FzmmClient.LOGGER.error("[SymbolChatCompat] Failed to get visible field", (Throwable)e);
            CompatMods.SYMBOL_CHAT_PRESENT = false;
            return false;
        }
    }

    public void setFontSelectionVisible(boolean visible) {
        if (!CompatMods.SYMBOL_CHAT_PRESENT) {
            return;
        }
        this.fontSelectionDropDown.field_22764 = visible;
        this.fontSelectionDropDown.horizontalSizing(Sizing.fixed((int)(this.fontSelectionDropDown.field_22764 ? this.fontSelectionOriginalWidth : 0)));
    }

    public void processFont(class_342 widget, String text, Consumer<String> writeConsumer) {
        if (!CompatMods.SYMBOL_CHAT_PRESENT) {
            writeConsumer.accept(text);
            return;
        }
        try {
            List fontProcessors = SymbolChat.fontManager.getFontProcessors();
            FontProcessor selectedFontProcessor = (FontProcessor)fontProcessors.get(class_3532.method_15340((int)this.fontSelectionDropDownParent.selected, (int)0, (int)(fontProcessors.size() - 1)));
            text = selectedFontProcessor.convertString(text);
            writeConsumer.accept(text);
            if (selectedFontProcessor.isReverseDirection()) {
                int pos = widget.method_1881() - text.length();
                widget.method_1875(pos);
                widget.method_1884(pos);
            }
        }
        catch (Exception e) {
            FzmmClient.LOGGER.error("[SymbolChatCompat] Failed to process font", (Throwable)e);
            CompatMods.SYMBOL_CHAT_PRESENT = false;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (CompatMods.SYMBOL_CHAT_PRESENT) {
            return this.symbolSelectionPanel.method_25404(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean charTyped(char chr, int modifiers) {
        if (CompatMods.SYMBOL_CHAT_PRESENT) {
            return this.symbolSelectionPanel.method_25400(chr, modifiers);
        }
        return false;
    }
}

