/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.imagetext;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.imagetext.algorithms.IImagetextAlgorithm;
import fzmm.zailer.me.client.logic.imagetext.ImagetextData;
import fzmm.zailer.me.utils.FzmmUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class ImagetextLogic {
    private List<class_2561> imagetext = new ArrayList<class_2561>();
    private int width = 0;
    private int height = 0;
    private int lineWidth = 0;

    public void generateImagetext(IImagetextAlgorithm algorithm, ImagetextData data) {
        this.generateImagetext(algorithm, data, Integer.MAX_VALUE);
    }

    public void generateImagetext(IImagetextAlgorithm algorithm, ImagetextData data, int lineSplitInterval) {
        this.width = data.width();
        this.height = data.height();
        List<class_5250> rawLinesList = algorithm.get(this, data, lineSplitInterval);
        List<class_2561> linesList = rawLinesList.stream().map(mutableText -> FzmmUtils.disableItalicConfig((class_2561)mutableText)).toList();
        class_5250 firstLine = linesList.isEmpty() ? class_2561.method_43473() : linesList.get(0);
        this.lineWidth = class_310.method_1551().field_1772.method_27525((class_5348)firstLine);
        this.imagetext = new ArrayList<class_2561>(linesList);
    }

    public static int getResizedAspectRatio(int value, int changeValue, int referenceValue) {
        return (int)((double)changeValue / (double)value * (double)referenceValue);
    }

    public void addResolution() {
        String message = class_2561.method_43469((String)"fzmm.item.imagetext.resolution", (Object[])new Object[]{this.width, this.height}).getString();
        int color = FzmmClient.CONFIG.colors.imagetextMessages().rgb();
        class_5250 text = class_2561.method_43471((String)message).method_10862(class_2583.field_24360.method_36139(color));
        this.imagetext.add((class_2561)FzmmUtils.disableItalicConfig((class_2561)text));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public List<class_2561> getWrappedText() {
        return this.imagetext;
    }

    public class_2561 getText() {
        class_5250 result = class_2561.method_43473();
        List<class_2561> wrappedText = this.getWrappedText();
        int size = wrappedText.size();
        for (int i = 0; i != size; ++i) {
            result.method_10852(wrappedText.get(i));
            if (i == size - 1) continue;
            result.method_27693("\n");
        }
        return result;
    }

    public boolean isEmpty() {
        return this.imagetext.isEmpty();
    }

    public int getLineWidth() {
        return this.lineWidth;
    }
}

