/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.imagetext;

import fzmm.zailer.me.client.logic.imagetext.ImagetextLineComponent;
import fzmm.zailer.me.utils.FzmmUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class ImagetextLine {
    public static final String DEFAULT_TEXT = "\u2588";
    private static final class_2583 WITHOUT_ITALIC = class_2583.field_24360.method_10978(Boolean.valueOf(false));
    private final List<ImagetextLineComponent> line = new ArrayList<ImagetextLineComponent>();
    private final String[] charactersToUse;
    private final boolean isDefaultText;
    private final double percentageOfSimilarityToCompress;
    private final int splitLineEvery;
    private int lineLength;
    @Nullable
    private List<class_5250> generatedLine;

    public ImagetextLine(String charactersToUse, double percentageOfSimilarityToCompress, int splitLineEvery) {
        this.charactersToUse = FzmmUtils.splitMessage(charactersToUse).toArray(new String[0]);
        this.isDefaultText = charactersToUse.equals(DEFAULT_TEXT);
        this.percentageOfSimilarityToCompress = percentageOfSimilarityToCompress;
        this.splitLineEvery = splitLineEvery;
        this.lineLength = 0;
        this.generatedLine = null;
    }

    public ImagetextLine add(int color) {
        ImagetextLineComponent lastComponent;
        int size = this.line.size();
        ImagetextLineComponent imagetextLineComponent = lastComponent = size > 0 ? this.line.get(size - 1) : null;
        if (this.shouldSplitLine(this.lineLength) || lastComponent == null || !lastComponent.tryAdd(color, this.percentageOfSimilarityToCompress)) {
            this.line.add(new ImagetextLineComponent(color));
        }
        ++this.lineLength;
        return this;
    }

    public void generateLine() {
        ArrayList<class_5250> lineList = new ArrayList<class_5250>();
        class_5250 line = class_2561.method_43473().method_10862(WITHOUT_ITALIC);
        int lineIndex = 0;
        int lineComponentSize = this.line.size();
        for (int i = 0; i != lineComponentSize; ++i) {
            ImagetextLineComponent lineComponent = this.line.get(i);
            short repetitions = lineComponent.getRepetitions();
            class_2561 lineComponentText = lineComponent.getText(this.charactersToUse, lineIndex, this.isDefaultText);
            lineIndex = (short)(lineIndex + repetitions);
            line.method_10852(lineComponentText);
            if (this.shouldSplitLine(lineIndex)) {
                lineList.add(line);
                line = class_2561.method_43473().method_10862(WITHOUT_ITALIC);
                continue;
            }
            if (lineComponentSize - 1 != i) continue;
            lineList.add(line);
        }
        this.generatedLine = lineList;
    }

    public List<class_5250> getLineComponents() {
        if (this.generatedLine == null) {
            this.generateLine();
        }
        return this.generatedLine;
    }

    private boolean shouldSplitLine(int index) {
        return index != 0 && index % this.splitLineEvery == 0;
    }
}

