/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.head_generator.model.steps;

import com.google.gson.JsonObject;
import fzmm.zailer.me.client.logic.head_generator.HeadResourcesLoader;
import fzmm.zailer.me.client.logic.head_generator.model.ModelData;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.IParameterEntry;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.OffsetParameter;
import fzmm.zailer.me.client.logic.head_generator.model.steps.IModelStep;

public class ModelToggleOffsetStep
implements IModelStep {
    private final String offsetId;
    private final boolean enabled;

    public ModelToggleOffsetStep(String offsetId, boolean enabled) {
        this.offsetId = offsetId;
        this.enabled = enabled;
    }

    @Override
    public void apply(ModelData data) {
        for (IParameterEntry<OffsetParameter> offset : data.offsets().parameterList()) {
            if (!offset.id().equals(this.offsetId)) continue;
            offset.value().ifPresent(offsetParameter -> offsetParameter.setEnabled(this.enabled));
            return;
        }
    }

    public static ModelToggleOffsetStep parse(JsonObject jsonObject) {
        String offsetId = HeadResourcesLoader.get(jsonObject, "offset_id").getAsString();
        boolean enabled = HeadResourcesLoader.get(jsonObject, "enabled").getAsBoolean();
        return new ModelToggleOffsetStep(offsetId, enabled);
    }
}

