/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.text_format.tabs;

import fzmm.zailer.me.client.gui.components.SliderWidget;
import fzmm.zailer.me.client.gui.components.row.SliderRow;
import fzmm.zailer.me.client.gui.text_format.TextFormatScreen;
import fzmm.zailer.me.client.gui.text_format.components.ColorListContainer;
import fzmm.zailer.me.client.gui.text_format.tabs.ITextFormatTab;
import fzmm.zailer.me.client.gui.utils.memento.IMementoObject;
import fzmm.zailer.me.client.logic.TextFormatLogic;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;

public class TextFormatInterleavedColorsTab
implements ITextFormatTab {
    private static final String COLOR_LIST_ID = "interleavedColorList";
    private static final String DISTANCE_ID = "interleavedDistance";
    private ColorListContainer colorListContainer;
    private SliderWidget distanceField;
    private Consumer<Object> callback;

    @Override
    public String getId() {
        return "interleaved_colors";
    }

    @Override
    public class_2561 getText(TextFormatLogic logic) {
        if (!this.colorListContainer.isValid()) {
            return TextFormatScreen.EMPTY_COLOR_TEXT;
        }
        List<Color> colorList = this.colorListContainer.getColors();
        int distance = (Integer)this.distanceField.parsedValue();
        return logic.getInterleaved(colorList, distance);
    }

    @Override
    public void setupComponents(FlowLayout rootComponent) {
        this.distanceField = SliderRow.setup(rootComponent, DISTANCE_ID, 1.0, 1.0, 25.0, Integer.class, 0, 1.0, this.callback::accept);
        this.colorListContainer = (ColorListContainer)rootComponent.childById(ColorListContainer.class, COLOR_LIST_ID);
        assert (this.colorListContainer != null);
        this.colorListContainer.setCallback(this.callback::accept);
    }

    @Override
    public void setRandomValues() {
        this.colorListContainer.setRandomColors();
    }

    @Override
    public void componentsCallback(Consumer<Object> callback) {
        this.callback = callback;
    }

    @Override
    public boolean hasStyles() {
        return true;
    }

    @Override
    public IMementoObject createMemento() {
        return new InterleavedColorsMementoTab(this.colorListContainer.getColors(), (Integer)this.distanceField.parsedValue());
    }

    @Override
    public void restoreMemento(IMementoObject mementoTab) {
        InterleavedColorsMementoTab memento = (InterleavedColorsMementoTab)mementoTab;
        this.colorListContainer.setColors(memento.colors);
        this.distanceField.setFromDiscreteValue(memento.distance);
    }

    private record InterleavedColorsMementoTab(List<Color> colors, int distance) implements IMementoObject
    {
    }
}

