/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.text_format.components;

import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.row.AbstractRow;
import fzmm.zailer.me.client.gui.components.row.ColorRow;
import fzmm.zailer.me.client.gui.components.style.StyledComponents;
import fzmm.zailer.me.client.gui.components.style.StyledContainers;
import fzmm.zailer.me.client.gui.components.style.container.StyledFlowLayout;
import fzmm.zailer.me.client.gui.text_format.components.ColorListEntry;
import fzmm.zailer.me.utils.list.ListUtils;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_5819;
import org.w3c.dom.Element;

public class ColorListContainer
extends FlowLayout {
    public static final int MINIMUM_SIZE = 2;
    public static final class_2561 ADD_COLOR_TEXT = class_2561.method_43471((String)"fzmm.gui.button.colorList.add");
    public static final String COLOR_AMOUNT_TRANSLATION_KEY = "fzmm.gui.button.colorList.amount";
    private final FlowLayout colorsLayout;
    private final LabelComponent colorAmountLabel;
    private final class_5819 random = class_5819.method_43047();
    private Consumer<String> callback = s -> {};

    public ColorListContainer(String id, String tooltipId, String baseTranslationKey) {
        super(Sizing.fill((int)100), Sizing.content(), FlowLayout.Algorithm.VERTICAL);
        this.id(id);
        this.gap(8);
        StyledFlowLayout topLayout = StyledContainers.horizontalFlow(Sizing.fill((int)100), Sizing.fixed((int)26));
        topLayout.alignment(HorizontalAlignment.LEFT, VerticalAlignment.CENTER);
        Component labelComponent = AbstractRow.getLabel(id, tooltipId, BaseFzmmScreen.getOptionBaseTranslationKey(baseTranslationKey), true);
        this.colorsLayout = StyledContainers.verticalFlow(Sizing.fill((int)100), Sizing.content());
        this.colorAmountLabel = StyledComponents.label((class_2561)class_2561.method_43469((String)COLOR_AMOUNT_TRANSLATION_KEY, (Object[])new Object[]{this.colorsLayout.children().size()}));
        ButtonComponent addButton = Components.button((class_2561)ADD_COLOR_TEXT, buttonComponent -> this.addEntry());
        topLayout.child(labelComponent);
        topLayout.child((Component)addButton);
        topLayout.child((Component)this.colorAmountLabel);
        topLayout.gap(8);
        this.child((Component)topLayout);
        this.child((Component)this.colorsLayout);
        this.addEntry();
        this.addEntry();
    }

    public void addEntry() {
        int id = this.colorsLayout.children().size();
        ColorListEntry entry = new ColorListEntry(this, id);
        ColorRow.setup(entry, String.valueOf(id), this.getRandomColor(), false, 0, this.callback);
        this.colorsLayout.child((Component)entry);
        this.updateDisplay();
        this.callback.accept("");
    }

    public void setCallback(Consumer<String> callback) {
        this.callback = callback;
        for (int i = 0; i != this.colorsLayout.children().size(); ++i) {
            ConfigTextBox colorField = (ConfigTextBox)this.childById(ConfigTextBox.class, ColorRow.getColorFieldId(String.valueOf(i)));
            if (colorField == null) continue;
            colorField.onChanged().subscribe(callback::accept);
        }
    }

    public boolean isValid() {
        for (int i = 0; i != this.colorsLayout.children().size(); ++i) {
            ConfigTextBox colorField = (ConfigTextBox)this.childById(ConfigTextBox.class, ColorRow.getColorFieldId(String.valueOf(i)));
            if (colorField == null || colorField.isValid()) continue;
            return false;
        }
        return true;
    }

    public Color getRandomColor() {
        return Color.ofRgb((int)this.random.method_43048(0xFFFFFF));
    }

    public void setRandomColors() {
        for (Component component : this.colorsLayout.children()) {
            if (!(component instanceof ColorListEntry)) continue;
            ColorListEntry colorEntry = (ColorListEntry)component;
            colorEntry.setValue(this.getRandomColor());
        }
    }

    public List<Color> getColors() {
        ArrayList<Color> colorList = new ArrayList<Color>();
        for (Component component : this.colorsLayout.children()) {
            if (!(component instanceof ColorListEntry)) continue;
            ColorListEntry colorEntry = (ColorListEntry)component;
            colorList.add(colorEntry.getValue());
        }
        return colorList;
    }

    public static ColorListContainer parse(Element element) {
        String id = AbstractRow.getId(element);
        String tooltipId = AbstractRow.getTooltipId(element, id);
        return new ColorListContainer(id, tooltipId, BaseFzmmScreen.getBaseTranslationKey(element));
    }

    public void removeColorEntry(ColorListEntry entry) {
        if (this.colorsLayout.children().size() > 2) {
            this.colorsLayout.removeChild((Component)entry);
        }
        this.updateDisplay();
        this.callback.accept("");
    }

    public void upEntry(ColorListEntry entry) {
        ArrayList<ColorListEntry> list = new ArrayList<ColorListEntry>();
        for (Component component : this.colorsLayout.children()) {
            if (!(component instanceof ColorListEntry)) continue;
            ColorListEntry colorEntry = (ColorListEntry)component;
            list.add(colorEntry);
        }
        ListUtils.upEntry(list, entry, () -> this.callback.accept(""));
    }

    public void downEntry(ColorListEntry entry) {
        ArrayList<ColorListEntry> list = new ArrayList<ColorListEntry>();
        for (Component component : this.colorsLayout.children()) {
            if (!(component instanceof ColorListEntry)) continue;
            ColorListEntry colorEntry = (ColorListEntry)component;
            list.add(colorEntry);
        }
        ListUtils.downEntry(list, entry, () -> this.callback.accept(""));
    }

    public void updateDisplay() {
        this.updateMoveButtons();
        this.updateRemoveButton();
        this.colorAmountLabel.text((class_2561)class_2561.method_43469((String)COLOR_AMOUNT_TRANSLATION_KEY, (Object[])new Object[]{this.colorsLayout.children().size()}));
    }

    public void updateRemoveButton() {
        boolean active = this.colorsLayout.children().size() > 2;
        for (Component component : this.colorsLayout.children()) {
            if (!(component instanceof ColorListEntry)) continue;
            ColorListEntry colorEntry = (ColorListEntry)component;
            colorEntry.setRemoveButtonActive(active);
        }
    }

    public void updateMoveButtons() {
        int size = this.colorsLayout.children().size();
        for (int i = 0; i != size; ++i) {
            Object e = this.colorsLayout.children().get(i);
            if (!(e instanceof ColorListEntry)) continue;
            ColorListEntry entry = (ColorListEntry)e;
            if (i == 0) {
                entry.setMoveUpButtonActive(false);
                entry.setMoveDownButtonActive(true);
                continue;
            }
            if (i == size - 1) {
                entry.setMoveUpButtonActive(true);
                entry.setMoveDownButtonActive(false);
                continue;
            }
            entry.setMoveUpButtonActive(true);
            entry.setMoveDownButtonActive(true);
        }
    }

    public void setColors(List<Color> colors) {
        List colorLayoutChildren = this.colorsLayout.children();
        while (colors.size() > colorLayoutChildren.size()) {
            this.addEntry();
        }
        for (int i = 0; i != colors.size(); ++i) {
            Object e = colorLayoutChildren.get(i);
            if (!(e instanceof ColorListEntry)) continue;
            ColorListEntry colorEntry = (ColorListEntry)e;
            colorEntry.setValue(colors.get(i));
        }
    }
}

