/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.imagetext.tabs;

import fzmm.zailer.me.builders.SpawnEggBuilder;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.ContextMenuButton;
import fzmm.zailer.me.client.gui.components.SliderWidget;
import fzmm.zailer.me.client.gui.components.row.ColorRow;
import fzmm.zailer.me.client.gui.components.row.SliderRow;
import fzmm.zailer.me.client.gui.imagetext.algorithms.IImagetextAlgorithm;
import fzmm.zailer.me.client.gui.imagetext.tabs.IImagetextTab;
import fzmm.zailer.me.client.gui.utils.InvisibleEntityWarning;
import fzmm.zailer.me.client.gui.utils.memento.IMementoObject;
import fzmm.zailer.me.client.logic.imagetext.ImagetextData;
import fzmm.zailer.me.client.logic.imagetext.ImagetextLogic;
import fzmm.zailer.me.utils.FzmmUtils;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.ui.component.SmallCheckboxComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_8113;

public class ImagetextTextDisplayTab
implements IImagetextTab {
    private static final String TEXT_OPACITY_ID = "textDisplayTextOpacity";
    private static final String BACKGROUND_COLOR_ID = "textDisplayBackgroundColor";
    private static final String TEXT_SHADOW_ID = "textDisplayTextShadow";
    private static final String TEXT_SEE_THROUGH_ID = "textDisplayTextSeeThrough";
    private static final String TEXT_ALIGNMENT_ID = "textDisplayTextAlignment";
    private static final String BILLBOARD_ID = "textDisplayBillboard";
    private static final String ROTATION_ID = "textDisplayRotation";
    private static final String TEXT_DISPLAY_TAG = "ImagetextTextDisplay";
    private SliderWidget textOpacity;
    private ConfigTextBox backgroundColor;
    private SmallCheckboxComponent textShadow;
    private SmallCheckboxComponent textSeeThrough;
    private ContextMenuButton textAlignmentButton;
    private class_8113.class_8123.class_8124 textAlignment;
    private ContextMenuButton billboardButton;
    private class_8113.class_8114 billboard;
    private SliderWidget rotation;

    @Override
    public void generate(IImagetextAlgorithm algorithm, ImagetextLogic logic, ImagetextData data, boolean isExecute) {
        logic.generateImagetext(algorithm, data);
    }

    @Override
    public void execute(ImagetextLogic logic) {
        class_2487 textDisplayNbt = new class_2487();
        textDisplayNbt.method_10582("text", class_2561.class_2562.method_10867((class_2561)logic.getText()));
        textDisplayNbt.method_10569("line_width", logic.getLineWidth());
        textDisplayNbt.method_10569("text_opacity", (int)this.textOpacity.discreteValue());
        textDisplayNbt.method_10569("background", ((Color)this.backgroundColor.parsedValue()).argb());
        textDisplayNbt.method_10556("shadow", this.textShadow.checked());
        textDisplayNbt.method_10556("see_through", this.textSeeThrough.checked());
        textDisplayNbt.method_10582("alignment", this.textAlignment.method_15434());
        textDisplayNbt.method_10582("billboard", this.billboard.method_15434());
        class_2499 rotationList = new class_2499();
        rotationList.add((Object)class_2494.method_23244((float)((float)this.rotation.discreteValue())));
        rotationList.add((Object)class_2494.method_23244((float)0.0f));
        textDisplayNbt.method_10566("Rotation", (class_2520)rotationList);
        class_2499 tagList = new class_2499();
        tagList.add((Object)class_2519.method_23256((String)TEXT_DISPLAY_TAG));
        textDisplayNbt.method_10566("Tags", (class_2520)tagList);
        class_1799 spawnEgg = SpawnEggBuilder.builder().entityType(class_1299.field_42457).entityTag(textDisplayNbt).get();
        FzmmUtils.giveItem(spawnEgg);
        InvisibleEntityWarning.add(false, false, (class_2561)class_2561.method_43471((String)"fzmm.snack_bar.entityDifficultToRemove.entity.textDisplay"), TEXT_DISPLAY_TAG);
    }

    @Override
    public void setupComponents(FlowLayout rootComponent) {
        assert (class_310.method_1551().field_1724 != null);
        this.textOpacity = SliderRow.setup(rootComponent, TEXT_OPACITY_ID, 255.0, 0.0, 255.0, Integer.class, 0, 10.0, null);
        this.backgroundColor = ColorRow.setup(rootComponent, BACKGROUND_COLOR_ID, Color.ofArgb((int)0x40000000), true, 0, null);
        this.textShadow = (SmallCheckboxComponent)rootComponent.childById(SmallCheckboxComponent.class, "textDisplayTextShadow-checkbox");
        BaseFzmmScreen.checkNull((Component)this.textShadow, "small-checkbox", "textDisplayTextShadow-checkbox");
        this.textShadow.checked(false);
        this.textSeeThrough = (SmallCheckboxComponent)rootComponent.childById(SmallCheckboxComponent.class, "textDisplayTextSeeThrough-checkbox");
        BaseFzmmScreen.checkNull((Component)this.textSeeThrough, "small-checkbox", "textDisplayTextSeeThrough-checkbox");
        this.textSeeThrough.checked(false);
        this.textAlignmentButton = (ContextMenuButton)rootComponent.childById(ContextMenuButton.class, TEXT_ALIGNMENT_ID);
        BaseFzmmScreen.checkNull((Component)this.textAlignmentButton, "context-menu-button", TEXT_ALIGNMENT_ID);
        this.textAlignmentButton.setContextMenuOptions(dropdownComponent -> {
            for (class_8113.class_8123.class_8124 option : class_8113.class_8123.class_8124.values()) {
                dropdownComponent.button(this.getTextAlignmentMessage(option), dropdownButton -> {
                    this.updateTextAlignment(option);
                    dropdownButton.remove();
                });
            }
        });
        this.updateTextAlignment(class_8113.class_8123.class_8124.field_42451);
        this.billboardButton = (ContextMenuButton)rootComponent.childById(ContextMenuButton.class, BILLBOARD_ID);
        BaseFzmmScreen.checkNull((Component)this.billboardButton, "context-menu-button", BILLBOARD_ID);
        this.billboardButton.setContextMenuOptions(dropdownComponent -> {
            for (class_8113.class_8114 option : class_8113.class_8114.values()) {
                dropdownComponent.button(this.getBillboardMessage(option), dropdownButton -> {
                    this.updateBillboard(option);
                    dropdownButton.remove();
                });
            }
        });
        this.updateBillboard(class_8113.class_8114.field_42406);
        this.rotation = SliderRow.setup(rootComponent, ROTATION_ID, class_3532.method_15393((float)class_310.method_1551().field_1724.method_36454()), -180.0, 180.0, Float.class, 1, 30.0, null);
    }

    private void updateTextAlignment(class_8113.class_8123.class_8124 value) {
        this.textAlignment = value;
        this.textAlignmentButton.method_25355(this.getTextAlignmentMessage(this.textAlignment));
    }

    public class_2561 getTextAlignmentMessage(class_8113.class_8123.class_8124 value) {
        return class_2561.method_43471((String)("fzmm.gui.option.text_alignment." + value.method_15434()));
    }

    public void updateBillboard(class_8113.class_8114 value) {
        this.billboard = value;
        this.billboardButton.method_25355(this.getBillboardMessage(this.billboard));
    }

    public class_2561 getBillboardMessage(class_8113.class_8114 value) {
        return class_2561.method_43471((String)("fzmm.gui.option.billboard." + value.method_15434()));
    }

    @Override
    public String getId() {
        return "textDisplay";
    }

    @Override
    public IMementoObject createMemento() {
        return new TextDisplayMementoTab((int)this.textOpacity.discreteValue(), this.backgroundColor.method_1882(), this.textShadow.checked(), this.textSeeThrough.checked(), this.textAlignment, this.billboard);
    }

    @Override
    public void restoreMemento(IMementoObject mementoTab) {
        TextDisplayMementoTab memento = (TextDisplayMementoTab)mementoTab;
        this.textOpacity.setFromDiscreteValue(memento.textOpacity);
        this.backgroundColor.text(memento.backgroundColor);
        this.textShadow.checked(memento.textShadow);
        this.textSeeThrough.checked(memento.textSeeThrough);
        this.updateTextAlignment(memento.textAlignment);
        this.updateBillboard(memento.billboard);
    }

    private record TextDisplayMementoTab(int textOpacity, String backgroundColor, boolean textShadow, boolean textSeeThrough, class_8113.class_8123.class_8124 textAlignment, class_8113.class_8114 billboard) implements IMementoObject
    {
    }
}

