/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.imagetext.tabs;

import fzmm.zailer.me.builders.DisplayBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.ContextMenuButton;
import fzmm.zailer.me.client.gui.imagetext.algorithms.IImagetextAlgorithm;
import fzmm.zailer.me.client.gui.imagetext.tabs.IImagetextTab;
import fzmm.zailer.me.client.gui.options.LoreOption;
import fzmm.zailer.me.client.gui.utils.memento.IMementoObject;
import fzmm.zailer.me.client.logic.imagetext.ImagetextData;
import fzmm.zailer.me.client.logic.imagetext.ImagetextLogic;
import fzmm.zailer.me.utils.FzmmUtils;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class ImagetextLoreTab
implements IImagetextTab {
    private static final String LORE_MODE_ID = "loreMode";
    private ContextMenuButton loreModeButton;
    private LoreOption loreMode;

    @Override
    public void generate(IImagetextAlgorithm algorithm, ImagetextLogic logic, ImagetextData data, boolean isExecute) {
        logic.generateImagetext(algorithm, data);
    }

    @Override
    public void execute(ImagetextLogic logic) {
        class_1799 stack = this.getStack(this.loreMode);
        List<class_2561> imagetext = logic.getWrappedText();
        DisplayBuilder display = DisplayBuilder.of(stack);
        display.addLore(imagetext).get();
        FzmmUtils.giveItem(display.get());
    }

    @Override
    public String getId() {
        return "lore";
    }

    @Override
    public void setupComponents(FlowLayout rootComponent) {
        this.loreModeButton = (ContextMenuButton)rootComponent.childById(ContextMenuButton.class, LORE_MODE_ID);
        BaseFzmmScreen.checkNull((Component)this.loreModeButton, "context-menu-button", LORE_MODE_ID);
        this.loreModeButton.setContextMenuOptions(dropdownComponent -> {
            for (LoreOption option : LoreOption.values()) {
                dropdownComponent.button((class_2561)class_2561.method_43471((String)option.getTranslationKey()), dropdownButton -> {
                    this.updateLoreMode(option);
                    dropdownButton.remove();
                });
            }
        });
        this.updateLoreMode(LoreOption.ADD);
    }

    private void updateLoreMode(LoreOption mode) {
        this.loreMode = mode;
        this.loreModeButton.method_25355((class_2561)class_2561.method_43471((String)this.loreMode.getTranslationKey()));
    }

    private class_1799 getStack(LoreOption option) {
        assert (class_310.method_1551().field_1724 != null);
        class_1799 stack = FzmmUtils.getHandStack(class_1268.field_5808);
        if (stack.method_7960()) {
            stack = FzmmUtils.getItem(FzmmClient.CONFIG.imagetext.defaultItem()).method_7854();
        }
        if (option == LoreOption.REPLACE) {
            stack.method_7911("display").method_10551("Lore");
        }
        return stack;
    }

    @Override
    public IMementoObject createMemento() {
        return new LoreMementoTab(this.loreMode);
    }

    @Override
    public void restoreMemento(IMementoObject mementoTab) {
        LoreMementoTab memento = (LoreMementoTab)mementoTab;
        this.updateLoreMode(memento.mode);
    }

    private record LoreMementoTab(LoreOption mode) implements IMementoObject
    {
    }
}

