/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.imagetext.tabs;

import fzmm.zailer.me.builders.BookBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.ContextMenuButton;
import fzmm.zailer.me.client.gui.components.row.TextBoxRow;
import fzmm.zailer.me.client.gui.components.snack_bar.BaseSnackBarComponent;
import fzmm.zailer.me.client.gui.components.snack_bar.ISnackBarComponent;
import fzmm.zailer.me.client.gui.components.style.FzmmStyles;
import fzmm.zailer.me.client.gui.imagetext.algorithms.IImagetextAlgorithm;
import fzmm.zailer.me.client.gui.imagetext.tabs.IImagetextTab;
import fzmm.zailer.me.client.gui.options.BookOption;
import fzmm.zailer.me.client.gui.utils.memento.IMementoObject;
import fzmm.zailer.me.client.logic.imagetext.ImagetextData;
import fzmm.zailer.me.client.logic.imagetext.ImagetextLogic;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.SnackBarManager;
import io.wispforest.owo.ui.component.TextAreaComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;

public class ImagetextBookTooltipTab
implements IImagetextTab {
    private static final String BOOK_TOOLTIP_MODE_ID = "bookTooltipMode";
    private static final String BOOK_TOOLTIP_AUTHOR_ID = "bookTooltipAuthor";
    private static final String BOOK_TOOLTIP_MESSAGE_ID = "bookTooltipMessage";
    private ContextMenuButton bookTooltipButton;
    private BookOption bookMode;
    private TextBoxComponent bookTooltipAuthor;
    private TextAreaComponent bookTooltipMessage;

    @Override
    public void generate(IImagetextAlgorithm algorithm, ImagetextLogic logic, ImagetextData data, boolean isExecute) {
        logic.generateImagetext(algorithm, data);
    }

    @Override
    public void execute(ImagetextLogic logic) {
        String author = this.bookTooltipAuthor.method_1882();
        String bookMessage = this.bookTooltipMessage.method_44405();
        BookBuilder bookBuilder = this.bookMode.getBookBuilder().author(author).addPage((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1078) + bookMessage)).method_10862(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)logic.getText()))));
        class_1799 book = bookBuilder.get();
        assert (book.method_7969() != null);
        long bookLength = FzmmUtils.getLengthInBytes(book);
        if (bookLength > 16384L) {
            class_310.method_1551().execute(() -> {
                ISnackBarComponent snackBar = BaseSnackBarComponent.builder("imagetext").title((class_2561)class_2561.method_43469((String)"fzmm.snack_bar.bookTooltip.overflow.title", (Object[])new Object[]{bookLength, 16384})).details((class_2561)class_2561.method_43471((String)"fzmm.snack_bar.bookTooltip.overflow.details")).backgroundColor(FzmmStyles.ALERT_ERROR_COLOR).keepOnLimit().highTimer().startTimer().closeButton().build();
                SnackBarManager.getInstance().add(snackBar);
            });
        } else {
            FzmmUtils.giveItem(book);
        }
    }

    @Override
    public void setupComponents(FlowLayout rootComponent) {
        assert (class_310.method_1551().field_1724 != null);
        this.bookTooltipButton = (ContextMenuButton)rootComponent.childById(ContextMenuButton.class, BOOK_TOOLTIP_MODE_ID);
        BaseFzmmScreen.checkNull((Component)this.bookTooltipButton, "context-menu-button", BOOK_TOOLTIP_MODE_ID);
        this.bookTooltipButton.setContextMenuOptions(dropdownComponent -> {
            for (BookOption option : BookOption.values()) {
                dropdownComponent.button((class_2561)class_2561.method_43471((String)option.getTranslationKey()), dropdownButton -> {
                    this.updateBookTooltip(option);
                    dropdownButton.remove();
                });
            }
        });
        this.updateBookTooltip(BookOption.ADD_PAGE);
        this.bookTooltipAuthor = TextBoxRow.setup(rootComponent, BOOK_TOOLTIP_AUTHOR_ID, class_310.method_1551().field_1724.method_5477().getString(), 512);
        this.bookTooltipMessage = (TextAreaComponent)rootComponent.childById(TextAreaComponent.class, "bookTooltipMessage-text-area");
        BaseFzmmScreen.checkNull((Component)this.bookTooltipMessage, "text-area", "bookTooltipMessage-text-area");
        this.bookTooltipMessage.maxLines(14);
        this.bookTooltipMessage.method_44402(4096);
        this.bookTooltipMessage.text(FzmmClient.CONFIG.imagetext.defaultBookMessage());
        FlowLayout layout = (FlowLayout)rootComponent.childById(FlowLayout.class, "bookTooltipMessage-text-area-parent");
        BaseFzmmScreen.checkNull((Component)this.bookTooltipMessage, "text-area", "bookTooltipMessage-text-area-parent");
        layout.verticalSizing(Sizing.content());
    }

    private void updateBookTooltip(BookOption mode) {
        this.bookMode = mode;
        this.bookTooltipButton.method_25355((class_2561)class_2561.method_43471((String)this.bookMode.getTranslationKey()));
    }

    @Override
    public String getId() {
        return "bookTooltip";
    }

    @Override
    public IMementoObject createMemento() {
        return new BookTooltipMementoTab(this.bookMode, this.bookTooltipAuthor.method_1882(), this.bookTooltipMessage.method_44405());
    }

    @Override
    public void restoreMemento(IMementoObject mementoTab) {
        BookTooltipMementoTab memento = (BookTooltipMementoTab)mementoTab;
        this.bookTooltipAuthor.text(memento.author);
        this.bookTooltipMessage.text(memento.message);
        this.updateBookTooltip(memento.mode);
    }

    private record BookTooltipMementoTab(BookOption mode, String author, String message) implements IMementoObject
    {
    }
}

