/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.head_generator.components;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.FzmmIcons;
import fzmm.zailer.me.client.entity.custom_skin.ISkinMutable;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.image.ImageMode;
import fzmm.zailer.me.client.gui.components.row.ColorRow;
import fzmm.zailer.me.client.gui.components.row.SliderRow;
import fzmm.zailer.me.client.gui.components.row.image.ImageRows;
import fzmm.zailer.me.client.gui.components.row.image.ImageRowsElements;
import fzmm.zailer.me.client.gui.components.snack_bar.BaseSnackBarComponent;
import fzmm.zailer.me.client.gui.components.snack_bar.ISnackBarComponent;
import fzmm.zailer.me.client.gui.components.snack_bar.SnackBarBuilder;
import fzmm.zailer.me.client.gui.components.style.FzmmStyles;
import fzmm.zailer.me.client.gui.components.style.StyledComponents;
import fzmm.zailer.me.client.gui.components.style.StyledContainers;
import fzmm.zailer.me.client.gui.components.style.component.StyledLabelComponent;
import fzmm.zailer.me.client.gui.components.style.container.StyledFlowLayout;
import fzmm.zailer.me.client.gui.head_generator.HeadGeneratorScreen;
import fzmm.zailer.me.client.gui.head_generator.category.IHeadCategory;
import fzmm.zailer.me.client.gui.head_generator.components.AbstractHeadComponentEntry;
import fzmm.zailer.me.client.gui.head_generator.options.SkinPreEditOption;
import fzmm.zailer.me.client.logic.head_generator.AbstractHeadEntry;
import fzmm.zailer.me.client.logic.head_generator.model.HeadModelEntry;
import fzmm.zailer.me.client.logic.head_generator.model.InternalModels;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.ColorParameter;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.INestedParameters;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.IParameterEntry;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.OffsetParameter;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.ParameterList;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.ImageUtils;
import fzmm.zailer.me.utils.SnackBarManager;
import io.wispforest.owo.itemgroup.Icon;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.EntityComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_318;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public class HeadComponentOverlay
extends StyledFlowLayout {
    private static final int OVERLAY_WIDGETS_WIDTH = 75;
    public static final class_2561 GIVE_BUTTON_TEXT = class_2561.method_43471((String)"fzmm.gui.button.giveHead");
    public static final class_2561 GIVE_WAITING_UNDEFINED_TEXT = class_2561.method_43471((String)"fzmm.gui.headGenerator.wait");
    public static final String GIVE_WAITING_SECONDS_KEY = "fzmm.gui.headGenerator.wait_seconds";
    private final HeadGeneratorScreen parentScreen;
    private final EntityComponent<class_1297> previewEntity;
    private boolean isSlimFormat;
    private ButtonComponent selectedSkinFormat;
    private SkinPreEditOption selectedSkinPreEdit;

    public HeadComponentOverlay(HeadGeneratorScreen parentScreen, EntityComponent<class_1297> previewEntity, AbstractHeadComponentEntry headComponentEntry) {
        super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.VERTICAL);
        this.parentScreen = parentScreen;
        this.previewEntity = previewEntity;
        this.isSlimFormat = false;
        this.selectedSkinFormat = null;
        AbstractHeadEntry entry = headComponentEntry.getValue();
        Map<String, String> parameters = Map.of("name", entry.getDisplayName().getString());
        FlowLayout headOverlay = (FlowLayout)((FlowLayout)this.parentScreen.getModel().expandTemplate(FlowLayout.class, "head-overlay", parameters)).configure(panel -> {
            panel.mouseDown().subscribe((mouseX1, mouseY1, button1) -> true);
            int giveButtonWidth = FzmmUtils.getMaxWidth(List.of(GIVE_BUTTON_TEXT, GIVE_WAITING_UNDEFINED_TEXT, class_2561.method_43469((String)GIVE_WAITING_SECONDS_KEY, (Object[])new Object[]{1}))) + 8;
            FlowLayout previewLayout = (FlowLayout)panel.childById(FlowLayout.class, "preview");
            BaseFzmmScreen.checkNull((Component)previewLayout, "flow-layout", "preview");
            previewLayout.alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
            this.previewEntity.cursorStyle(CursorStyle.MOVE);
            int previewEntitySize = ((Sizing)this.previewEntity.horizontalSizing().get()).value * 2;
            this.previewEntity.sizing(Sizing.fixed((int)previewEntitySize));
            if (headComponentEntry.isBodyPreview()) {
                previewLayout.sizing(Sizing.content((int)8), Sizing.fixed((int)((int)((double)previewEntitySize * 2.5))));
            }
            previewLayout.child(this.previewEntity);
            LabelComponent categoryLabel = (LabelComponent)panel.childById(LabelComponent.class, "category-label");
            BaseFzmmScreen.checkNull((Component)categoryLabel, "label", "category-label");
            categoryLabel.text(IHeadCategory.getCategory(entry, headComponentEntry.getCategoryId()).getText());
            ButtonComponent giveButton = (ButtonComponent)panel.childById(ButtonComponent.class, "give-button");
            BaseFzmmScreen.checkNull((Component)giveButton, "button", "give-button");
            giveButton.onPress(button -> this.giveButtonExecute(headComponentEntry));
            giveButton.horizontalSizing(Sizing.fixed((int)giveButtonWidth));
            parentScreen.setCurrentGiveButton(giveButton);
            ButtonComponent saveButton = (ButtonComponent)panel.childById(ButtonComponent.class, "save-button");
            BaseFzmmScreen.checkNull((Component)saveButton, "button", "save-button");
            saveButton.onPress(buttonComponent -> SnackBarManager.getInstance().add(this.saveSkinExecute(headComponentEntry.getPreview())));
            this.addDefaultOptions((FlowLayout)panel, headComponentEntry);
            if (entry instanceof INestedParameters) {
                INestedParameters parametersEntry = (INestedParameters)((Object)entry);
                this.addParameters((FlowLayout)panel, parentScreen, parametersEntry, headComponentEntry);
            }
            FlowLayout topRightButtonsLayout = (FlowLayout)panel.childById(FlowLayout.class, "top-right-buttons");
            BaseFzmmScreen.checkNull((Component)topRightButtonsLayout, "flow-layout", "top-right-buttons");
            headComponentEntry.addTopRightButtons((FlowLayout)panel, topRightButtonsLayout);
        });
        this.child((Component)headOverlay);
    }

    private void giveButtonExecute(AbstractHeadComponentEntry headComponentEntry) {
        this.parentScreen.giveHead(headComponentEntry.getPreview(), headComponentEntry.getValue().getDisplayName().getString());
    }

    public ISnackBarComponent saveSkinExecute(@Nullable BufferedImage skin) {
        File skinFolder = HeadGeneratorScreen.SKIN_SAVE_FOLDER_PATH.toFile();
        if (skinFolder.mkdirs()) {
            FzmmClient.LOGGER.info("[HeadComponentOverlay] Skin save folder created");
        }
        return HeadComponentOverlay.saveSkin(skin, class_318.method_1660((File)skinFolder));
    }

    public static ISnackBarComponent saveSkin(@Nullable BufferedImage skin, File file) {
        SnackBarBuilder builder = BaseSnackBarComponent.builder("head_generator_save").highTimer().closeButton();
        if (skin == null) {
            return builder.backgroundColor(FzmmStyles.ALERT_ERROR_COLOR).title((class_2561)class_2561.method_43471((String)"fzmm.gui.headGenerator.snack_bar.saveSkin.thereIsNoSkin")).keepOnLimit().build();
        }
        try {
            ImageIO.write((RenderedImage)skin, "png", file);
            FzmmClient.LOGGER.info("[HeadComponentOverlay] Saved skin to file: {}", (Object)file.toPath());
            builder.backgroundColor(FzmmStyles.ALERT_SUCCESS_COLOR).title((class_2561)class_2561.method_43471((String)"fzmm.gui.headGenerator.snack_bar.saveSkin.saved")).button(iSnackBarComponent -> Components.button((class_2561)class_2561.method_43471((String)"fzmm.gui.headGenerator.snack_bar.saveSkin.button.openFolder"), buttonComponent -> class_156.method_668().method_672(HeadGeneratorScreen.SKIN_SAVE_FOLDER_PATH.toFile()))).button(iSnackBarComponent -> Components.button((class_2561)class_2561.method_43471((String)"fzmm.gui.headGenerator.snack_bar.saveSkin.button.openSkin"), buttonComponent -> class_156.method_668().method_672(file))).sizing(Sizing.fixed((int)180), Sizing.content()).mediumTimer();
        }
        catch (IOException e) {
            FzmmClient.LOGGER.error("[HeadComponentOverlay] Unexpected error saving the skin", (Throwable)e);
            builder.backgroundColor(FzmmStyles.ALERT_ERROR_COLOR).title((class_2561)class_2561.method_43471((String)"fzmm.gui.headGenerator.snack_bar.saveSkin.saveError")).keepOnLimit();
        }
        return builder.startTimer().build();
    }

    private void addParameters(FlowLayout panel, BaseFzmmScreen parent, INestedParameters parametersEntry, AbstractHeadComponentEntry headComponentEntry) {
        FlowLayout parametersLayout = (FlowLayout)panel.childById(FlowLayout.class, "parameters");
        BaseFzmmScreen.checkNull((Component)parametersLayout, "flow-layout", "parameters");
        if (parametersEntry.hasRequestedParameters()) {
            StyledLabelComponent parametersLabel = StyledComponents.label((class_2561)class_2561.method_43471((String)"fzmm.gui.headGenerator.label.parameters"));
            parametersLayout.child((Component)parametersLabel);
            String baseTranslation = parent.getBaseScreenTranslationKey();
            this.addTextureParameters(parametersLayout, parametersEntry, baseTranslation, headComponentEntry);
            this.addColorParameters(parametersLayout, parametersEntry, baseTranslation, headComponentEntry);
            this.addOffsetsParameters(parametersLayout, parametersEntry, baseTranslation, headComponentEntry);
        }
    }

    private void addTextureParameters(FlowLayout parametersLayout, INestedParameters parametersEntry, String baseTranslation, AbstractHeadComponentEntry headComponentEntry) {
        ParameterList<BufferedImage> textureParameters = parametersEntry.getNestedTextureParameters();
        for (IParameterEntry<BufferedImage> texture : textureParameters.parameterList()) {
            if (!texture.isRequested()) continue;
            String buttonId = texture.id() + "-texture";
            String enumButtonId = texture.id() + "-texture-mode";
            ImageRows imageRows = new ImageRows(baseTranslation, buttonId, buttonId, enumButtonId, enumButtonId, false);
            parametersLayout.child((Component)imageRows);
            ImageRowsElements elements = ImageRows.setup(parametersLayout, buttonId, enumButtonId, ImageMode.NAME);
            elements.imageButton().setButtonCallback(bufferedImage -> {
                textureParameters.update(texture.id(), (BufferedImage)bufferedImage);
                this.updatePreview(headComponentEntry);
            });
            elements.valueField().horizontalSizing(Sizing.fixed((int)75)).zIndex(400);
        }
    }

    private void addColorParameters(FlowLayout parametersLayout, INestedParameters parametersEntry, String baseTranslation, AbstractHeadComponentEntry headComponentEntry) {
        ParameterList<ColorParameter> colorParameters = parametersEntry.getNestedColorParameters();
        for (IParameterEntry<ColorParameter> colorParameter : colorParameters.parameterList()) {
            if (!colorParameter.isRequested()) continue;
            String id = colorParameter.id() + "-color";
            ColorRow colorRow = new ColorRow(baseTranslation, id, id, false, false);
            parametersLayout.child((Component)colorRow);
            ColorParameter color = colorParameter.value().orElse(ColorParameter.getDefault());
            boolean hasAlpha = color.hasAlpha();
            ColorRow.setup(parametersLayout, id, color.color(), hasAlpha, 300, s -> {
                colorParameters.update(colorParameter.id(), new ColorParameter(colorRow.getValue(), hasAlpha));
                this.updatePreview(headComponentEntry);
            });
            colorRow.getWidget().horizontalSizing(Sizing.fixed((int)75));
        }
    }

    private void addOffsetsParameters(FlowLayout parametersLayout, INestedParameters parametersEntry, String baseTranslation, AbstractHeadComponentEntry headComponentEntry) {
        ParameterList<OffsetParameter> offsetParameters = parametersEntry.getNestedOffsetParameters();
        for (IParameterEntry<OffsetParameter> offset : offsetParameters.parameterList()) {
            if (!offset.isRequested() && offset.value().isEmpty()) continue;
            OffsetParameter offsetParameter = offset.value().get();
            String id = offset.id() + "-offset";
            SliderRow sliderRow = new SliderRow(baseTranslation, id, id, false);
            parametersLayout.child((Component)sliderRow);
            SliderRow.setup(parametersLayout, id, offsetParameter.value(), offsetParameter.minValue(), offsetParameter.maxValue(), Byte.class, 0, 1.0, d -> {
                offsetParameter.setValue(d.byteValue());
                this.updatePreview(headComponentEntry);
            });
            sliderRow.getWidget().horizontalSizing(Sizing.fixed((int)75));
        }
    }

    private void addDefaultOptions(FlowLayout panel, AbstractHeadComponentEntry headComponentEntry) {
        FlowLayout defaultOptionsLayout = (FlowLayout)panel.childById(FlowLayout.class, "default-options");
        BaseFzmmScreen.checkNull((Component)defaultOptionsLayout, "flow-layout", "default-options");
        defaultOptionsLayout.child((Component)this.getRotateOptions(headComponentEntry));
        defaultOptionsLayout.child((Component)this.getPreEditOptions(headComponentEntry));
        defaultOptionsLayout.child((Component)this.getSkinFormatOptions(headComponentEntry));
    }

    private ButtonComponent getModelButton(AbstractHeadComponentEntry headComponentEntry, HeadModelEntry modelEntry, int amount, int iconV, @Nullable Consumer<ButtonComponent> callback) {
        Icon icon = Icon.of((class_2960)FzmmIcons.TEXTURE, (int)64, (int)iconV, (int)256, (int)256);
        ButtonComponent result = Components.button((class_2561)class_2561.method_43473(), button -> {
            BufferedImage preview = headComponentEntry.getPreview();
            for (int i = 0; i < amount; ++i) {
                BufferedImage updatedSkin = modelEntry.getHeadSkin(preview, this.parentScreen.hasUnusedPixels());
                preview.flush();
                preview = updatedSkin;
            }
            headComponentEntry.updatePreview(preview, ImageUtils.isSlimSimpleCheck(preview));
            if (callback != null) {
                callback.accept((ButtonComponent)button);
            }
        });
        result.sizing(Sizing.fixed((int)20), Sizing.fixed((int)20));
        result.renderer((context, button, delta) -> {
            ButtonComponent.Renderer.VANILLA.draw(context, button, delta);
            icon.render((class_332)context, button.x() + 2, button.y() + 2, 0, 0, delta);
        });
        return result;
    }

    private FlowLayout getOptionLayout(String id) {
        StyledFlowLayout result = StyledContainers.verticalFlow(Sizing.content(), Sizing.content());
        result.horizontalAlignment(HorizontalAlignment.CENTER);
        result.gap(4);
        StyledLabelComponent label = StyledComponents.label((class_2561)class_2561.method_43471((String)("fzmm.gui.headGenerator.option.overlayDefault." + id)));
        result.child((Component)label);
        return result;
    }

    private FlowLayout getRotateOptions(AbstractHeadComponentEntry headComponentEntry) {
        FlowLayout rotateLayout = this.getOptionLayout("rotate");
        StyledFlowLayout rotateFirstRow = StyledContainers.horizontalFlow(Sizing.content(), Sizing.content());
        rotateFirstRow.gap(4);
        StyledFlowLayout rotateSecondRow = StyledContainers.horizontalFlow(Sizing.content(), Sizing.content());
        rotateSecondRow.gap(4);
        int iconV = 0;
        rotateFirstRow.children(List.of(this.getModelButton(headComponentEntry, InternalModels.ROTATE_IN_X_AXIS, 1, iconV, null), this.getModelButton(headComponentEntry, InternalModels.ROTATE_IN_Y_AXIS, 1, iconV += 16, null), this.getModelButton(headComponentEntry, InternalModels.ROTATE_IN_Z_AXIS, 1, iconV += 16, null)));
        rotateSecondRow.children(List.of(this.getModelButton(headComponentEntry, InternalModels.ROTATE_IN_X_AXIS, 3, iconV += 16, null), this.getModelButton(headComponentEntry, InternalModels.ROTATE_IN_Y_AXIS, 3, iconV += 16, null), this.getModelButton(headComponentEntry, InternalModels.ROTATE_IN_Z_AXIS, 3, iconV + 16, null)));
        rotateLayout.children(List.of(rotateFirstRow, rotateSecondRow));
        return rotateLayout;
    }

    private FlowLayout getPreEditOptions(AbstractHeadComponentEntry headComponentEntry) {
        FlowLayout preEditLayout = this.getOptionLayout("preEdit");
        StyledFlowLayout preEditRow = StyledContainers.horizontalFlow(Sizing.content(), Sizing.content());
        preEditRow.gap(4);
        HashMap<SkinPreEditOption, ButtonComponent> preEditHashMap = new HashMap<SkinPreEditOption, ButtonComponent>();
        for (SkinPreEditOption preEdit : SkinPreEditOption.values()) {
            StyledFlowLayout layout = StyledContainers.horizontalFlow(Sizing.content(), Sizing.content());
            this.parentScreen.setupPreEditButton(layout, preEdit, preEditHashMap, skinPreEditOption -> {
                this.selectedSkinPreEdit = skinPreEditOption;
                BufferedImage baseSkin = this.updatePreview(headComponentEntry);
                if (this.selectedSkinFormat != null && ImageUtils.isSlimSimpleCheck(baseSkin) != this.isSlimFormat) {
                    this.selectedSkinFormat.method_25306();
                }
                baseSkin.flush();
            });
            preEditRow.child((Component)layout);
        }
        boolean forcePreEditInNone = FzmmClient.CONFIG.headGenerator.forcePreEditNoneInModels() && headComponentEntry.getValue() instanceof HeadModelEntry;
        this.selectedSkinPreEdit = forcePreEditInNone ? SkinPreEditOption.NONE : this.parentScreen.skinPreEdit();
        ((ButtonComponent)preEditHashMap.get((Object)this.selectedSkinPreEdit)).field_22763 = false;
        preEditLayout.child((Component)preEditRow);
        return preEditLayout;
    }

    private BufferedImage getBaseSkin(SkinPreEditOption skinPreEditOption, boolean isBodyPreview) {
        return this.parentScreen.skinPreEdit(skinPreEditOption, isBodyPreview);
    }

    private FlowLayout getSkinFormatOptions(AbstractHeadComponentEntry headComponentEntry) {
        FlowLayout skinFormatLayout = this.getOptionLayout("skinFormat");
        StyledFlowLayout skinFormatRow = StyledContainers.horizontalFlow(Sizing.content(), Sizing.content());
        skinFormatRow.gap(4);
        ArrayList<ButtonComponent> buttons = new ArrayList<ButtonComponent>();
        ArrayList<Component> optionsList = new ArrayList<Component>();
        ButtonComponent slim = this.getModelButton(headComponentEntry, InternalModels.WIDE_TO_SLIM, 1, 96, modelButton -> this.skinFormatCallback((List<ButtonComponent>)buttons, (ButtonComponent)modelButton, true));
        ButtonComponent wide = this.getModelButton(headComponentEntry, InternalModels.SLIM_TO_WIDE, 1, 112, modelButton -> this.skinFormatCallback((List<ButtonComponent>)buttons, (ButtonComponent)modelButton, false));
        optionsList.add(StyledContainers.horizontalFlow(Sizing.content(), Sizing.content()).child((Component)wide).tooltip((class_2561)class_2561.method_43471((String)"fzmm.gui.headGenerator.option.overlayDefault.skinFormat.wide")));
        optionsList.add(StyledContainers.horizontalFlow(Sizing.content(), Sizing.content()).child((Component)slim).tooltip((class_2561)class_2561.method_43471((String)"fzmm.gui.headGenerator.option.overlayDefault.skinFormat.slim")));
        buttons.add(wide);
        buttons.add(slim);
        if (ImageUtils.isSlimSimpleCheck(headComponentEntry.getPreview())) {
            slim.field_22763 = false;
        } else {
            wide.field_22763 = false;
        }
        skinFormatRow.children(optionsList);
        skinFormatLayout.child((Component)skinFormatRow);
        return skinFormatLayout;
    }

    private void skinFormatCallback(List<ButtonComponent> buttons, ButtonComponent modelButton, boolean isSlim) {
        for (ButtonComponent button : buttons) {
            button.field_22763 = button != modelButton;
        }
        this.isSlimFormat = isSlim;
        this.selectedSkinFormat = modelButton;
        class_1297 class_12972 = this.previewEntity.entity();
        if (class_12972 instanceof ISkinMutable) {
            ISkinMutable skinMutable = (ISkinMutable)class_12972;
            skinMutable.updateFormat(isSlim);
        }
    }

    private BufferedImage updatePreview(AbstractHeadComponentEntry headComponentEntry) {
        BufferedImage baseSkin = this.getBaseSkin(this.selectedSkinPreEdit, headComponentEntry.isBodyPreview());
        headComponentEntry.update(baseSkin, this.parentScreen.hasUnusedPixels());
        return baseSkin;
    }
}

