/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.head_generator.components;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.head_generator.HeadGeneratorScreen;
import fzmm.zailer.me.client.gui.head_generator.category.IHeadCategory;
import fzmm.zailer.me.client.gui.head_generator.components.AbstractHeadComponentEntry;
import fzmm.zailer.me.client.logic.head_generator.AbstractHeadEntry;
import fzmm.zailer.me.config.FzmmConfig;
import fzmm.zailer.me.utils.FzmmUtils;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.event.MouseEnter;
import io.wispforest.owo.ui.event.MouseLeave;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import net.minecraft.class_5819;

public class HeadComponentEntry
extends AbstractHeadComponentEntry {
    private static final class_2561 ADD_LAYER_BUTTON_TEXT = class_2561.method_43471((String)"fzmm.gui.button.add");
    public static final class_2561 FAVORITE_ENABLED_TEXT = class_2561.method_43471((String)"fzmm.gui.button.favorite.enabled").method_10862(class_2583.field_24360.method_36139(15517449));
    private static final class_2561 FAVORITE_ENABLED_EASTER_EGG_TEXT = class_2561.method_43471((String)"fzmm.gui.button.favorite.enabled_easter_egg").method_10862(class_2583.field_24360.method_36139(16003083));
    public static final class_2561 FAVORITE_DISABLED_TEXT = class_2561.method_43471((String)"fzmm.gui.button.favorite.disabled").method_10862(class_2583.field_24360.method_36139(15517449));
    private static final int FAVORITE_BUTTON_WIDTH = HeadComponentEntry.getFavoriteButtonWidth();
    private final ButtonComponent favoriteButton;
    private boolean isFavorite;
    private boolean hide;

    public HeadComponentEntry(AbstractHeadEntry headData, HeadGeneratorScreen parent) {
        super(headData, Sizing.fixed((int)40), Sizing.fixed((int)30), parent);
        FzmmConfig.HeadGenerator config = FzmmClient.CONFIG.headGenerator;
        this.isFavorite = config.favoriteSkins().contains(this.entry.getKey());
        this.favoriteButton = Components.button((class_2561)class_2561.method_43473(), this::favoriteButtonExecute);
        this.setupFavoriteButton(this.favoriteButton);
        this.favoriteButton.positioning(Positioning.relative((int)100, (int)0));
        this.favoriteButton.verticalSizing(Sizing.fixed((int)16));
        this.updateFavoriteText(this.favoriteButton, false);
        this.favoriteButton.field_22764 = false;
        this.mouseEnter().subscribe(() -> {
            this.favoriteButton.field_22764 = true;
        });
        this.mouseLeave().subscribe(() -> {
            if (!this.hovered) {
                this.favoriteButton.field_22764 = false;
            }
        });
        this.child((Component)this.favoriteButton);
        for (Component entry : this.children()) {
            entry.mouseEnter().subscribe(() -> ((MouseEnter)this.mouseEnterEvents.sink()).onMouseEnter());
            entry.mouseLeave().subscribe(() -> ((MouseLeave)this.mouseLeaveEvents.sink()).onMouseLeave());
        }
        this.hide = false;
    }

    private void setupFavoriteButton(ButtonComponent favoriteButton) {
        favoriteButton.onPress(this::favoriteButtonExecute);
        favoriteButton.renderer(ButtonComponent.Renderer.flat((int)0, (int)0, (int)0));
        favoriteButton.sizing(Sizing.fixed((int)FAVORITE_BUTTON_WIDTH));
    }

    private static int getFavoriteButtonWidth() {
        return Math.max(15, FzmmUtils.getMaxWidth(List.of(FAVORITE_ENABLED_TEXT, FAVORITE_DISABLED_TEXT)) + 8);
    }

    private void favoriteButtonExecute(ButtonComponent button) {
        FzmmConfig.HeadGenerator config = FzmmClient.CONFIG.headGenerator;
        Set<String> favorites = config.favoriteSkins();
        if (this.isFavorite) {
            favorites.remove(this.entry.getKey());
        } else {
            favorites.add(this.entry.getKey());
        }
        config.favoriteSkins(favorites);
        this.isFavorite = !this.isFavorite;
        this.updateFavoriteText(button, true);
    }

    private void updateFavoriteText(ButtonComponent favoriteButton, boolean easterEgg) {
        class_2561 message;
        if (this.isFavorite) {
            int number = easterEgg ? class_5819.method_43047().method_39332(0, 40) : 0;
            message = number == 1 ? FAVORITE_ENABLED_EASTER_EGG_TEXT : FAVORITE_ENABLED_TEXT;
        } else {
            message = FAVORITE_DISABLED_TEXT;
        }
        favoriteButton.method_25355(message);
    }

    public void filter(String searchValue, boolean toggledFavorites, IHeadCategory headCategory) {
        if (!this.isFavorite && toggledFavorites || !headCategory.isCategory(this.entry, this.entry.getCategoryId())) {
            this.hide = true;
            return;
        }
        if (searchValue.isEmpty()) {
            this.hide = false;
            return;
        }
        this.hide = !searchValue.isBlank() && !this.getFilterValue().contains(searchValue);
    }

    public boolean isHide() {
        return this.hide;
    }

    @Override
    protected void addTopRightButtons(FlowLayout panel, FlowLayout layout) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        ButtonComponent overlayFavoriteButton = Components.button((class_2561)class_2561.method_43473(), buttonComponent -> {});
        overlayFavoriteButton.method_25355(this.favoriteButton.method_25369());
        this.setupFavoriteButton(overlayFavoriteButton);
        int addLayerButtonWidth = textRenderer.method_27525((class_5348)ADD_LAYER_BUTTON_TEXT) + 8;
        ButtonComponent addCompoundButton = Components.button((class_2561)ADD_LAYER_BUTTON_TEXT, this::addCompoundButtonExecute);
        addCompoundButton.horizontalSizing(Sizing.fixed((int)Math.max(20, addLayerButtonWidth)));
        layout.children(List.of(overlayFavoriteButton, addCompoundButton));
    }

    private void addCompoundButtonExecute(ButtonComponent button) {
        this.parentScreen.addCompound(this.entry, this.getPreview());
    }
}

