/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.head_generator.components;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.entity.custom_skin.CustomHeadEntity;
import fzmm.zailer.me.client.entity.custom_skin.CustomPlayerSkinEntity;
import fzmm.zailer.me.client.entity.custom_skin.ISkinMutable;
import fzmm.zailer.me.client.gui.components.style.FzmmStyles;
import fzmm.zailer.me.client.gui.components.style.container.StyledFlowLayout;
import fzmm.zailer.me.client.gui.head_generator.HeadGeneratorScreen;
import fzmm.zailer.me.client.gui.head_generator.components.HeadComponentOverlay;
import fzmm.zailer.me.client.logic.head_generator.AbstractHeadEntry;
import fzmm.zailer.me.utils.ImageUtils;
import fzmm.zailer.me.utils.list.IListEntry;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.EntityComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.util.UIErrorToast;
import io.wispforest.owo.ui.util.UISounds;
import java.awt.image.BufferedImage;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1060;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_310;

public abstract class AbstractHeadComponentEntry
extends StyledFlowLayout
implements IListEntry<AbstractHeadEntry> {
    public static final int HEAD_PREVIEW_SIZE = 24;
    public static final int BODY_PREVIEW_SIZE = 12;
    protected AbstractHeadEntry entry;
    private EntityComponent<class_1297> previewComponent;
    private class_1043 previewTexture;
    private BufferedImage previewHead;
    protected final HeadGeneratorScreen parentScreen;
    protected OverlayContainer<FlowLayout> overlayContainer;
    private boolean isBodyPreview;

    public AbstractHeadComponentEntry(AbstractHeadEntry entry, Sizing horizontalSizing, Sizing verticalSizing, HeadGeneratorScreen parent) {
        super(horizontalSizing, verticalSizing, FlowLayout.Algorithm.VERTICAL);
        this.setBodyPreview(entry.isEditingSkinBody());
        this.setValue(entry);
        this.alignment(HorizontalAlignment.LEFT, VerticalAlignment.CENTER);
        this.gap(8);
        this.cursorStyle(CursorStyle.HAND);
        this.parentScreen = parent;
        this.mouseDown().subscribe((mouseX, mouseY, button) -> {
            try {
                this.addOverlay(parent);
            }
            catch (Exception e) {
                UIErrorToast.report((Throwable)e);
            }
            UISounds.playInteractionSound();
            return true;
        });
        this.hoveredSurface(FzmmStyles.DEFAULT_HOVERED);
    }

    public boolean isBodyPreview() {
        return this.isBodyPreview;
    }

    private void setBodyPreview(boolean isBody) {
        int margins;
        int size;
        ISkinMutable previewEntity;
        this.isBodyPreview = isBody;
        if (isBody) {
            previewEntity = new CustomPlayerSkinEntity(class_310.method_1551().field_1687);
            size = 12;
            margins = 2;
        } else {
            previewEntity = new CustomHeadEntity((class_1937)class_310.method_1551().field_1687);
            size = 24;
            margins = 0;
        }
        this.removeChild((Component)this.previewComponent);
        this.previewComponent = Components.entity((Sizing)Sizing.fixed((int)size), (class_1297)previewEntity);
        this.previewComponent.cursorStyle(CursorStyle.HAND);
        this.previewComponent.margins(Insets.left((int)margins));
        this.child((Component)this.previewComponent);
    }

    public String getFilterValue() {
        return this.entry.getFilterValue();
    }

    public String getCategoryId() {
        return this.entry.getCategoryId();
    }

    public void update(BufferedImage baseSkin, boolean hasUnusedPixels) {
        this.update(baseSkin, hasUnusedPixels, ImageUtils.isSlimSimpleCheck(baseSkin));
    }

    public void update(BufferedImage baseSkin, boolean hasUnusedPixels, boolean isSlim) {
        if (this.updateHead(baseSkin, hasUnusedPixels)) {
            this.updatePreview(isSlim);
        } else {
            this.close();
        }
    }

    public boolean updateHead(BufferedImage baseSkin, boolean hasUnusedPixels) {
        try {
            if (this.previewHead != null) {
                this.previewHead.flush();
            }
            this.previewHead = this.entry.getHeadSkin(baseSkin, hasUnusedPixels);
        }
        catch (Exception e) {
            FzmmClient.LOGGER.error("[AbstractHeadListEntry] Failed to update preview skin of '{}'", (Object)this.entry.getKey(), (Object)e);
            return false;
        }
        return true;
    }

    public void updatePreview(boolean isSlim) {
        if (this.previewHead != null) {
            this.updatePreview(this.previewHead, isSlim);
        }
    }

    public void updatePreview(BufferedImage previewSkin, boolean isSlim) {
        class_310 client = class_310.method_1551();
        class_1060 textureManager = client.method_1531();
        this.close();
        class_1297 class_12972 = this.previewComponent.entity();
        if (!(class_12972 instanceof ISkinMutable)) {
            FzmmClient.LOGGER.error("[AbstractHeadListEntry] Failed to update preview entity");
            return;
        }
        ISkinMutable previewEntity = (ISkinMutable)class_12972;
        class_1011 nativeImage = ImageUtils.toNativeImage(previewSkin);
        nativeImage.method_4302();
        this.previewTexture = new class_1043(nativeImage);
        previewEntity.setSkin(textureManager.method_4617("fzmm_head", this.previewTexture), isSlim);
        textureManager.method_22813(previewEntity.getTextures());
    }

    protected EntityComponent<class_1297> copyCustomHeadEntity() {
        return Components.entity((Sizing)((Sizing)this.previewComponent.horizontalSizing().get()), (class_1297)this.previewComponent.entity());
    }

    public void close() {
        if (this.previewTexture == null) {
            return;
        }
        this.previewTexture.close();
        this.previewTexture = null;
        if (this.previewHead == null) {
            return;
        }
        this.previewHead.flush();
        this.previewHead = null;
    }

    public BufferedImage getPreview() {
        class_1011 nativeImage = this.previewTexture.method_4525();
        if (nativeImage == null) {
            FzmmClient.LOGGER.warn("[AbstractHeadListEntry] Failed to get preview image for {}", (Object)this.entry.getDisplayName().getString());
            return new BufferedImage(64, 64, 2);
        }
        return ImageUtils.getBufferedImgFromNativeImg(nativeImage);
    }

    protected void addOverlay(HeadGeneratorScreen parent) {
        EntityComponent previewEntity = this.copyCustomHeadEntity().allowMouseRotation(true);
        HeadComponentOverlay overlayLayout = new HeadComponentOverlay(parent, (EntityComponent<class_1297>)previewEntity, this);
        this.overlayContainer = new OverlayContainer<FlowLayout>((FlowLayout)overlayLayout){

            public void remove() {
                super.remove();
                AbstractHeadComponentEntry.this.onCloseOverlay();
            }
        };
        this.overlayContainer.zIndex(300);
        parent.addOverlay((Component)this.overlayContainer);
    }

    protected void onCloseOverlay() {
    }

    protected abstract void addTopRightButtons(FlowLayout var1, FlowLayout var2);

    @Override
    public AbstractHeadEntry getValue() {
        return this.entry;
    }

    @Override
    public void setValue(AbstractHeadEntry value) {
        this.entry = value;
        this.previewComponent.tooltip(value.getDisplayName());
    }
}

