/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.converters.tabs;

import fzmm.zailer.me.client.gui.components.row.ButtonRow;
import fzmm.zailer.me.client.gui.components.row.NumberRow;
import fzmm.zailer.me.client.gui.components.tabs.IScreenTab;
import fzmm.zailer.me.utils.SnackBarManager;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.ui.container.FlowLayout;
import java.util.UUID;
import net.minecraft.class_5819;

public class ConverterArrayToUuidTab
implements IScreenTab {
    private static final int ARRAY_SIZE = 4;
    private static final String ARRAY_ID = "array%s";
    private static final String RANDOM_ID = "arrayToUuid.random";
    private static final String COPY_ID = "arrayToUuid.copy";
    private ConfigTextBox[] textBoxArray;

    @Override
    public String getId() {
        return "arrayToUuid";
    }

    @Override
    public void setupComponents(FlowLayout rootComponent) {
        this.textBoxArray = new ConfigTextBox[4];
        for (int i = 0; i != 4; ++i) {
            this.textBoxArray[i] = NumberRow.setup(rootComponent, this.getArrayId(i), 0.0, Integer.class);
        }
        ButtonRow.setup(rootComponent, ButtonRow.getButtonId(RANDOM_ID), true, button -> {
            class_5819 random = class_5819.method_43047();
            for (ConfigTextBox element : this.textBoxArray) {
                element.text(String.valueOf(random.method_43054()));
            }
        });
        ButtonRow.setup(rootComponent, ButtonRow.getButtonId(COPY_ID), true, button -> {
            int[] intArray = new int[4];
            for (int i = 0; i != 4; ++i) {
                intArray[i] = (Integer)this.textBoxArray[i].parsedValue();
            }
            long msb = Integer.toUnsignedLong(intArray[0]);
            long lsb = Integer.toUnsignedLong(intArray[2]);
            msb = msb << 32 | Integer.toUnsignedLong(intArray[1]);
            lsb = lsb << 32 | Integer.toUnsignedLong(intArray[3]);
            SnackBarManager.copyToClipboard(new UUID(msb, lsb).toString());
        });
    }

    public String getArrayId(int index) {
        return String.format(ARRAY_ID, "." + index);
    }
}

