/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.row.image;

import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.SuggestionTextBox;
import fzmm.zailer.me.client.gui.components.image.ImageButtonComponent;
import fzmm.zailer.me.client.gui.components.image.ImageMode;
import fzmm.zailer.me.client.gui.components.image.source.IImageGetter;
import fzmm.zailer.me.client.gui.components.row.AbstractRow;
import fzmm.zailer.me.client.gui.components.row.image.ImageButtonRow;
import fzmm.zailer.me.client.gui.components.row.image.ImageRowsElements;
import fzmm.zailer.me.client.gui.components.style.FzmmStyles;
import fzmm.zailer.me.client.gui.components.style.StyledContainers;
import fzmm.zailer.me.client.gui.components.style.container.StyledFlowLayout;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2561;
import org.w3c.dom.Element;

public class ImageRows
extends StyledFlowLayout {
    public static int TOTAL_HEIGHT = 52;

    public ImageRows(String baseTranslationKey, String buttonId, String imageModeId, boolean translate) {
        this(baseTranslationKey, buttonId, buttonId, imageModeId, imageModeId, translate);
    }

    public ImageRows(String baseTranslationKey, String buttonId, String buttonTooltipId, final String imageModeId, String imageTooltipId, boolean translate) {
        super(Sizing.fill((int)100), Sizing.fixed((int)TOTAL_HEIGHT), FlowLayout.Algorithm.HORIZONTAL);
        StyledFlowLayout rowsLayout = StyledContainers.verticalFlow(Sizing.fill((int)100), Sizing.fixed((int)TOTAL_HEIGHT));
        rowsLayout.children(List.of(new ImageButtonRow(baseTranslationKey, buttonId, buttonTooltipId, translate).hoveredSurface(null), new AbstractRow(baseTranslationKey, imageModeId, imageTooltipId, false, translate){

            @Override
            public Component[] getComponents(String id, String tooltipId) {
                return new Component[]{StyledContainers.horizontalFlow(Sizing.content(), Sizing.content()).id(imageModeId + "-layout")};
            }
        }.hoveredSurface(null)));
        this.hoveredSurface(FzmmStyles.DEFAULT_HOVERED);
        this.child((Component)rowsLayout);
    }

    @Override
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        if (this.hovered) {
            context.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, 0x40000000);
        }
        super.draw(context, mouseX, mouseY, partialTicks, delta);
    }

    public static ImageRowsElements setup(FlowLayout rootComponent, String buttonId, String imageModeId, ImageMode defaultValue) {
        ImageButtonRow.setup(rootComponent, buttonId, defaultValue.getImageGetter());
        ImageButtonComponent imageWidget = (ImageButtonComponent)rootComponent.childById(ImageButtonComponent.class, ImageButtonRow.getImageButtonId(buttonId));
        SuggestionTextBox suggestionTextBox = (SuggestionTextBox)rootComponent.childById(SuggestionTextBox.class, ImageButtonRow.getImageValueFieldId(buttonId));
        FlowLayout imageModeLayout = (FlowLayout)rootComponent.childById(FlowLayout.class, imageModeId + "-layout");
        BaseFzmmScreen.checkNull((Component)imageModeLayout, "flow-layout", imageModeId + "-layout");
        imageModeLayout.gap(4);
        AtomicReference<ImageMode> selectedMode = new AtomicReference<ImageMode>(defaultValue);
        HashMap<ImageMode, ButtonComponent> imageModeButtons = new HashMap<ImageMode, ButtonComponent>();
        for (ImageMode modeOption : ImageMode.values()) {
            ButtonComponent modeButton = Components.button((class_2561)class_2561.method_43471((String)modeOption.getTranslationKey()), button -> {
                selectedMode.set(modeOption);
                for (ImageMode imageMode : ImageMode.values()) {
                    if (imageMode == modeOption) continue;
                    ((ButtonComponent)imageModeButtons.get((Object)((Object)((Object)imageMode)))).field_22763 = true;
                }
                button.field_22763 = false;
                IImageGetter imageGetter = modeOption.getImageGetter();
                imageWidget.setSourceType(imageGetter);
                ImageButtonRow.setupSuggestionTextBox(suggestionTextBox, imageGetter);
            });
            StyledFlowLayout modeButtonLayout = StyledContainers.verticalFlow(Sizing.content(), Sizing.content());
            modeButtonLayout.tooltip((class_2561)class_2561.method_43471((String)(modeOption.getTranslationKey() + ".tooltip")));
            modeButton.horizontalSizing(Sizing.fixed((int)20));
            modeButtonLayout.child((Component)modeButton);
            imageModeButtons.put(modeOption, modeButton);
            imageModeLayout.child((Component)modeButtonLayout);
        }
        ((ButtonComponent)imageModeButtons.get((Object)defaultValue)).method_25306();
        suggestionTextBox.setSuggestionSelectedCallback(() -> ((ImageButtonComponent)imageWidget).method_25306());
        return new ImageRowsElements(imageWidget, suggestionTextBox, selectedMode, imageModeButtons);
    }

    public static ImageRows parse(Element element) {
        String baseTranslationKey = BaseFzmmScreen.getBaseTranslationKey(element);
        String buttonId = AbstractRow.getId(element, "buttonId");
        String buttonTooltipId = AbstractRow.getTooltipId(element, buttonId, "buttonTooltipId");
        String imageModeId = AbstractRow.getId(element, "imageModeId");
        String imageModeTooltipId = AbstractRow.getTooltipId(element, imageModeId, "imageModeTooltipId");
        return new ImageRows(baseTranslationKey, buttonId, buttonTooltipId, imageModeId, imageModeTooltipId, true);
    }
}

