/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.row;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.row.AbstractRow;
import fzmm.zailer.me.compat.symbol_chat.font.FontTextBoxComponent;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TextBoxRow
extends AbstractRow {
    public TextBoxRow(String baseTranslationKey, String id, String tooltipId, boolean symbolChatButtons) {
        super(baseTranslationKey, id, tooltipId, true);
        FontTextBoxComponent fontTextBoxComponent = (FontTextBoxComponent)this.childById(FontTextBoxComponent.class, TextBoxRow.getTextBoxId(id));
        if (fontTextBoxComponent != null) {
            fontTextBoxComponent.enableFontProcess(symbolChatButtons);
        }
    }

    @Override
    public Component[] getComponents(String id, String tooltipId) {
        Component textBox = new FontTextBoxComponent(Sizing.fixed((int)198)).id(TextBoxRow.getTextBoxId(id));
        return new Component[]{textBox};
    }

    public static String getTextBoxId(String id) {
        return id + "-text-box";
    }

    public static TextBoxComponent setup(FlowLayout rootComponent, String id, String defaultValue, int maxLength) {
        return TextBoxRow.setup(rootComponent, id, defaultValue, maxLength, null);
    }

    public static TextBoxComponent setup(FlowLayout rootComponent, String id, String defaultValue, int maxLength, @Nullable Consumer<String> changedListener) {
        TextBoxComponent textBox = (TextBoxComponent)rootComponent.childById(TextBoxComponent.class, TextBoxRow.getTextBoxId(id));
        ButtonComponent resetButton = (ButtonComponent)rootComponent.childById(ButtonComponent.class, TextBoxRow.getResetButtonId(id));
        BaseFzmmScreen.checkNull((Component)textBox, "text-box", TextBoxRow.getTextBoxId(id));
        textBox.onChanged().subscribe(text -> {
            if (resetButton != null) {
                boolean bl = resetButton.field_22763 = !textBox.method_1882().equals(defaultValue);
            }
            if (changedListener != null) {
                changedListener.accept(text);
            }
        });
        textBox.method_1880(maxLength);
        textBox.text(defaultValue);
        if (resetButton != null) {
            resetButton.onPress(button -> textBox.text(defaultValue));
        }
        return textBox;
    }

    public static TextBoxRow parse(Element element) {
        TextBoxComponent textBox;
        String baseTranslationKey = BaseFzmmScreen.getBaseTranslationKey(element);
        String id = TextBoxRow.getId(element);
        String tooltipId = TextBoxRow.getTooltipId(element, id);
        boolean removeResetButton = UIParsing.childElements((Element)element).containsKey("removeResetButton") && UIParsing.parseBool((Node)((Node)UIParsing.childElements((Element)element).get("removeResetButton")));
        boolean removeHorizontalMargins = UIParsing.childElements((Element)element).containsKey("removeHorizontalMargins") && UIParsing.parseBool((Node)((Node)UIParsing.childElements((Element)element).get("removeHorizontalMargins")));
        boolean symbolChatButtons = UIParsing.childElements((Element)element).containsKey("symbolChatButtons") && UIParsing.parseBool((Node)((Node)UIParsing.childElements((Element)element).get("symbolChatButtons")));
        int fieldSize = UIParsing.childElements((Element)element).containsKey("fieldSize") ? UIParsing.parseSignedInt((Node)((Node)UIParsing.childElements((Element)element).get("fieldSize"))) : -1;
        fieldSize = UIParsing.childElements((Element)element).containsKey("removeHorizontalMargins") ? fieldSize : -1;
        TextBoxRow row = new TextBoxRow(baseTranslationKey, id, tooltipId, symbolChatButtons);
        if (removeHorizontalMargins) {
            row.removeHorizontalMargins();
        }
        if (removeResetButton) {
            row.removeResetButton();
        }
        if (fieldSize > 0 && (textBox = (TextBoxComponent)row.childById(TextBoxComponent.class, TextBoxRow.getTextBoxId(id))) != null) {
            textBox.horizontalSizing(Sizing.fixed((int)fieldSize));
        }
        class_437 screen = class_310.method_1551().field_1755;
        if (symbolChatButtons && screen instanceof BaseFzmmScreen) {
            BaseFzmmScreen baseFzmmScreen = (BaseFzmmScreen)screen;
            row.addSymbolChatButtons(baseFzmmScreen);
        }
        return row;
    }

    public void addSymbolChatButtons(BaseFzmmScreen screen) {
        if (!FzmmClient.CONFIG.general.showSymbolButton()) {
            return;
        }
        Optional<FlowLayout> rightLayoutOptional = this.getRightLayout();
        if (rightLayoutOptional.isEmpty()) {
            return;
        }
        FlowLayout rightLayout = rightLayoutOptional.get();
        List componentList = List.copyOf(rightLayout.children());
        TextBoxComponent textBoxComponent = (TextBoxComponent)rightLayout.childById(TextBoxComponent.class, TextBoxRow.getTextBoxId(this.getId()));
        rightLayout.clearChildren();
        rightLayout.child(screen.getSymbolChatCompat().getOpenFontSelectionDropDownButton((class_342)textBoxComponent));
        rightLayout.child(screen.getSymbolChatCompat().getOpenSymbolChatPanelButton((class_342)textBoxComponent));
        rightLayout.children(componentList);
    }
}

