/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.row;

import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.containers.ColorOverlay;
import fzmm.zailer.me.client.gui.components.row.AbstractRow;
import fzmm.zailer.me.client.gui.components.row.ConfigTextBoxRow;
import fzmm.zailer.me.utils.list.IListEntry;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.ui.component.BoxComponent;
import io.wispforest.owo.ui.component.ColorPickerComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Sizing;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class ColorRow
extends AbstractRow
implements IListEntry<Color> {
    public ColorRow(String baseTranslationKey, String id, String tooltipId) {
        this(baseTranslationKey, id, tooltipId, true, true);
    }

    public ColorRow(String baseTranslationKey, String id, String tooltipId, boolean hasResetButton, boolean translate) {
        super(baseTranslationKey, id, tooltipId, hasResetButton, translate);
    }

    @Override
    public Component[] getComponents(String id, String tooltipId) {
        ConfigTextBox colorField = (ConfigTextBox)new ConfigTextBox().horizontalSizing(Sizing.fixed((int)198)).id(ColorRow.getColorFieldId(id));
        Component box = Components.box((Sizing)Sizing.fixed((int)15), (Sizing)Sizing.fixed((int)15)).fill(true).cursorStyle(CursorStyle.HAND).id(ColorRow.getColorPreviewId(id));
        return new Component[]{box, colorField};
    }

    public static String getColorFieldId(String id) {
        return id + "-color";
    }

    public static String getColorPreviewId(String id) {
        return id + "-color-preview";
    }

    public static ConfigTextBox setup(FlowLayout rootComponent, String id, Color defaultcolor, boolean withAlpha, int additionalZIndex, @Nullable Consumer<String> changedListener) {
        ConfigTextBox colorField = ConfigTextBoxRow.setup(rootComponent, ColorRow.getColorFieldId(id), id, defaultcolor.asHexString(withAlpha), changedListener);
        colorField.inputPredicate(withAlpha ? s -> s.matches("#[a-zA-Z\\d]{0,8}") : s -> s.matches("#[a-zA-Z\\d]{0,6}"));
        colorField.applyPredicate(withAlpha ? s -> s.matches("#[a-zA-Z\\d]{8}") : s -> s.matches("#[a-zA-Z\\d]{6}"));
        colorField.valueParser(s -> {
            try {
                return withAlpha ? Color.ofArgb((int)Integer.parseUnsignedInt(s.substring(1), 16)) : Color.ofRgb((int)Integer.parseUnsignedInt(s.substring(1), 16));
            }
            catch (Exception ignored) {
                return Color.ofArgb((int)0);
            }
        });
        Supplier<Color> valueGetter = () -> (Color)colorField.parsedValue();
        BoxComponent colorPreview = ColorRow.setupColorPreview(id, rootComponent, withAlpha, additionalZIndex, valueGetter, picker -> colorField.text(picker.selectedColor().asHexString(withAlpha)));
        colorField.onChanged().subscribe(value -> colorPreview.color((Color)valueGetter.get()));
        colorField.method_1870(false);
        return colorField;
    }

    public static BoxComponent setupColorPreview(String id, FlowLayout rootComponent, boolean withAlpha, int additionalZIndex, Supplier<Color> valueGetter, Consumer<ColorPickerComponent> onPress) {
        BoxComponent colorPreview = (BoxComponent)rootComponent.childById(BoxComponent.class, ColorRow.getColorPreviewId(id));
        BaseFzmmScreen.checkNull((Component)colorPreview, "box", ColorRow.getColorPreviewId(id));
        colorPreview.color(valueGetter.get());
        colorPreview.mouseDown().subscribe((mouseX, mouseY, button) -> {
            ColorOverlay colorOverlay = new ColorOverlay((Color)valueGetter.get(), withAlpha, onPress, colorPreview);
            colorOverlay.zIndex(colorOverlay.zIndex() + additionalZIndex);
            class_437 patt0$temp = class_310.method_1551().field_1755;
            if (patt0$temp instanceof BaseFzmmScreen) {
                BaseFzmmScreen screen = (BaseFzmmScreen)patt0$temp;
                screen.addOverlay((Component)colorOverlay);
            }
            return true;
        });
        return colorPreview;
    }

    public static ColorRow parse(Element element) {
        String baseTranslationKey = BaseFzmmScreen.getBaseTranslationKey(element);
        String id = ColorRow.getId(element);
        String tooltipId = ColorRow.getTooltipId(element, id);
        return new ColorRow(baseTranslationKey, id, tooltipId);
    }

    public ConfigTextBox getWidget() {
        return (ConfigTextBox)this.childById(ConfigTextBox.class, ColorRow.getColorFieldId(this.getId()));
    }

    @Override
    public Color getValue() {
        ConfigTextBox colorField = this.getWidget();
        return colorField == null ? Color.ofArgb((int)0) : (Color)colorField.parsedValue();
    }

    @Override
    public void setValue(Color value) {
        ConfigTextBox colorField = this.getWidget();
        if (colorField != null) {
            colorField.text(value.asHexString(value.alpha() < 1.0f));
        }
    }
}

