/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.image.source;

import com.mojang.brigadier.suggestion.SuggestionProvider;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.components.image.ImageStatus;
import fzmm.zailer.me.client.gui.components.image.source.IImageLoaderFromText;
import fzmm.zailer.me.client.gui.components.image.source.IImageSuggestion;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.ImageUtils;
import fzmm.zailer.me.utils.skin.GetSkinFromCache;
import fzmm.zailer.me.utils.skin.GetSkinFromMojang;
import java.awt.image.BufferedImage;
import java.util.Optional;
import net.minecraft.class_310;
import net.minecraft.class_634;

public class ImagePlayerNameSource
implements IImageLoaderFromText,
IImageSuggestion {
    private static final String REGEX = "^[a-zA-Z0-9_]{2,16}$";
    private BufferedImage image = null;

    @Override
    public ImageStatus loadImage(String value) {
        if (this.image != null) {
            this.image.flush();
        }
        this.image = null;
        try {
            GetSkinFromCache getSkinDecorator;
            boolean isInvalidName;
            boolean bl = isInvalidName = !this.predicateRegex(value);
            if (isInvalidName && this.predicateOnlinePlayer(value)) {
                getSkinDecorator = new GetSkinFromCache();
            } else {
                if (isInvalidName) {
                    return ImageStatus.INVALID_USERNAME;
                }
                getSkinDecorator = new GetSkinFromCache(new GetSkinFromMojang());
            }
            Optional<BufferedImage> optionalImage = ImageUtils.getPlayerSkin(value, getSkinDecorator);
            optionalImage.ifPresent(image -> {
                this.image = image;
            });
            if (optionalImage.isEmpty()) {
                return this.predicateOnlinePlayer(value) ? ImageStatus.PLAYER_HAS_NO_SKIN : ImageStatus.PLAYER_NOT_FOUND;
            }
            return ImageStatus.IMAGE_LOADED;
        }
        catch (Exception e) {
            FzmmClient.LOGGER.error("Unexpected error loading an image", (Throwable)e);
            return ImageStatus.UNEXPECTED_ERROR;
        }
    }

    @Override
    public Optional<BufferedImage> getImage() {
        return Optional.ofNullable(this.image);
    }

    @Override
    public boolean predicate(String value) {
        return this.predicateRegex(value) || this.predicateOnlinePlayer(value);
    }

    private boolean predicateRegex(String value) {
        return value.matches(REGEX);
    }

    private boolean predicateOnlinePlayer(String value) {
        class_634 networkHandler = class_310.method_1551().method_1562();
        if (networkHandler == null) {
            return false;
        }
        return networkHandler.method_2874(value) != null;
    }

    @Override
    public boolean hasTextField() {
        return true;
    }

    @Override
    public SuggestionProvider<?> getSuggestionProvider() {
        return FzmmUtils.SUGGESTION_PLAYER;
    }
}

