/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.image;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.components.image.ImageStatus;
import fzmm.zailer.me.client.gui.components.image.source.IImageGetter;
import fzmm.zailer.me.client.gui.components.image.source.IImageLoaderFromText;
import fzmm.zailer.me.client.gui.components.image.source.IInteractiveImageLoader;
import fzmm.zailer.me.client.gui.components.image.source.ImagePlayerNameSource;
import fzmm.zailer.me.client.gui.components.snack_bar.BaseSnackBarComponent;
import fzmm.zailer.me.client.gui.components.snack_bar.ISnackBarComponent;
import fzmm.zailer.me.client.gui.components.snack_bar.SnackBarBuilder;
import fzmm.zailer.me.client.gui.components.style.FzmmStyles;
import fzmm.zailer.me.utils.SnackBarManager;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.core.Sizing;
import java.awt.image.BufferedImage;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class ImageButtonComponent
extends ButtonComponent {
    @Nullable
    private BufferedImage image;
    private IImageGetter mode;
    private Function<BufferedImage, ImageStatus> imageLoadEvent;
    private Consumer<BufferedImage> callback;

    public ImageButtonComponent() {
        super((class_2561)class_2561.method_43473(), button -> {});
        this.verticalSizing(Sizing.fixed((int)20));
        this.image = null;
        this.mode = new ImagePlayerNameSource();
        this.imageLoadEvent = null;
    }

    public Optional<BufferedImage> getImage() {
        return Optional.ofNullable(this.image);
    }

    public void setSourceType(IImageGetter mode) {
        this.mode = mode;
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public void loadImage(String value) {
        IImageGetter iImageGetter = this.mode;
        if (iImageGetter instanceof IImageLoaderFromText) {
            IImageLoaderFromText imageLoaderFromText = (IImageLoaderFromText)iImageGetter;
            this.loadImageFromText(imageLoaderFromText, value);
        } else {
            iImageGetter = this.mode;
            if (iImageGetter instanceof IInteractiveImageLoader) {
                IInteractiveImageLoader interactiveImageLoader = (IInteractiveImageLoader)iImageGetter;
                this.interactiveImageLoad(interactiveImageLoader);
            }
        }
    }

    public void loadImageFromText(IImageLoaderFromText imageLoaderFromText, String value) {
        this.field_22763 = false;
        ISnackBarComponent loadingSnackBar = BaseSnackBarComponent.builder("load_image").title((class_2561)class_2561.method_43471((String)"fzmm.snack_bar.image.loading.title")).backgroundColor(FzmmStyles.ALERT_LOADING_COLOR).keepOnLimit().build();
        CompletableFuture.supplyAsync(() -> {
            class_310.method_1551().execute(() -> SnackBarManager.getInstance().add(loadingSnackBar));
            return imageLoaderFromText.loadImage(value);
        }).whenComplete((status, throwable) -> {
            Optional<BufferedImage> image = imageLoaderFromText.getImage();
            if (throwable != null) {
                FzmmClient.LOGGER.error("[ImageButtonComponent] Unexpected error loading an image", throwable);
                status = ImageStatus.UNEXPECTED_ERROR;
            }
            SnackBarBuilder snackBarStatus = BaseSnackBarComponent.builder("load_image").title(status.getStatusTranslation()).backgroundColor(status.getColor());
            if (status.isError() && status.hasDetails()) {
                snackBarStatus.highTimer().details(status.getDetailsTranslation()).closeButton().keepOnLimit().expandDetails();
                FzmmClient.LOGGER.warn("[ImageButtonComponent] Failed to load image");
            } else {
                if (this.imageLoadEvent != null) {
                    assert (image.isPresent());
                    this.imageLoadEvent.apply(image.get());
                }
                snackBarStatus.lowTimer();
                FzmmClient.LOGGER.info("[ImageButtonComponent] Image loaded successfully");
            }
            class_310.method_1551().execute(() -> {
                this.field_22763 = true;
                loadingSnackBar.close();
                SnackBarManager.getInstance().add(snackBarStatus.startTimer().build());
            });
            if (this.image != null) {
                this.image.flush();
            }
            this.image = image.orElse(null);
            if (this.callback != null) {
                this.callback.accept(this.image);
            }
        });
    }

    public void interactiveImageLoad(IInteractiveImageLoader interactiveImageLoader) {
        class_310.method_1551().execute(() -> {
            this.field_22763 = true;
            SnackBarManager.getInstance().remove("load_image");
        });
        this.field_22763 = false;
        interactiveImageLoader.execute(bufferedImage -> {
            if (this.image != null) {
                this.image.flush();
            }
            this.image = bufferedImage;
            this.field_22763 = true;
            if (this.callback != null) {
                this.callback.accept(this.image);
            }
        });
    }

    public void setImageLoadedEvent(Function<BufferedImage, ImageStatus> callback) {
        this.imageLoadEvent = callback;
    }

    public void setButtonCallback(Consumer<BufferedImage> callback) {
        this.callback = callback;
    }

    public void setImage(@Nullable BufferedImage image) {
        if (this.image != null) {
            this.image.flush();
        }
        this.image = image;
    }
}

