/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components;

import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.components.style.StyledComponents;
import fzmm.zailer.me.client.gui.components.style.StyledContainers;
import fzmm.zailer.me.client.gui.components.style.component.StyledLabelComponent;
import fzmm.zailer.me.client.gui.components.style.container.StyledFlowLayout;
import fzmm.zailer.me.compat.symbol_chat.font.FontTextBoxComponent;
import io.wispforest.owo.ui.component.DropdownComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class SuggestionTextBox
extends FontTextBoxComponent {
    private static final int SUGGESTION_HEIGHT = 16;
    private final SuggestionPosition suggestionPosition;
    private SuggestionProvider<?> suggestionProvider = (nul, builder) -> CompletableFuture.completedFuture(builder.build());
    private int maxSuggestionLines;
    private int selectedSuggestionIndex = -1;
    private boolean disableCallback = false;
    @Nullable
    private Runnable suggestionSelectedCallback = null;
    @Nullable
    private DropdownComponent suggestionsContextMenu;
    @Nullable
    private ScrollContainer<FlowLayout> suggestionsContainer = null;
    @Nullable
    private FlowLayout suggestionsLayout = null;

    public SuggestionTextBox() {
        this(Sizing.content(), SuggestionPosition.BOTTOM, 5);
    }

    public SuggestionTextBox(Sizing horizontalSizing, SuggestionPosition position, int maxSuggestionLines) {
        super(horizontalSizing);
        this.suggestionPosition = position;
        this.setMaxSuggestionLines(maxSuggestionLines);
        this.onChanged().subscribe(this::updateSuggestions);
    }

    private void openContextMenu() {
        class_437 screen = class_310.method_1551().field_1755;
        FlowLayout parent = (FlowLayout)this.root();
        if (this.contextMenuIsOpen() || screen == null || parent == null) {
            return;
        }
        this.suggestionsContextMenu = DropdownComponent.openContextMenu((class_437)screen, (ParentComponent)parent, FlowLayout::child, (double)this.x(), (double)this.y(), suggestionDropdown -> {
            suggestionDropdown.clearChildren();
            this.suggestionsLayout = StyledContainers.verticalFlow(Sizing.fill((int)100), Sizing.content());
            this.suggestionsContainer = Containers.verticalScroll((Sizing)Sizing.fixed((int)this.width()), (Sizing)Sizing.expand((int)100), (Component)this.suggestionsLayout);
            suggestionDropdown.child(this.suggestionsContainer);
        });
        this.suggestionsContextMenu.zIndex(this.zIndex() + 100);
        this.updateSuggestions(this.method_1882());
    }

    private void closeContextMenu() {
        if (this.suggestionsLayout != null) {
            this.suggestionsLayout.clearChildren();
        }
        if (this.suggestionsContextMenu != null) {
            this.suggestionsContextMenu.remove();
        }
        this.suggestionsLayout = null;
        this.suggestionsContainer = null;
        this.suggestionsContextMenu = null;
    }

    private boolean contextMenuIsOpen() {
        return this.suggestionsContextMenu != null && this.suggestionsContextMenu.hasParent() && this.suggestionsContainer != null && this.suggestionsLayout != null;
    }

    private boolean updateSelectedSuggestionIndex(int addIndex) {
        return this.updateSelectedSuggestionIndex(this.selectedSuggestionIndex, this.selectedSuggestionIndex + addIndex);
    }

    private boolean updateSelectedSuggestionIndex(int currentIndex, int newIndex) {
        if (this.suggestionsLayout == null || this.suggestionsContainer == null) {
            return false;
        }
        List children = this.suggestionsLayout.children();
        int childrenSize = children.size();
        if (currentIndex >= 0 && childrenSize > currentIndex) {
            ((Component)children.get(currentIndex)).onFocusLost();
        }
        if (newIndex < 0) {
            newIndex = childrenSize - 1;
        } else if (newIndex >= childrenSize) {
            newIndex = 0;
        }
        if (childrenSize > newIndex) {
            Component selectedComponent = (Component)children.get(newIndex);
            selectedComponent.onFocusGained(Component.FocusSource.MOUSE_CLICK);
            this.suggestionsContainer.scrollTo(selectedComponent);
        }
        this.selectedSuggestionIndex = newIndex;
        return true;
    }

    private void updateSuggestions(String newMessage) {
        if (!this.contextMenuIsOpen()) {
            this.openContextMenu();
            return;
        }
        assert (this.suggestionsLayout != null);
        this.suggestionsLayout.clearChildren();
        String newMessageToLowerCase = newMessage.toLowerCase();
        List<Suggestion> suggestions = this.getSuggestions(newMessage);
        int maxHorizontalSizing = this.suggestionsLayout.width() - 10;
        for (int i = 0; i != suggestions.size(); ++i) {
            String suggestion = suggestions.get(i).getText();
            int matchIndex = suggestion.toLowerCase().indexOf(newMessageToLowerCase);
            if (matchIndex < 0 || this.suggestionsLayout == null) continue;
            class_2561 suggestionMessage = this.getSuggestionMessage(suggestion, newMessageToLowerCase, matchIndex, maxHorizontalSizing);
            this.suggestionsLayout.child(this.getSuggestionComponent(suggestion, suggestionMessage));
        }
        if (this.suggestionsContextMenu != null) {
            this.suggestionsContextMenu.verticalSizing(Sizing.fixed((int)this.getMaxSuggestionsHeight(suggestions.size())));
        }
        this.updateSuggestionsPos();
    }

    private List<Suggestion> getSuggestions(String message) {
        try {
            return ((Suggestions)this.suggestionProvider.getSuggestions(null, new SuggestionsBuilder(message, 0)).get()).getList();
        }
        catch (Exception e) {
            FzmmClient.LOGGER.error("[SuggestionTextBox] Failed to get suggestions", (Throwable)e);
            assert (this.suggestionsLayout != null);
            this.suggestionsLayout.child((Component)StyledComponents.label((class_2561)class_2561.method_43470((String)"Failed to get suggestions")));
            return new ArrayList<Suggestion>();
        }
    }

    private class_2561 getSuggestionMessage(String suggestion, String textBoxMessageToLowerCase, int matchIndex, int maxHorizontalSizing) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        int startNewColorIndex = matchIndex + textBoxMessageToLowerCase.length();
        if (textRenderer.method_1727((String)suggestion) > maxHorizontalSizing) {
            int suggestionLength = ((String)suggestion).length();
            String ellipsis = "...";
            suggestion = ellipsis + textRenderer.method_27524((String)suggestion, maxHorizontalSizing -= textRenderer.method_1727(ellipsis), true);
            int difference = Math.abs(suggestionLength - ((String)suggestion).length());
            matchIndex -= difference;
            matchIndex = Math.max(0, matchIndex);
            startNewColorIndex -= difference;
            startNewColorIndex = Math.max(0, startNewColorIndex);
        }
        return class_2561.method_43470((String)((String)suggestion).substring(0, matchIndex)).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)((String)suggestion).substring(matchIndex, startNewColorIndex)).method_10862(class_2583.field_24360.method_10977(class_124.field_1054))).method_10852((class_2561)class_2561.method_43470((String)((String)suggestion).substring(startNewColorIndex)).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
    }

    private Component getSuggestionComponent(String suggestion, class_2561 suggestionText) {
        StyledLabelComponent labelComponent = StyledComponents.label(suggestionText);
        StyledFlowLayout layout = StyledContainers.verticalFlow(Sizing.fill((int)100), Sizing.fixed((int)16));
        Surface selectedSurface = Surface.flat((int)-536870912).and(Surface.outline((int)-1593835521));
        Surface unselectedSurface = Surface.flat((int)-1610612736);
        layout.focusGained().subscribe(source -> layout.surface(Surface.BLANK));
        layout.hoveredSurface(selectedSurface);
        layout.focusLost().subscribe(() -> layout.surface(unselectedSurface));
        layout.mouseDown().subscribe((mouseX, mouseY, button) -> {
            this.text(suggestion);
            if (this.suggestionSelectedCallback != null && !this.disableCallback) {
                this.suggestionSelectedCallback.run();
            }
            this.closeContextMenu();
            return true;
        });
        layout.surface(unselectedSurface).verticalAlignment(VerticalAlignment.CENTER).cursorStyle(CursorStyle.HAND);
        labelComponent.cursorStyle(CursorStyle.HAND).margins(Insets.horizontal((int)4));
        return layout.child((Component)labelComponent);
    }

    private int getMaxSuggestionsHeight(int lines) {
        return Math.min(this.getSuggestionsHeight(lines), this.getSuggestionsHeight(this.maxSuggestionLines));
    }

    private int getSuggestionsHeight(int lines) {
        float totalLines = (float)lines + (this.maxSuggestionLines > lines ? 0.0f : 0.5f);
        return (int)(16.0f * totalLines);
    }

    private void updateSuggestionsPos() {
        if (this.suggestionsLayout == null || this.suggestionsContextMenu == null) {
            return;
        }
        int offset = switch (this.suggestionPosition.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> -this.getMaxSuggestionsHeight(this.suggestionsLayout.children().size());
            case 1 -> this.height();
        };
        int x = this.x();
        int y = this.y();
        assert (this.suggestionsContextMenu != null);
        this.suggestionsContextMenu.updateX(x);
        this.suggestionsContextMenu.updateY(y + offset);
    }

    public void updateX(int x) {
        super.updateX(x);
        this.updateSuggestionsPos();
    }

    public void updateY(int y) {
        super.updateY(y);
        this.updateSuggestionsPos();
    }

    public void setMaxSuggestionLines(int maxSuggestionLines) {
        this.maxSuggestionLines = maxSuggestionLines;
        if (this.suggestionsContextMenu != null) {
            this.suggestionsContextMenu.verticalSizing(Sizing.fixed((int)this.getMaxSuggestionsHeight(maxSuggestionLines)));
        }
    }

    public void setSuggestionProvider(SuggestionProvider<?> provider) {
        this.suggestionProvider = provider;
        if (this.suggestionsLayout != null) {
            this.suggestionsLayout.clearChildren();
        }
    }

    public void setSuggestionSelectedCallback(@Nullable Runnable suggestionSelectedCallback) {
        this.suggestionSelectedCallback = suggestionSelectedCallback;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean result = switch (keyCode) {
            case 258 -> {
                if (!this.contextMenuIsOpen()) {
                    this.openContextMenu();
                    yield true;
                }
                if (!$assertionsDisabled && this.suggestionsLayout == null) {
                    throw new AssertionError();
                }
                if (this.suggestionsLayout.children().isEmpty()) {
                    this.updateSuggestions(this.method_1882());
                    if (!this.suggestionsLayout.children().isEmpty()) {
                        yield true;
                    }
                    yield false;
                }
                yield this.updateSelectedSuggestionIndex(1);
            }
            case 264 -> this.updateSelectedSuggestionIndex(1);
            case 265 -> this.updateSelectedSuggestionIndex(-1);
            case 257, 335 -> {
                if (this.suggestionsLayout == null) {
                    yield false;
                }
                List children = this.suggestionsLayout.children();
                if (this.selectedSuggestionIndex >= 0 && this.selectedSuggestionIndex < children.size()) {
                    this.disableCallback = true;
                    Component selectedComponent = (Component)children.get(this.selectedSuggestionIndex);
                    selectedComponent.onMouseDown((double)selectedComponent.x(), (double)selectedComponent.y(), 0);
                    this.disableCallback = false;
                    yield true;
                }
            }
            case 256 -> {
                boolean contextMenuIsOpen = this.contextMenuIsOpen();
                this.closeContextMenu();
                yield contextMenuIsOpen;
            }
            default -> false;
        };
        return result || super.method_25404(keyCode, scanCode, modifiers);
    }

    public static enum SuggestionPosition {
        TOP,
        BOTTOM;

    }
}

