/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.banner_editor.tabs;

import fzmm.zailer.me.builders.BannerBuilder;
import fzmm.zailer.me.client.gui.banner_editor.BannerEditorScreen;
import fzmm.zailer.me.client.gui.banner_editor.tabs.AbstractModifyPatternsTab;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.util.UISounds;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ChangeColorTab
extends AbstractModifyPatternsTab {
    private static final String PATTERNS_LAYOUT = "change-color-layout";

    @Override
    public String getId() {
        return "changeColor";
    }

    @Override
    protected String getGridId() {
        return PATTERNS_LAYOUT;
    }

    @Override
    public boolean shouldAddBaseColor() {
        return true;
    }

    @Override
    protected void onItemComponentCreated(BannerEditorScreen parent, ItemComponent itemComponent, class_2520 pattern, BannerBuilder currentBanner, class_1767 color) {
        class_1799 modifiedStack;
        class_1799 itemComponentStack = itemComponent.stack();
        List tooltipComponents = itemComponent.tooltip() == null ? List.of() : itemComponent.tooltip();
        itemComponent.tooltip(tooltipComponents);
        class_2499 patterns = currentBanner.patterns();
        int index = -1;
        int patternsSize = patterns.size();
        for (int i = 0; i != patternsSize; ++i) {
            if (patterns.method_10534(i) != pattern) continue;
            index = i;
            break;
        }
        boolean isBannerColor = index == -1;
        itemComponent.mouseDown().subscribe((mouseX, mouseY, button) -> {
            this.componentExecute(parent, currentBanner, color, pattern, isBannerColor, patterns);
            return true;
        });
        if (isBannerColor) {
            class_1792 modifiedItem;
            class_2487 modifiedNbt = itemComponentStack.method_7972().method_7969();
            if (currentBanner.isShield()) {
                modifiedItem = itemComponentStack.method_7909();
                if (modifiedNbt != null && modifiedNbt.method_10573("BlockEntityTag", 10)) {
                    modifiedNbt.method_10562("BlockEntityTag").method_10569("Base", color.method_7789());
                }
            } else {
                modifiedItem = BannerBuilder.getBannerByDye(color);
            }
            modifiedStack = modifiedItem.method_7854();
            modifiedStack.method_7980(modifiedNbt);
        } else {
            modifiedStack = itemComponentStack.method_7972();
            class_2487 blockEntityTag = modifiedStack.method_7941("BlockEntityTag");
            if (blockEntityTag == null) {
                return;
            }
            class_2499 modifiedPatterns = blockEntityTag.method_10554("Patterns", 10);
            if (modifiedPatterns == null) {
                return;
            }
            class_2487 modifiedPattern = (class_2487)modifiedPatterns.method_10534(index);
            modifiedPattern.method_10569("Color", color.method_7789());
        }
        itemComponent.mouseEnter().subscribe(() -> itemComponent.stack(modifiedStack));
        itemComponent.mouseLeave().subscribe(() -> itemComponent.stack(itemComponentStack));
    }

    private void componentExecute(BannerEditorScreen parent, BannerBuilder currentBanner, class_1767 color, class_2520 pattern, boolean isBannerColor, class_2499 patterns) {
        UISounds.playButtonSound();
        parent.addUndo(currentBanner);
        if (!(pattern instanceof class_2487)) {
            return;
        }
        class_2487 selectedPatternCompound = (class_2487)pattern;
        if (class_437.method_25442()) {
            int selectedColorId = selectedPatternCompound.method_10550("Color");
            if (currentBanner.bannerColor().method_7789() == selectedColorId) {
                currentBanner.bannerColor(color);
            }
            for (class_2520 patternElement : patterns) {
                class_2487 bannerPatternCompound;
                if (!(patternElement instanceof class_2487) || (bannerPatternCompound = (class_2487)patternElement).method_10550("Color") != selectedColorId) continue;
                bannerPatternCompound.method_10569("Color", color.method_7789());
            }
        } else if (isBannerColor) {
            currentBanner.bannerColor(color);
        } else {
            selectedPatternCompound.method_10569("Color", color.method_7789());
        }
        parent.updatePreview(currentBanner);
    }

    @Override
    protected Optional<class_2561> getTooltip(BannerEditorScreen parent, class_2520 pattern, BannerBuilder currentBanner, class_1767 color) {
        Optional<class_2561> defaultTooltip = super.getTooltip(parent, pattern, currentBanner, color);
        if (defaultTooltip.isPresent()) {
            class_5250 result = defaultTooltip.get().method_27661();
            result.method_27693("\n\n").method_10852((class_2561)class_2561.method_43471((String)"fzmm.gui.bannerEditor.tab.changeColor.shiftHotkey"));
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

