/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.banner_editor.tabs;

import fzmm.zailer.me.builders.BannerBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.banner_editor.BannerEditorScreen;
import fzmm.zailer.me.client.gui.banner_editor.tabs.IBannerEditorTab;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.util.UISounds;
import java.util.ArrayList;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2582;
import net.minecraft.class_7446;
import net.minecraft.class_7923;

public class AddPatternsTab
implements IBannerEditorTab {
    private static final String PATTERNS_LAYOUT = "add-patterns-layout";
    private FlowLayout patternsLayout;

    @Override
    public String getId() {
        return "addPatterns";
    }

    @Override
    public void setupComponents(FlowLayout rootComponent) {
        this.patternsLayout = (FlowLayout)rootComponent.childById(FlowLayout.class, PATTERNS_LAYOUT);
        BaseFzmmScreen.checkNull((Component)this.patternsLayout, "flow-layout", PATTERNS_LAYOUT);
    }

    @Override
    public void update(BannerEditorScreen parent, BannerBuilder currentBanner, class_1767 color) {
        this.patternsLayout.clearChildren();
        ArrayList<Component> bannerList = new ArrayList<Component>();
        class_2582 basePattern = (class_2582)class_7923.field_41165.method_29107(class_7446.field_39151);
        if (basePattern == null) {
            FzmmClient.LOGGER.error("[Banner editor: add pattern] base pattern is null");
            return;
        }
        for (class_2582 pattern : class_7923.field_41165.method_10220().toList()) {
            if (basePattern == pattern) continue;
            class_1799 banner = currentBanner.copy().addPattern(color, pattern).get();
            Component itemComponent = Components.item((class_1799)banner).sizing(Sizing.fixed((int)32), Sizing.fixed((int)32));
            itemComponent.mouseDown().subscribe((mouseX, mouseY, button) -> {
                UISounds.playButtonSound();
                parent.addUndo(currentBanner);
                currentBanner.addPattern(color, pattern);
                parent.updatePreview(currentBanner);
                return true;
            });
            itemComponent.cursorStyle(CursorStyle.HAND);
            bannerList.add(itemComponent);
        }
        this.patternsLayout.children(bannerList);
    }
}

