/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.banner_editor.tabs;

import fzmm.zailer.me.builders.BannerBuilder;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.banner_editor.BannerEditorScreen;
import fzmm.zailer.me.client.gui.banner_editor.tabs.IBannerEditorTab;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Sizing;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7446;

public abstract class AbstractModifyPatternsTab
implements IBannerEditorTab {
    protected FlowLayout patternsLayout;

    @Override
    public void setupComponents(FlowLayout rootComponent) {
        this.patternsLayout = (FlowLayout)rootComponent.childById(FlowLayout.class, this.getGridId());
        BaseFzmmScreen.checkNull((Component)this.patternsLayout, "flow-layout", this.getGridId());
    }

    protected abstract String getGridId();

    public abstract boolean shouldAddBaseColor();

    @Override
    public void update(BannerEditorScreen parent, BannerBuilder currentBanner, class_1767 color) {
        this.patternsLayout.clearChildren();
        ArrayList<ItemComponent> bannerList = new ArrayList<ItemComponent>();
        BannerBuilder builder = currentBanner.copy().clearPatterns();
        class_2499 patterns = currentBanner.patterns();
        if (this.shouldAddBaseColor()) {
            patterns = currentBanner.copy().clearPatterns().addPattern(currentBanner.bannerColor(), (class_5321<class_2582>)class_7446.field_39151).addPatterns(patterns).patterns();
        }
        for (class_2520 pattern : patterns) {
            builder.addPattern(pattern);
            ItemComponent itemComponent = Components.item((class_1799)builder.copy().get());
            itemComponent.sizing(Sizing.fixed((int)32), Sizing.fixed((int)32));
            this.onItemComponentCreated(parent, itemComponent, pattern, currentBanner, color);
            itemComponent.cursorStyle(CursorStyle.HAND);
            Optional<class_2561> tooltip = this.getTooltip(parent, pattern, currentBanner, color);
            tooltip.ifPresent(arg_0 -> ((ItemComponent)itemComponent).tooltip(arg_0));
            bannerList.add(itemComponent);
        }
        this.patternsLayout.children(bannerList);
    }

    protected abstract void onItemComponentCreated(BannerEditorScreen var1, ItemComponent var2, class_2520 var3, BannerBuilder var4, class_1767 var5);

    protected Optional<class_2561> getTooltip(BannerEditorScreen parent, class_2520 pattern, BannerBuilder currentBanner, class_1767 color) {
        if (pattern instanceof class_2487) {
            class_2487 patternCompound = (class_2487)pattern;
            class_1767 patternColor = class_1767.method_7791((int)patternCompound.method_10550("Color"));
            class_6880 patternRegistry = class_2582.method_10946((String)patternCompound.method_10558("Pattern"));
            return Optional.of(BannerBuilder.tooltipOf(patternColor, (class_6880<class_2582>)patternRegistry));
        }
        return Optional.empty();
    }
}

